/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util.fft;

import com.momo.mcamera.util.fft.FourierTransform;

public class FFT
extends FourierTransform {
    public static final int a = 256;
    public static final int b = 512;
    public static final int c = 1024;
    public static final int d = 2048;
    public static final int e = 4096;
    private int[] t;
    private float[] u;
    private float[] v;

    /*
     * WARNING - void declaration
     */
    public FFT(int timeSize) {
        super(timeSize);
        void var1_1;
        if ((timeSize & var1_1 - true) != 0) {
            throw new IllegalArgumentException("FFT: timeSize must be a power of two.");
        }
        this.e();
        this.g();
    }

    @Override
    protected final void a() {
        this.o = new float[this.j / 2 + 1];
        this.m = new float[this.j];
        this.n = new float[this.j];
    }

    @Override
    public final void a(int n, float f2) {
        if (f2 < 0.0f) {
            return;
        }
        int n2 = n;
        this.m[n2] = this.m[n2] * f2;
        int n3 = n;
        this.n[n3] = this.n[n3] * f2;
        int n4 = n;
        this.o[n4] = this.o[n4] * f2;
        if (n != 0 && n != this.j / 2) {
            this.m[this.j - n] = this.m[n];
            this.n[this.j - n] = -this.n[n];
        }
    }

    @Override
    public final void b(int n, float f2) {
        if (f2 < 0.0f) {
            return;
        }
        if (this.m[n] == 0.0f && this.n[n] == 0.0f) {
            this.m[n] = f2;
            this.o[n] = f2;
        } else {
            int n2 = n;
            this.m[n2] = this.m[n2] / this.o[n];
            int n3 = n;
            this.n[n3] = this.n[n3] / this.o[n];
            this.o[n] = f2;
            int n4 = n;
            this.m[n4] = this.m[n4] * this.o[n];
            int n5 = n;
            this.n[n5] = this.n[n5] * this.o[n];
        }
        if (n != 0 && n != this.j / 2) {
            this.m[this.j - n] = this.m[n];
            this.n[this.j - n] = -this.n[n];
        }
    }

    private void d() {
        for (int k = 1; k < this.m.length; k <<= 1) {
            int n = k;
            float f2 = this.v[n];
            n = k;
            float f3 = this.u[n];
            float f4 = 1.0f;
            float f5 = 0.0f;
            for (int i2 = 0; i2 < k; ++i2) {
                for (int i3 = i2; i3 < this.m.length; i3 += 2 * k) {
                    int n2 = i3 + k;
                    float f6 = f4 * this.m[n2] - f5 * this.n[n2];
                    float f7 = f4 * this.n[n2] + f5 * this.m[n2];
                    this.m[n2] = this.m[i3] - f6;
                    this.n[n2] = this.n[i3] - f7;
                    int n3 = i3;
                    this.m[n3] = this.m[n3] + f6;
                    int n4 = i3;
                    this.n[n4] = this.n[n4] + f7;
                }
                float f8 = f4;
                f4 = f8 * f2 - f5 * f3;
                f5 = f8 * f3 + f5 * f2;
            }
        }
    }

    @Override
    public final void a(float[] fArray) {
        if (fArray.length != this.j) {
            return;
        }
        this.b(fArray, 0);
        this.d();
        this.b();
    }

    @Override
    public final void a(float[] fArray, int n) {
        if (fArray.length - n < this.j) {
            return;
        }
        this.b(fArray, n);
        this.d();
        this.b();
    }

    private void b(float[] fArray, float[] fArray2) {
        if (fArray.length != this.j || fArray2.length != this.j) {
            return;
        }
        this.a(fArray, fArray2);
        this.f();
        this.d();
        this.b();
    }

    @Override
    public final void b(float[] fArray) {
        if (fArray.length > this.m.length) {
            return;
        }
        int n = 0;
        while (n < this.j) {
            int n2 = n++;
            this.n[n2] = -this.n[n2];
        }
        this.f();
        this.d();
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = this.m[n] / (float)this.m.length;
        }
    }

    private void e() {
        int n = this.j;
        this.t = new int[n];
        this.t[0] = 0;
        int n2 = 1;
        int n3 = n / 2;
        while (n2 < n) {
            for (int k = 0; k < n2; ++k) {
                this.t[k + n2] = this.t[k] + n3;
            }
            n2 <<= 1;
            n3 >>= 1;
        }
    }

    private void b(float[] fArray, int n) {
        for (int k = 0; k < this.j; ++k) {
            this.m[k] = fArray[n + this.t[k]];
            this.n[k] = 0.0f;
        }
    }

    private void f() {
        float[] fArray = new float[this.m.length];
        float[] fArray2 = new float[this.n.length];
        for (int k = 0; k < this.m.length; ++k) {
            fArray[k] = this.m[this.t[k]];
            fArray2[k] = this.n[this.t[k]];
        }
        this.m = fArray;
        this.n = fArray2;
    }

    private float b(int n) {
        return this.u[n];
    }

    private float c(int n) {
        return this.v[n];
    }

    private void g() {
        int n = this.j;
        this.u = new float[n];
        this.v = new float[n];
        for (int k = 0; k < n; ++k) {
            this.u[k] = (float)Math.sin((float)(-Math.PI) / (float)k);
            this.v[k] = (float)Math.cos((float)(-Math.PI) / (float)k);
        }
    }
}

