/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.text.TextUtils;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.h.c;
import com.momo.mcamera.mask.z;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class FaceBlushFilter
extends BasicFilter
implements FaceDetectInterface {
    private int maskTexture = 0;
    private String mImagePath = null;
    private MMCVInfo mMmcvInfo = null;
    private boolean bitMapChanged = false;
    private z glFaceBlendProgram = new z();

    public FaceBlushFilter() {
        if (this.glFaceBlendProgram != null) {
            this.glFaceBlendProgram.a(4);
            this.glFaceBlendProgram.a("Normal");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setImagePath(String path) {
        void var1_1;
        if (path == null || path.isEmpty()) {
            return;
        }
        this.mImagePath = var1_1;
        this.bitMapChanged = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setIntensity(float value) {
        if (this.glFaceBlendProgram != null) {
            void var1_1;
            this.glFaceBlendProgram.a = var1_1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var3_4;
            void var2_3;
            void var1_1;
            if ((this.maskTexture == 0 || this.bitMapChanged) && !TextUtils.isEmpty((CharSequence)this.mImagePath)) {
                MMFrameInfo mMFrameInfo = new MMFrameInfo();
                ImageUtils.decodeMMCVImage((MMFrameInfo)mMFrameInfo, (String)this.mImagePath);
                if (mMFrameInfo.getDataPtr() != null && mMFrameInfo.getWidth() > 0 && mMFrameInfo.getHeight() > 0) {
                    this.maskTexture = this.maskTexture == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)mMFrameInfo) : TextureHelper.loadDataToTexture((int)this.maskTexture, (MMFrameInfo)mMFrameInfo);
                }
                this.bitMapChanged = false;
            }
            super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_3, (boolean)var3_4);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            if (mmcvInfo == null) {
                return;
            }
            this.mMmcvInfo = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        super.drawSub();
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mMmcvInfo != null && this.mMmcvInfo.getMaxFaceCnt() > 0) {
                for (int i2 = 0; i2 < this.mMmcvInfo.getMaxFaceCnt(); ++i2) {
                    if (this.glFaceBlendProgram == null || this.maskTexture == 0) continue;
                    int[] nArray = new int[]{this.texture_in, this.maskTexture};
                    float[][] fArray = c.c(this.landMark104ToPoint(this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104(), this.getWidth(), this.getHeight()));
                    this.glFaceBlendProgram.b(fArray, nArray);
                }
            }
            return;
        }
    }

    public void destroy() {
        super.destroy();
        if (this.maskTexture != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.maskTexture;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.maskTexture = 0;
        }
    }

    private float[] landMark104ToPoint(float[] landmarks104, float width, float height) {
        float[] fArray = new float[landmarks104.length];
        int n2 = landmarks104.length;
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            fArray[i2] = landmarks104[i2] / width;
            fArray[i2 + n2 / 2] = landmarks104[i2 + n2 / 2] / height;
        }
        return fArray;
    }
}

