/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import com.core.glcore.util.FileUtil;
import com.core.glcore.util.JsonUtil;
import com.momo.mcamera.filtermanager.MMPresetFilterStore;
import com.momo.mcamera.mask.LookUpModel;
import com.momo.mcamera.mask.Mask;
import com.momo.mcamera.mask.MaskModel;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.bean.EffectFilterItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MaskStore {
    private static MaskStore ourInstance = new MaskStore();
    private final String PATH_FOLDER = "stickers";
    private String folderPath;

    private MaskStore() {
    }

    public static MaskStore getInstance() {
        return ourInstance;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setFolderPath(String folderPath) {
        void var1_1;
        this.folderPath = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String getMaskFolder(Context context, String folderName) {
        void var2_2;
        return Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + (String)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public List<MaskModel> getGestureMasks(Context context) {
        void var1_1;
        return this.getMasksByFolderName((Context)var1_1, "MaskG");
    }

    /*
     * WARNING - void declaration
     */
    public List<MaskModel> getMasks(Context context) {
        void var1_1;
        return this.getMasksByFolderName((Context)var1_1, "Mask");
    }

    private List<MaskModel> getMasksByFolderName(Context context, String name) {
        Object[] objectArray;
        ArrayList<MaskModel> arrayList = new ArrayList<MaskModel>();
        FileUtil.checkFile((String)this.getMaskFolder(context, name));
        objectArray = new File(this.getMaskFolder(context, (String)objectArray)).listFiles();
        if (objectArray == null) {
            return arrayList;
        }
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            MaskModel maskModel = this.getMask(context, ((File)object).getPath());
            if (maskModel == null) continue;
            arrayList.add(maskModel);
            for (Sticker sticker : maskModel.getStickers()) {
                sticker.setFrameRate(maskModel.frameRate);
                sticker.setImageFolderPath(((File)object).getPath());
            }
        }
        return arrayList;
    }

    public MaskModel getMask(Context context, String folderPath) {
        File file = new File(folderPath);
        MaskModel maskModel = null;
        Iterator<Sticker> iterator = file.getPath() + "/params.txt";
        if (!FileUtil.exist((String)((Object)iterator))) {
            iterator = file.getPath() + "/params.json";
        }
        if (!TextUtils.isEmpty((CharSequence)((Object)(iterator = JsonUtil.getInstance().jsonStringFromFile(context, (String)((Object)iterator)))))) {
            Object object;
            Object object2;
            try {
                maskModel = (MaskModel)JsonUtil.getInstance().fromJson((String)((Object)iterator), MaskModel.class);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            if (maskModel.getStickers() == null) {
                maskModel.setStickers(new ArrayList<Sticker>());
            }
            if (FileUtil.exist((String)(file.getPath() + "/preview.png"))) {
                maskModel.setPreviewPath(file.getPath() + "/preview.png");
            } else {
                iterator = maskModel.getStickers().iterator();
                if (iterator.hasNext()) {
                    Sticker object3 = (Sticker)iterator.next();
                    object3.setImageFolderPath(folderPath);
                    maskModel.setPreviewPath(object3.getImagePathByIndex(context, 0));
                }
            }
            if (maskModel != null && !TextUtils.isEmpty((CharSequence)maskModel.getSound())) {
                maskModel.setSoundPath(file.getPath() + "/" + maskModel.getSound());
            }
            maskModel.setFolderPath(folderPath);
            if (null != maskModel.getLookUpFilters()) {
                for (LookUpModel lookUpModel : maskModel.getLookUpFilters()) {
                    lookUpModel.setPresetFilter(MMPresetFilterStore.getPresetFilterByFolder(context, file.getPath() + "/" + lookUpModel.getFolder()));
                    object2 = new Sticker();
                    ((Sticker)object2).setStickerType("FACE_LOOK_UP_TYPE");
                    ((Sticker)object2).setTriggerType(lookUpModel.getTriggerType());
                    ((Sticker)object2).setLookUpModel(lookUpModel);
                    ((Sticker)object2).setHiddenTriggerType(lookUpModel.getHiddenTriggerType());
                    maskModel.getStickers().add(0, (Sticker)object2);
                }
            }
            if (null != maskModel.getMasks()) {
                for (Mask mask : maskModel.getMasks()) {
                    object2 = file.getPath() + "/" + mask.getFolder() + "/metadata.json";
                    String string = JsonUtil.getInstance().jsonStringFromFile(context, (String)object2);
                    object = (Mask)JsonUtil.getInstance().fromJson(string, Mask.class);
                    if (object == null || ((Mask)object).landmarks == null) continue;
                    mask.landmarks = ((Mask)object).landmarks;
                    mask.setTexturePath(file.getPath() + "/" + mask.getFolder() + "/texture.png");
                    object2 = new Sticker();
                    ((Sticker)object2).setStickerType("FACE_MASK_TYPE");
                    ((Sticker)object2).setTriggerType(mask.getTriggerType());
                    ((Sticker)object2).setHiddenTriggerType(mask.getHiddenTriggerType());
                    ((Sticker)object2).setMask(mask);
                    maskModel.getStickers().add(0, (Sticker)object2);
                }
            }
            if (null != maskModel.getDistortionList()) {
                for (Mask mask : maskModel.getDistortionList()) {
                    maskModel.setFaceScale(mask.getStrength());
                    maskModel.setFaceFacialFeatureScale(mask.getStrengthB());
                    maskModel.setWrapType(mask.getType());
                    int n2 = mask.getTriggerType();
                    int n3 = mask.getHiddenTriggerType();
                    object = new Sticker();
                    ((Sticker)object).setTriggerType(n2);
                    ((Sticker)object).setHiddenTriggerType(n3);
                    ((Sticker)object).setMask(mask);
                    maskModel.getStickers().add(0, (Sticker)object);
                }
            }
            if (maskModel.spectrumSticker != null) {
                maskModel.spectrumSticker.setStickerType("STICKER_TYPE_VOICE");
                maskModel.getStickers().add(maskModel.spectrumSticker);
            }
            for (Sticker sticker : maskModel.getStickers()) {
                sticker.setFrameRate(maskModel.frameRate);
                sticker.setImageFolderPath(file.getPath());
                if ("3d".equals(sticker.getLayerType())) {
                    String string = folderPath.substring(0, folderPath.lastIndexOf("/"));
                    maskModel.setXengineEsPath(string);
                    sticker.setXengineEsPath(string);
                }
                if (maskModel.getAdditionalInfo() == null) continue;
                sticker.setComic(maskModel.getAdditionalInfo().isComic());
            }
            if (null != maskModel.getEffectList()) {
                iterator = maskModel.getEffectList().iterator();
                while (iterator.hasNext()) {
                    ((EffectFilterItem)iterator.next()).setImageFolderPath(folderPath);
                }
            }
        }
        return maskModel;
    }
}

