/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.filtermanager;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.core.glcore.util.FileUtil;
import com.core.glcore.util.JsonUtil;
import com.momo.mcamera.filtermanager.MMFilterConfig;
import com.momo.mcamera.filtermanager.MMPresetFilter;
import com.momo.mcamera.filtermanager.MMProcessUnit;
import com.momo.mcamera.filtermanager.filterext.BitmapBlendFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import project.android.imageprocessing.filter.colour.LookupFilter;
import project.android.imageprocessing.filter.colour.NormalFilter;
import project.android.imageprocessing.filter.effect.ColorHalftoneFilter;
import project.android.imageprocessing.filter.effect.DotScreenFilter;
import project.android.imageprocessing.filter.effect.SketchFilter;
import project.android.imageprocessing.filter.effect.TVArtifactFilter;
import project.android.imageprocessing.filter.glitter.GlitterFilter;
import project.android.imageprocessing.filter.processing.EyeEffectFilter;
import project.android.imageprocessing.filter.processing.SplitPersonFilter;
import project.android.imageprocessing.filter.processing.SplitPersonVerticalFilter;
import project.android.imageprocessing.filter.processing.WaterReflectionFilter;

public class MMPresetFilterStore {
    public static final String PATH_SHADER = "light_room_filters";

    public static String getFilterFolder(Context context) {
        Object object = MMPresetFilterStore.getDataFilterFolder(context);
        File file = new File((String)object);
        if (!file.exists()) {
            file.mkdir();
        }
        return object;
    }

    public static String getDataFilterFolder(Context context) {
        return FileUtil.getCacheDirectory((Context)context).getPath();
    }

    public static List<MMPresetFilter> generateProcessFilters(Context context, String defaultPath) {
        Object[] objectArray;
        ArrayList<MMPresetFilter> arrayList = new ArrayList<MMPresetFilter>();
        String string = MMPresetFilterStore.getFilterFolder(context);
        objectArray = new File(string + "/" + (String)objectArray).listFiles();
        if (objectArray == null) {
            return arrayList;
        }
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            if ((object = MMPresetFilterStore.getPresetFilterByFolder(context, ((File)object).getPath())) == null) continue;
            arrayList.add((MMPresetFilter)object);
        }
        return arrayList;
    }

    public static MMPresetFilter getPresetFilterByFolder(Context context, String folderPath) {
        Context context2;
        File file;
        file = new File((String)((Object)file));
        MMPresetFilter mMPresetFilter = new MMPresetFilter(context);
        new MMPresetFilter(context).mFilterName = file.getName();
        if (null == file.list()) {
            return null;
        }
        MMPresetFilterStore.generateFilter(context2, file, mMPresetFilter);
        return mMPresetFilter;
    }

    /*
     * WARNING - void declaration
     */
    public static void generateFilter(Context context, File folder, MMPresetFilter filter) {
        void var2_2;
        if (folder == null || folder.list() == null || folder.list().length == 0) {
            return;
        }
        Object object = Arrays.asList(folder.list());
        ArrayList<MMProcessUnit> arrayList = new ArrayList<MMProcessUnit>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            String string = (String)object.next();
            if (string.contains("Lookup.png") || string.contains("lookup.png")) {
                object2 = new MMProcessUnit(0);
                ((MMProcessUnit)object2).setFilterName(LookupFilter.class.getName());
                ((MMProcessUnit)object2).setTexturePath1(folder.getPath() + "/" + string);
                arrayList.add((MMProcessUnit)object2);
            } else if (string.contains("overlays")) {
                object2 = new File(folder.getPath() + "/overlays");
                if (((File)object2).exists()) {
                    object2 = ((File)object2).listFiles();
                    int n2 = ((File[])object2).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        MMProcessUnit mMProcessUnit;
                        Serializable serializable = object2[i2];
                        Object object3 = ((File)serializable).getName();
                        Object object4 = ((String)object3).split("\\.");
                        if (((String[])object4).length != 3) continue;
                        if ((object4 = object4[1]).contains("Lookup")) {
                            mMProcessUnit = new MMProcessUnit(0);
                            mMProcessUnit.setFilterName(LookupFilter.class.getName());
                            mMProcessUnit.setTexturePath1(folder.getPath() + "/overlays/" + (String)object3);
                            arrayList.add(mMProcessUnit);
                            continue;
                        }
                        mMProcessUnit = new MMProcessUnit(0);
                        mMProcessUnit.setFilterName(BitmapBlendFilter.class.getName());
                        object3 = new HashMap<String, String[]>();
                        ((HashMap)object3).put("setBlendType", object4);
                        mMProcessUnit.setFilterMap((HashMap<String, Object>)object3);
                        mMProcessUnit.setTexturePath1(((File)serializable).getAbsolutePath());
                        arrayList.add(mMProcessUnit);
                    }
                }
            } else if (string.contains("Classic.Dark.png")) {
                object2 = new MMProcessUnit(0);
                ((MMProcessUnit)object2).setFilterName(BitmapBlendFilter.class.getName());
                ((MMProcessUnit)object2).setTexturePath1(folder.getPath() + "/Classic.Light.png");
                arrayList.add((MMProcessUnit)object2);
            } else if (string.contains("manifest.json")) {
                object2 = new File(folder.getPath() + "/manifest.json");
                String string2 = JsonUtil.getInstance().jsonStringFromFile(context, ((File)object2).getAbsolutePath()).trim();
                if (!TextUtils.isEmpty((CharSequence)string2) && (object2 = (MMFilterConfig)JsonUtil.buildInGson().fromJson(string2, MMFilterConfig.class)) != null && null != ((MMFilterConfig)object2).getFilterExt()) {
                    for (MMProcessUnit mMProcessUnit : ((MMFilterConfig)object2).getFilterExt()) {
                        if (!TextUtils.isEmpty((CharSequence)mMProcessUnit.getFilterName())) {
                            mMProcessUnit.setFilterName(MMPresetFilterStore.convertClassName(mMProcessUnit.getFilterName()));
                        }
                        arrayList.add(mMProcessUnit);
                        if (!mMProcessUnit.isDecoration()) continue;
                        mMProcessUnit.setResourceName(folder.getPath() + "/" + mMProcessUnit.getResourceName());
                    }
                    if (!TextUtils.isEmpty((CharSequence)((MMFilterConfig)object2).getDisplayName())) {
                        filter.mFilterName = ((MMFilterConfig)object2).getDisplayName();
                    }
                }
            } else if (string.contains("Classic.Light.png") && ((File)(object2 = new File(folder.getPath() + "/Classic.Light.png"))).exists() && ((File)object2).length() > 0L) {
                MMProcessUnit mMProcessUnit = new MMProcessUnit(0);
                mMProcessUnit.setFilterName(BitmapBlendFilter.class.getName());
                mMProcessUnit.setTexturePath1(((File)object2).getAbsolutePath());
                arrayList.add(mMProcessUnit);
            }
            if (string.length() != 0) continue;
            object2 = new MMProcessUnit(0);
            ((MMProcessUnit)object2).setFilterName(NormalFilter.class.getName());
            arrayList.add((MMProcessUnit)object2);
        }
        var2_2.setProcessUnits(arrayList);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static Bitmap getBitmapWithPath(String path, Context context) {
        Bitmap bitmap;
        block10: {
            String string;
            void var1_2;
            InputStream inputStream = null;
            bitmap = null;
            inputStream = var1_2.getResources().getAssets().open(string);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block10;
            catch (IOException iOException) {
                try {
                    iOException.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
            }
        }
        return bitmap;
    }

    public static String convertClassName(String name) {
        String string;
        if (name.equals("SketchFilter")) {
            return SketchFilter.class.getName();
        }
        if (name.equals("GlitterFilter")) {
            return GlitterFilter.class.getName();
        }
        if (name.equals("TVArtifactFilter")) {
            return TVArtifactFilter.class.getName();
        }
        if (name.equals("DotScreenFilter")) {
            return DotScreenFilter.class.getName();
        }
        if (name.equals("ColorHalftoneFilter")) {
            return ColorHalftoneFilter.class.getName();
        }
        if (name.equals("EyeEffectFilter")) {
            return EyeEffectFilter.class.getName();
        }
        if (name.equals("SplitPersonVerticalFilter")) {
            return SplitPersonVerticalFilter.class.getName();
        }
        if (name.equals("SplitPersonFilter")) {
            return SplitPersonFilter.class.getName();
        }
        if (name.equals("WaterReflectionFilter")) {
            return WaterReflectionFilter.class.getName();
        }
        return string;
    }
}

