/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import com.momo.mcamera.mask.TriggerBlendFilter;

public class ArtifactframeFilter
extends TriggerBlendFilter {
    private static final String UNIFORM_MAXH = "maximumHorizontalDisplacement";
    private static final String UNIFORM_MAXV = "maximumVerticalDisplacement";
    private static final String UNIFORM_HORD = "horizontalDisplacementComponent";
    private static final String UNIFORM_VERD = "verticalDisplacementComponent";
    private static final String UNIFORM_TEXW = "textureWidth";
    private static final String UNIFORM_TEXH = "textureHeight";
    private int maxHHandler;
    private int maxVHandler;
    private int hordHandler;
    private int verdHandler;
    private int texwHandler;
    private int texhHandler;
    private float maxHfault = 0.0f;
    private float maxVfault = 0.0f;

    @Override
    protected String getFragmentShader() {
        return "precision highp float;\nvarying highp vec2 textureCoordinate;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform float maximumHorizontalDisplacement;\nuniform float maximumVerticalDisplacement;\nuniform int horizontalDisplacementComponent;\nuniform int verticalDisplacementComponent;\nuniform float textureWidth;\nuniform float textureHeight;\nvoid main() {\n    vec4 displacement = texture2D(inputImageTexture1,textureCoordinate);\n    float h = displacement.x ; \n    float v = displacement.x ;\n    float hOffset = (h - 0.5) * 2.0 * maximumHorizontalDisplacement;\n    float vOffset = (v -0.5) * 2.0 * maximumVerticalDisplacement;\n    vec2 textureSize = vec2(textureWidth, textureHeight);\n    const int count = 8;\n    vec2 subSampleOffsets[count];\n    subSampleOffsets[0] = vec2( 0.0625, -0.1875);\n    subSampleOffsets[1] = vec2(-0.0625,  0.1875);\n    subSampleOffsets[2] = vec2( 0.3125,  0.0625);\n    subSampleOffsets[3] = vec2(-0.1875, -0.3125);\n    subSampleOffsets[4] = vec2(-0.3125,  0.3125);\n    subSampleOffsets[5] = vec2(-0.4375, -0.0625);\n    subSampleOffsets[6] = vec2( 0.1875,  0.4375);\n    subSampleOffsets[7] = vec2( 0.4375, -0.4375);\n    vec2 textureCoordinates[count];\n    for (int i = 0; i < count; i += 1) {\n        textureCoordinates[i] = textureCoordinate + subSampleOffsets[i]/textureSize;\n    }\n    vec4 color = vec4(0.0, 0.0, 0.0, 0.0);\n    float count1 = float(count); vec4 origin;\n    for (int i = 0; i < count; i += 1) {\n       origin   = texture2D(inputImageTexture0, textureCoordinates[i] + vec2(hOffset, vOffset));\n       color += origin/count1;\n    }\n    gl_FragColor =  color;\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.maxHHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MAXH);
        this.maxVHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MAXV);
        this.hordHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_HORD);
        this.verdHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_VERD);
        this.texwHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXW);
        this.texhHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXH);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.maxHHandler, (float)this.maxHfault);
        GLES20.glUniform1f((int)this.maxVHandler, (float)this.maxVfault);
        GLES20.glUniform1i((int)this.hordHandler, (int)0);
        GLES20.glUniform1i((int)this.verdHandler, (int)0);
        GLES20.glUniform1f((int)this.texwHandler, (float)this.getWidth());
        GLES20.glUniform1f((int)this.texhHandler, (float)this.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    public void setFaultInfo(float maxHfault, float maxVfault) {
        void var2_2;
        void var1_1;
        this.maxHfault = var1_1;
        this.maxVfault = var2_2;
    }
}

