/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeview;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.momo.test.Logger;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.xnative.XEWindow;
import com.momo.xeview.GLTextureView;
import com.momo.xeview.XeViewConfig;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class XeRenderView
extends FrameLayout {
    private boolean isMultipleTouchEnabled = true;
    private boolean isTouchModeEnable = true;
    GLSurfaceView mGLSurfaceView;
    GLTextureView mGLTextureView;
    XeViewConfig mConfig;
    XeSurfaceCallback mXeSurfaceCallback;
    GLTextureView.EGLContextFactory mTextureFactory;
    GLSurfaceView.EGLContextFactory mSurfaceFactory;

    public XeRenderView(Context context) {
        this(context, null);
    }

    public XeRenderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setFocusableInTouchMode(true);
    }

    public void config(XeViewConfig config) {
        this.mConfig = config;
    }

    public void setSurfaceSharedContext(final EGLContext sharedContext) {
        this.mSurfaceFactory = new GLSurfaceView.EGLContextFactory(){
            private int EGL_CONTEXT_CLIENT_VERSION = 12440;

            public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
                int[] attrib_list = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
                return egl.eglCreateContext(display, config, sharedContext, attrib_list);
            }

            public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
                if (!egl.eglDestroyContext(display, context)) {
                    Log.e((String)"xeview...", (String)"destroyContext: ");
                }
            }
        };
    }

    public void setTextureSharedCotnext(EGLContext sharedContext) {
        this.mTextureFactory = new TextureViewContextFactory(sharedContext);
    }

    public void setTouchEnable(boolean enable) {
        this.setEnabled(enable);
        this.setTouchModeEnable(enable);
        this.setFocusableInTouchMode(enable);
        if (this.mGLSurfaceView != null) {
            this.mGLSurfaceView.setFocusableInTouchMode(enable);
        }
        if (this.mGLTextureView != null) {
            this.mGLTextureView.setFocusableInTouchMode(enable);
        }
    }

    public void prepare(XeSurfaceCallback xeSurfaceCallback) {
        this.mXeSurfaceCallback = xeSurfaceCallback;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.removeAllViews();
        if (this.mConfig.mRenderViewImpl == 0) {
            this.mGLSurfaceView = new GLSurfaceView(this.getContext());
            this.mGLSurfaceView.setEGLContextClientVersion(2);
            this.mGLSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
            this.mGLSurfaceView.getHolder().setFormat(-3);
            this.mGLSurfaceView.setBackgroundColor(0);
            this.mGLSurfaceView.setZOrderOnTop(true);
            this.mGLSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new GLSurfaceCallback());
            if (this.mSurfaceFactory != null) {
                this.mGLSurfaceView.setEGLContextFactory(this.mSurfaceFactory);
            }
            this.mGLSurfaceView.setRenderer((GLSurfaceView.Renderer)new GLSurfaceRender());
            this.addView((View)this.mGLSurfaceView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            this.mGLTextureView = new GLTextureView(this.getContext());
            this.mGLTextureView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
            this.mGLTextureView.setEGLContextClientVersion(2);
            this.mGLTextureView.setOpaque(false);
            if (this.mTextureFactory != null) {
                this.mGLTextureView.setEGLContextFactory(this.mTextureFactory);
            }
            this.mGLTextureView.setRenderer(new GLTextureRender());
            this.addView((View)this.mGLTextureView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void requestRender() {
        if (this.mGLSurfaceView != null) {
            this.mGLSurfaceView.requestRender();
        }
        if (this.mGLTextureView != null) {
            this.mGLTextureView.requestRender();
        }
    }

    public void onResume() {
        if (this.mGLSurfaceView != null) {
            this.mGLSurfaceView.onResume();
        }
    }

    public void onPause() {
        Logger.d("lcc_onPause");
        if (this.mGLSurfaceView != null) {
            this.mGLSurfaceView.onPause();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isTouchModeEnable) {
            return super.onTouchEvent(event);
        }
        final int pointerNumber = event.getPointerCount();
        final int[] ids = new int[pointerNumber];
        final float[] xs = new float[pointerNumber];
        final float[] ys = new float[pointerNumber];
        for (int i = 0; i < pointerNumber; ++i) {
            ids[i] = event.getPointerId(i);
            xs[i] = event.getX(i);
            ys[i] = event.getY(i);
        }
        XE3DEngine engine = XE3DEngine.getInstance();
        final XEWindow window = engine.getWindow();
        if (window == null) {
            return true;
        }
        block0 : switch (event.getAction() & 0xFF) {
            case 5: {
                int indexPointerDown = event.getAction() >> 8;
                if (!this.isMultipleTouchEnabled && indexPointerDown != 0) break;
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesBegin(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 0: {
                int idDown = event.getPointerId(0);
                float xDown = xs[0];
                float yDown = ys[0];
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesBegin(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 2: {
                if (!this.isMultipleTouchEnabled) {
                    for (int i = 0; i < pointerNumber; ++i) {
                        if (ids[i] != 0) continue;
                        int[] idsMove = new int[]{0};
                        final float[] xsMove = new float[]{xs[i]};
                        final float[] ysMove = new float[]{ys[i]};
                        engine.queueEvent(new Runnable(){

                            @Override
                            public void run() {
                                window.handleTouchesMove(pointerNumber, ids, xsMove, ysMove);
                            }
                        });
                        break block0;
                    }
                    break;
                }
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesMove(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 6: {
                int indexPointUp = event.getAction() >> 8;
                if (!this.isMultipleTouchEnabled && indexPointUp != 0) break;
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 1: {
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 3: {
                if (!this.isMultipleTouchEnabled) {
                    for (int i = 0; i < pointerNumber; ++i) {
                        if (ids[i] != 0) continue;
                        int[] idsCancel = new int[]{0};
                        final float[] xsCancel = new float[]{xs[i]};
                        final float[] ysCancel = new float[]{ys[i]};
                        engine.queueEvent(new Runnable(){

                            @Override
                            public void run() {
                                window.handleTouchesCancel(pointerNumber, ids, xsCancel, ysCancel);
                            }
                        });
                        break block0;
                    }
                    break;
                }
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
        }
        return true;
    }

    public void setMultipleTouchEnabled(boolean multipleTouchEnabled) {
        this.isMultipleTouchEnabled = multipleTouchEnabled;
    }

    public void setTouchModeEnable(boolean touchModeEnable) {
        this.isTouchModeEnable = touchModeEnable;
    }

    public static interface XeSurfaceCallback {
        public void onSurfacePrepared();

        public void onSurfaceChanged(int var1, int var2);

        public void onDrawFrame();

        public void onDestroyed();
    }

    private class GLTextureRender
    implements GLTextureView.Renderer {
        private GLTextureRender() {
        }

        @Override
        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            if (XeRenderView.this.mXeSurfaceCallback != null) {
                XeRenderView.this.mXeSurfaceCallback.onSurfacePrepared();
            }
        }

        @Override
        public void onSurfaceChanged(GL10 gl, int width, int height) {
            if (XeRenderView.this.mXeSurfaceCallback != null) {
                XeRenderView.this.mXeSurfaceCallback.onSurfaceChanged(width, height);
            }
        }

        @Override
        public void onDrawFrame(GL10 gl) {
            if (XeRenderView.this.mXeSurfaceCallback != null) {
                XeRenderView.this.mXeSurfaceCallback.onDrawFrame();
            }
        }

        @Override
        public void onDestroyed() {
            if (XeRenderView.this.mXeSurfaceCallback != null) {
                XeRenderView.this.mXeSurfaceCallback.onDestroyed();
            }
        }
    }

    private class GLSurfaceCallback
    implements SurfaceHolder.Callback {
        private GLSurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            Logger.d("surfaceCreated");
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            Logger.d("surfaceChanged");
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            Logger.d("surfaceDestroyed");
            if (XeRenderView.this.mXeSurfaceCallback != null) {
                XeRenderView.this.mXeSurfaceCallback.onDestroyed();
            }
        }
    }

    private class GLSurfaceRender
    implements GLSurfaceView.Renderer {
        private GLSurfaceRender() {
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            if (XeRenderView.this.mXeSurfaceCallback != null) {
                XeRenderView.this.mXeSurfaceCallback.onSurfacePrepared();
            }
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            if (XeRenderView.this.mXeSurfaceCallback != null) {
                XeRenderView.this.mXeSurfaceCallback.onSurfaceChanged(width, height);
            }
        }

        public void onDrawFrame(GL10 gl) {
            if (XeRenderView.this.mXeSurfaceCallback != null) {
                XeRenderView.this.mXeSurfaceCallback.onDrawFrame();
            }
        }
    }

    private class TextureViewContextFactory
    implements GLTextureView.EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;
        EGLContext mEGLContext;

        public TextureViewContextFactory(EGLContext sharedContext) {
            this.mEGLContext = sharedContext;
        }

        @Override
        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attrib_list = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            return egl.eglCreateContext(display, config, this.mEGLContext, attrib_list);
        }

        @Override
        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            if (!egl.eglDestroyContext(display, context)) {
                Log.e((String)"xeview...", (String)"destroyContext: ");
            }
        }
    }
}

