/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.xnative;

import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.Log;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.event.DataEvent;
import com.momo.xeengine.event.XEvent;
import com.momo.xeengine.xnative.XEMessageManager;
import com.momo.xeengine.xnative.XEWindow;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class XEDirector {
    public static final int PRIORITY_SINGLE = 0;
    public static final int PRIORITY_NORMAL = 1;
    public static final int PRIORITY_LOW = 2;
    public static final int GAME_THREAD_NOT_START = -1;
    private long gameThreadId = -1L;
    private String libraryPath;
    private Queue<Runnable> mEventQueue = new ConcurrentLinkedQueue<Runnable>();
    private Queue<Runnable> mLowEventQueue = new ConcurrentLinkedQueue<Runnable>();
    private Queue<XEMessageManager.IMessageSendListener> mRegisterQueue = new ConcurrentLinkedQueue<XEMessageManager.IMessageSendListener>();
    private Queue<String> mMessageQueue = new ConcurrentLinkedQueue<String>();
    private Map<String, SingleTaskRunnable> singleTaskRunnableMap = new ConcurrentHashMap<String, SingleTaskRunnable>();
    private OnThisFrameRenderedCallback mThisFrameRenderedCallback;

    public void configlibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public boolean isRunning() {
        return this.nativeIsRunning();
    }

    public boolean run() {
        return this.run(0, 0);
    }

    public boolean run(int width, int hight) {
        if (TextUtils.isEmpty((CharSequence)this.libraryPath)) {
            return false;
        }
        AssetManager assets = XE3DEngine.getInstance().getContext().getAssets();
        boolean runSuccess = this.nativeRun(assets, this.libraryPath, width, hight);
        if (runSuccess) {
            this.gameThreadId = Thread.currentThread().getId();
        }
        return runSuccess;
    }

    public void end() {
        this.clearEvent();
        this.nativeEnd();
        this.gameThreadId = -1L;
    }

    public void clearEvent() {
        this.mEventQueue.clear();
        this.mLowEventQueue.clear();
        this.mRegisterQueue.clear();
        this.mMessageQueue.clear();
        this.singleTaskRunnableMap.clear();
    }

    public void queueEvent(Runnable runnable) {
        this.queueEvent(runnable, 1);
    }

    public void sendEvent(XEvent event) {
        if (event instanceof DataEvent) {
            final DataEvent dataEvent = (DataEvent)event;
            if (this.isRenderThread()) {
                this.nativeSendDataEvent(dataEvent.getName(), dataEvent.getContent());
            } else {
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        XEDirector.this.nativeSendDataEvent(dataEvent.getName(), dataEvent.getContent());
                    }
                });
            }
        }
    }

    public void queueEvent(Runnable runnable, int priority) {
        switch (priority) {
            case 2: {
                this.mLowEventQueue.add(runnable);
                break;
            }
            case 1: {
                this.mEventQueue.add(runnable);
                break;
            }
            case 0: {
                if (!(runnable instanceof SingleTaskRunnable)) break;
                SingleTaskRunnable singleTaskRunnable = (SingleTaskRunnable)runnable;
                this.singleTaskRunnableMap.put(singleTaskRunnable.category(), singleTaskRunnable);
            }
        }
    }

    private void runQueueEvent() {
        int eventQueueSize = this.mEventQueue.size();
        while (!this.mEventQueue.isEmpty()) {
            Runnable event = this.mEventQueue.poll();
            if (event == null) continue;
            event.run();
        }
        ArrayDeque<SingleTaskRunnable> singleTasks = new ArrayDeque<SingleTaskRunnable>(this.singleTaskRunnableMap.values());
        this.singleTaskRunnableMap.clear();
        while (!singleTasks.isEmpty()) {
            Runnable event = (Runnable)singleTasks.poll();
            if (event == null) continue;
            event.run();
        }
        int lowEventQueueSize = this.mLowEventQueue.size();
        if (eventQueueSize + lowEventQueueSize > 100) {
            this.mLowEventQueue.clear();
        }
        while (!this.mLowEventQueue.isEmpty()) {
            Runnable event = this.mLowEventQueue.poll();
            if (event == null) continue;
            event.run();
        }
    }

    private void transEvent() {
        if (this.mRegisterQueue != null && !this.mRegisterQueue.isEmpty()) {
            for (XEMessageManager.IMessageSendListener l : this.mRegisterQueue) {
                XEMessageManager.getInstace().registerMessageSendListener(l);
            }
            this.mRegisterQueue.clear();
        }
        if (this.mMessageQueue != null && !this.mMessageQueue.isEmpty()) {
            for (String message : this.mMessageQueue) {
                XEMessageManager.getInstace().dispatchMessage(message);
            }
            this.mMessageQueue.clear();
        }
    }

    public void setOnThisFrameFinishCallback(OnThisFrameRenderedCallback onThisFrameFinishCallback) {
        this.mThisFrameRenderedCallback = onThisFrameFinishCallback;
    }

    public void render() {
        this.render(null);
    }

    public void render(String sceneId) {
        if (!this.isRunning()) {
            return;
        }
        if (!this.isRenderThread()) {
            Log.e((String)"[XENGINE]", (String)"Director::render \u591a\u7ebf\u7a0b\u8c03\u7528rennder \u7a0b\u5e8f\u5c31\u5feb\u5d29\u4e86");
        }
        this.runQueueEvent();
        this.transEvent();
        if (sceneId == null) {
            this.nativeRender();
        } else {
            this.nativeRenderScene(sceneId);
        }
        if (this.mThisFrameRenderedCallback != null) {
            this.mThisFrameRenderedCallback.onThisFrameFinish();
            this.mThisFrameRenderedCallback = null;
        }
    }

    public boolean isRenderThread() {
        return this.gameThreadId == Thread.currentThread().getId();
    }

    public void resizeWindow(int width, int height) {
        this.nativeResizeWindow(width, height);
    }

    public XEWindow getWindow() {
        long pre = this.nativeGetWindow();
        if (pre > 0L) {
            return new XEWindow(pre);
        }
        return null;
    }

    public void dispatchMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        this.mMessageQueue.add(message);
    }

    public void registerMessageSendListener(XEMessageManager.IMessageSendListener l) {
        if (this.isRunning()) {
            XEMessageManager.getInstace().registerMessageSendListener(l);
        } else {
            this.mRegisterQueue.add(l);
        }
    }

    public void unRegisterMessageSendListener(XEMessageManager.IMessageSendListener l) {
        XEMessageManager.getInstace().unRegisterMessageSendListener(l);
        if (this.mRegisterQueue != null) {
            this.mRegisterQueue.remove(l);
        }
    }

    public boolean arIsActive() {
        return this.nativeARIsActive();
    }

    public void activeARSupport(boolean active, boolean internal) {
        this.nativeActiveARSupport(active, internal);
    }

    public void registerARModule(long armodule) {
        this.nativeRegisterARModule(armodule);
    }

    public void clearBackground() {
        this.nativeClearBackground();
    }

    public void enableClearColor(boolean clear) {
        this.nativeEnableClearColor(clear);
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public long getGameThreadId() {
        return this.gameThreadId;
    }

    private native boolean nativeIsRunning();

    private native boolean nativeRun(AssetManager var1, String var2, int var3, int var4);

    private native void nativeEnd();

    private native void nativeRender();

    private native void nativeRenderScene(String var1);

    private native void nativeResizeWindow(int var1, int var2);

    private native long nativeGetWindow();

    private native void nativeClearBackground();

    private native boolean nativeARIsActive();

    private native void nativeActiveARSupport(boolean var1, boolean var2);

    private native void nativeRegisterARModule(long var1);

    private native void nativeEnableClearColor(boolean var1);

    private native void nativeSendDataEvent(String var1, String var2);

    public static interface OnThisFrameRenderedCallback {
        public void onThisFrameFinish();
    }

    public static interface SingleTaskRunnable
    extends Runnable {
        public String category();
    }
}

