/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.xnative;

import com.momo.xeengine.XE3DEngine;

public class XEArElement {
    protected long nativePtr;

    public XEArElement(long nativePtr) {
        this.nativePtr = nativePtr;
    }

    public static String initScene(boolean isPush) {
        if (!XE3DEngine.getInstance().isRunning()) {
            return null;
        }
        return XEArElement.nativeInitScene(isPush);
    }

    public static void detroy() {
        if (XE3DEngine.getInstance().isRunning()) {
            XEArElement.natvieDestroyScene();
        }
    }

    public static void setCameraDir(float[] dir) {
        if (dir != null && dir.length >= 3) {
            XEArElement.nativeSetCameraDir(dir);
        }
    }

    public static XEArElement createModelElement(String modelpath) {
        if (!XE3DEngine.getInstance().isRunning()) {
            return null;
        }
        long pre = XEArElement.nativeCreateModelElement(modelpath);
        if (pre > 0L) {
            return new XEArElement(pre);
        }
        return null;
    }

    public static float[] getMatrix(float[] dir, float[] rotate, float scale, float[] pos) {
        if (dir == null || dir.length < 3 || rotate == null || rotate.length < 3 || pos == null || pos.length < 3) {
            return null;
        }
        return XEArElement.nativeGetMatrix(dir, rotate, scale, pos);
    }

    public void addAnimation(String animaionPath, boolean isLoop) {
        this.nativeAddAnimation(this.nativePtr, animaionPath, isLoop);
    }

    public void removeAnimWrapper(String animationPath) {
        XEArElement.nativeRemoveAnimWrapper(this.nativePtr, animationPath);
    }

    public void removeAnimWrapperForAddIndex(int index) {
        XEArElement.nativeRemoveAnimWrapperForAddIndex(this.nativePtr, index);
    }

    public void removeAllAnimWrapper() {
        XEArElement.nativeRemoveAllAnimWrapper(this.nativePtr);
    }

    public void playAnimation(int animationIdex) {
        this.nativePlayAnimation(this.nativePtr, animationIdex);
    }

    public void autoSizeFit() {
        this.nativeAutoSizeFit(this.nativePtr);
    }

    public void autoSizeFitWithScale(float scale) {
        this.nativeAutoSizeFitWithScale(this.nativePtr, scale);
    }

    public float[] fitToScreenRectangles(float[] locMin, float[] locMax, float[] locRet) {
        if (locMin != null && locMin.length >= 2 && locMax != null && locMax.length >= 2 && locRet != null && locRet.length >= 3) {
            return this.nativeFitToScreenRectangles(this.nativePtr, locMin, locMax, locRet);
        }
        return null;
    }

    public static XEArElement createParticleElement(String particlePath) {
        if (!XE3DEngine.getInstance().isRunning()) {
            return null;
        }
        long pre = XEArElement.nativeCreateParticleElement(particlePath);
        if (pre > 0L) {
            return new XEArElement(pre);
        }
        return null;
    }

    public void play() {
        this.nativePlay(this.nativePtr);
    }

    public void setHidden(boolean isHidden) {
        this.nativeSetHidden(this.nativePtr, isHidden);
    }

    public boolean isHidden() {
        return this.nativeIsHidden(this.nativePtr);
    }

    public void setElementLoc(float[] loc) {
        this.nativeSetElementLocation(this.nativePtr, loc);
    }

    public float[] getElementLoc() {
        return this.nativeGetElementLocation(this.nativePtr);
    }

    public void setElementMatrix(float[] matrix) {
        if (matrix != null && matrix.length >= 16) {
            this.nativeSetElementMatrix(this.nativePtr, matrix);
        }
    }

    public void setElementScale(float[] scale) {
        this.nativeSetElementScale(this.nativePtr, scale);
    }

    public void setScreenLocation(float[] location) {
        if (location != null && location.length >= 2) {
            this.nativeSetScreenLocation(this.nativePtr, location);
        }
    }

    public void roatteX(float fValue) {
        XEArElement.nativeRotateX(this.nativePtr, fValue);
    }

    public void roatteY(float fValue) {
        XEArElement.nativeRotateY(this.nativePtr, fValue);
    }

    public void roatteZ(float fValue) {
        XEArElement.nativeRotateZ(this.nativePtr, fValue);
    }

    public void setOutLine(float lineWidth, float[] lineColor) {
        XEArElement.nativeSetOutLine(this.nativePtr, lineWidth, lineColor);
    }

    public String getElementName() {
        return this.nativeGetElementName(this.nativePtr);
    }

    public static void deleteElement(XEArElement element) {
        if (!XE3DEngine.getInstance().isRunning()) {
            return;
        }
        if (element != null && element.nativePtr > 0L) {
            XEArElement.nativeDeleteElement(element.nativePtr);
        }
    }

    public static void setFXAAEnabled(boolean enabled) {
        XEArElement.nativeSetFXAAEnabled(enabled);
    }

    public static void setSSAAEnabled(boolean enabled) {
        XEArElement.nativeSetSSAAEnabled(enabled);
    }

    private static native String nativeInitScene(boolean var0);

    private static native void natvieDestroyScene();

    private static native void nativeSetCameraDir(float[] var0);

    private static native long nativeCreateModelElement(String var0);

    private static native float[] nativeGetMatrix(float[] var0, float[] var1, float var2, float[] var3);

    private static native void nativeSetFXAAEnabled(boolean var0);

    private static native void nativeSetSSAAEnabled(boolean var0);

    private native void nativeAddAnimation(long var1, String var3, boolean var4);

    private native void nativePlayAnimation(long var1, int var3);

    private native void nativeAutoSizeFit(long var1);

    private native void nativeAutoSizeFitWithScale(long var1, float var3);

    private native float[] nativeFitToScreenRectangles(long var1, float[] var3, float[] var4, float[] var5);

    private static native long nativeCreateParticleElement(String var0);

    private native void nativePlay(long var1);

    private native void nativeSetHidden(long var1, boolean var3);

    private native boolean nativeIsHidden(long var1);

    private native void nativeSetElementLocation(long var1, float[] var3);

    private native float[] nativeGetElementLocation(long var1);

    private native void nativeSetElementMatrix(long var1, float[] var3);

    private native void nativeSetElementScale(long var1, float[] var3);

    private native void nativeSetScreenLocation(long var1, float[] var3);

    private native String nativeGetElementName(long var1);

    private static native void nativeDeleteElement(long var0);

    private static native void nativeRotateX(long var0, float var2);

    private static native void nativeRotateY(long var0, float var2);

    private static native void nativeRotateZ(long var0, float var2);

    private static native void nativeSetOutLine(long var0, float var2, float[] var3);

    private static native void nativeRemoveAnimWrapper(long var0, String var2);

    private static native void nativeRemoveAnimWrapperForAddIndex(long var0, int var2);

    private static native void nativeRemoveAllAnimWrapper(long var0);
}

