/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.sensor;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.view.WindowManager;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.sensor.ImprovedOrientationSensorProvider;
import com.momo.xeengine.sensor.Quaternion;
import com.momo.xeengine.xnative.XEDirector;

public class XEAccelerometer
implements SensorEventListener {
    private static final int SENSOR_DELAY_DEFAULT = 2;
    private static final String TAG = "jni_xeengine";
    private Context mContext;
    private SensorManager mSensorManager;
    private Sensor mAccelerometer;
    private Sensor sensorGrav;
    private Sensor sensorRoat;
    private static ImprovedOrientationSensorProvider provider;
    private QuaternionSensorEventListener sensorEventListener;
    private int mNaturalOrientation;

    public XEAccelerometer(Context context) {
        WindowManager wm;
        this.mContext = context.getApplicationContext();
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        if (this.mSensorManager != null) {
            this.mAccelerometer = this.mSensorManager.getDefaultSensor(1);
            provider = new ImprovedOrientationSensorProvider(this.mSensorManager);
            this.sensorGrav = this.mSensorManager.getDefaultSensor(4);
            this.sensorRoat = this.mSensorManager.getDefaultSensor(11);
        }
        if ((wm = (WindowManager)this.mContext.getSystemService("window")) != null) {
            this.mNaturalOrientation = wm.getDefaultDisplay().getOrientation();
        }
    }

    public void enableAccelerometer(boolean enable) {
        if (enable) {
            if (this.mSensorManager != null) {
                this.mSensorManager.registerListener((SensorEventListener)this, this.mAccelerometer, 2);
            }
        } else if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener((SensorEventListener)this, this.mAccelerometer);
        }
    }

    public void enableCompass(boolean enable) {
        if (enable) {
            if (this.sensorEventListener == null) {
                this.sensorEventListener = new QuaternionSensorEventListener();
            }
            if (this.sensorGrav != null) {
                this.mSensorManager.registerListener((SensorEventListener)this.sensorEventListener, this.sensorGrav, 2);
            }
            if (this.sensorRoat != null) {
                this.mSensorManager.registerListener((SensorEventListener)this.sensorEventListener, this.sensorRoat, 2);
            }
        } else if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener((SensorEventListener)this.sensorEventListener, this.sensorGrav);
            this.mSensorManager.unregisterListener((SensorEventListener)this.sensorEventListener, this.sensorRoat);
        }
    }

    public void setAccelerometerInterval(float interval) {
        this.mSensorManager.registerListener((SensorEventListener)this, this.mAccelerometer, (int)(interval * 1000000.0f));
    }

    public void setCompassInterval(float interval) {
    }

    public void disable() {
        if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            if (this.sensorEventListener != null) {
                this.mSensorManager.unregisterListener((SensorEventListener)this.sensorEventListener, this.sensorGrav);
                this.mSensorManager.unregisterListener((SensorEventListener)this.sensorEventListener, this.sensorRoat);
                this.sensorEventListener = null;
            }
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public void onSensorChanged(final SensorEvent event) {
        if (event.sensor.getType() == 1) {
            float tmp;
            float x = event.values[0];
            float y = event.values[1];
            final float z = event.values[2];
            int orientation = this.mContext.getResources().getConfiguration().orientation;
            if (orientation == 2 && this.mNaturalOrientation != 0) {
                tmp = x;
                x = -y;
                y = tmp;
            } else if (orientation == 1 && this.mNaturalOrientation != 0) {
                tmp = x;
                x = y;
                y = -tmp;
            }
            int rotation = 0;
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            if (wm != null) {
                rotation = wm.getDefaultDisplay().getRotation();
            }
            if (rotation == 2 || rotation == 3) {
                x = -x;
                y = -y;
            }
            if (XE3DEngine.getInstance().isRunning()) {
                final float finalX = x;
                final float finalY = y;
                if (XE3DEngine.getInstance().isRunning()) {
                    XE3DEngine.getInstance().queueEvent(new XEDirector.SingleTaskRunnable(){

                        @Override
                        public String category() {
                            return "SensorTask2";
                        }

                        @Override
                        public void run() {
                            XEAccelerometer.nativeOnSensorChanged(finalX, finalY, z, event.timestamp);
                        }
                    }, 0);
                }
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void release() {
        this.mContext = null;
        this.mSensorManager = null;
        this.mAccelerometer = null;
        this.sensorGrav = null;
        this.sensorRoat = null;
        provider = null;
        this.sensorEventListener = null;
    }

    private static native void nativeOnSensorChanged(float var0, float var1, float var2, long var3);

    private static native void nativeSensorQuatUpdate(float var0, float var1, float var2, float var3);

    public class QuaternionSensorEventListener
    implements SensorEventListener {
        public void onSensorChanged(SensorEvent event) {
            if (XE3DEngine.getInstance().isRunning() && provider != null) {
                provider.onSensorChanged(event);
                final Quaternion quaternion = new Quaternion();
                provider.getQuaternion(quaternion);
                if (XE3DEngine.getInstance().isRunning()) {
                    XE3DEngine.getInstance().queueEvent(new XEDirector.SingleTaskRunnable(){

                        @Override
                        public String category() {
                            return "SensorTask";
                        }

                        @Override
                        public void run() {
                            XEAccelerometer.nativeSensorQuatUpdate(quaternion.getW(), quaternion.getX(), quaternion.getY(), -quaternion.getZ());
                        }
                    }, 0);
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

