/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.sensor;

import com.momo.xeengine.sensor.Vector3f;

public class Vector4f {
    protected float[] points = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    public Vector4f(float x, float y, float z, float w) {
        this.points[0] = x;
        this.points[1] = y;
        this.points[2] = z;
        this.points[3] = w;
    }

    public Vector4f() {
        this.points[0] = 0.0f;
        this.points[1] = 0.0f;
        this.points[2] = 0.0f;
        this.points[3] = 0.0f;
    }

    public Vector4f(Vector3f vector3f, float w) {
        this.points[0] = vector3f.x();
        this.points[1] = vector3f.y();
        this.points[2] = vector3f.z();
        this.points[3] = w;
    }

    public float[] array() {
        return this.points;
    }

    public void copyVec4(Vector4f vec) {
        this.points[0] = vec.points[0];
        this.points[1] = vec.points[1];
        this.points[2] = vec.points[2];
        this.points[3] = vec.points[3];
    }

    public void add(Vector4f vector) {
        this.points[0] = this.points[0] + vector.points[0];
        this.points[1] = this.points[1] + vector.points[1];
        this.points[2] = this.points[2] + vector.points[2];
        this.points[3] = this.points[3] + vector.points[3];
    }

    public void add(Vector3f vector, float w) {
        this.points[0] = this.points[0] + vector.x();
        this.points[1] = this.points[1] + vector.y();
        this.points[2] = this.points[2] + vector.z();
        this.points[3] = this.points[3] + w;
    }

    public void subtract(Vector4f vector) {
        this.points[0] = this.points[0] - vector.points[0];
        this.points[1] = this.points[1] - vector.points[1];
        this.points[2] = this.points[2] - vector.points[2];
        this.points[3] = this.points[3] - vector.points[3];
    }

    public void subtract(Vector4f vector, Vector4f output) {
        output.setXYZW(this.points[0] - vector.points[0], this.points[1] - vector.points[1], this.points[2] - vector.points[2], this.points[3] - vector.points[3]);
    }

    public void subdivide(Vector4f vector) {
        this.points[0] = this.points[0] / vector.points[0];
        this.points[1] = this.points[1] / vector.points[1];
        this.points[2] = this.points[2] / vector.points[2];
        this.points[3] = this.points[3] / vector.points[3];
    }

    public void multiplyByScalar(float scalar) {
        this.points[0] = this.points[0] * scalar;
        this.points[1] = this.points[1] * scalar;
        this.points[2] = this.points[2] * scalar;
        this.points[3] = this.points[3] * scalar;
    }

    public float dotProduct(Vector4f input) {
        return this.points[0] * input.points[0] + this.points[1] * input.points[1] + this.points[2] * input.points[2] + this.points[3] * input.points[3];
    }

    public void lerp(Vector4f input, Vector4f output, float t) {
        output.points[0] = this.points[0] * (1.0f * t) + input.points[0] * t;
        output.points[1] = this.points[1] * (1.0f * t) + input.points[1] * t;
        output.points[2] = this.points[2] * (1.0f * t) + input.points[2] * t;
        output.points[3] = this.points[3] * (1.0f * t) + input.points[3] * t;
    }

    public void normalize() {
        if (this.points[3] == 0.0f) {
            return;
        }
        this.points[0] = this.points[0] / this.points[3];
        this.points[1] = this.points[1] / this.points[3];
        this.points[2] = this.points[2] / this.points[3];
        double a = Math.sqrt(this.points[0] * this.points[0] + this.points[1] * this.points[1] + this.points[2] * this.points[2]);
        this.points[0] = (float)((double)this.points[0] / a);
        this.points[1] = (float)((double)this.points[1] / a);
        this.points[2] = (float)((double)this.points[2] / a);
    }

    public float getX() {
        return this.points[0];
    }

    public float getY() {
        return this.points[1];
    }

    public float getZ() {
        return this.points[2];
    }

    public float getW() {
        return this.points[3];
    }

    public void setX(float x) {
        this.points[0] = x;
    }

    public void setY(float y) {
        this.points[1] = y;
    }

    public void setZ(float z) {
        this.points[2] = z;
    }

    public void setW(float w) {
        this.points[3] = w;
    }

    public float x() {
        return this.points[0];
    }

    public float y() {
        return this.points[1];
    }

    public float z() {
        return this.points[2];
    }

    public float w() {
        return this.points[3];
    }

    public void x(float x) {
        this.points[0] = x;
    }

    public void y(float y) {
        this.points[1] = y;
    }

    public void z(float z) {
        this.points[2] = z;
    }

    public void w(float w) {
        this.points[3] = w;
    }

    public void setXYZW(float x, float y, float z, float w) {
        this.points[0] = x;
        this.points[1] = y;
        this.points[2] = z;
        this.points[3] = w;
    }

    public boolean compareTo(Vector4f rhs) {
        boolean ret = false;
        if (this.points[0] == rhs.points[0] && this.points[1] == rhs.points[1] && this.points[2] == rhs.points[2] && this.points[3] == rhs.points[3]) {
            ret = true;
        }
        return ret;
    }

    public void copyFromV3f(Vector3f input, float w) {
        this.points[0] = input.x();
        this.points[1] = input.y();
        this.points[2] = input.z();
        this.points[3] = w;
    }

    public String toString() {
        return "X:" + this.points[0] + " Y:" + this.points[1] + " Z:" + this.points[2] + " W:" + this.points[3];
    }
}

