/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.sensor;

import com.momo.xeengine.sensor.MatrixF4x4;
import com.momo.xeengine.sensor.Vector3f;
import com.momo.xeengine.sensor.Vector4f;

public class Quaternion
extends Vector4f {
    private MatrixF4x4 matrix;
    private boolean dirty = false;
    private Vector4f tmpVector = new Vector4f();
    private Quaternion tmpQuaternion;

    public Quaternion() {
        this.matrix = new MatrixF4x4();
        this.loadIdentityQuat();
    }

    public void normalise() {
        this.dirty = true;
        float mag = (float)Math.sqrt(this.points[3] * this.points[3] + this.points[0] * this.points[0] + this.points[1] * this.points[1] + this.points[2] * this.points[2]);
        this.points[3] = this.points[3] / mag;
        this.points[0] = this.points[0] / mag;
        this.points[1] = this.points[1] / mag;
        this.points[2] = this.points[2] / mag;
    }

    @Override
    public void normalize() {
        this.normalise();
    }

    public void set(Quaternion quat) {
        this.dirty = true;
        this.copyVec4(quat);
    }

    public void multiplyByQuat(Quaternion input, Quaternion output) {
        if (input != output) {
            output.points[3] = this.points[3] * input.points[3] - this.points[0] * input.points[0] - this.points[1] * input.points[1] - this.points[2] * input.points[2];
            output.points[0] = this.points[3] * input.points[0] + this.points[0] * input.points[3] + this.points[1] * input.points[2] - this.points[2] * input.points[1];
            output.points[1] = this.points[3] * input.points[1] + this.points[1] * input.points[3] + this.points[2] * input.points[0] - this.points[0] * input.points[2];
            output.points[2] = this.points[3] * input.points[2] + this.points[2] * input.points[3] + this.points[0] * input.points[1] - this.points[1] * input.points[0];
        } else {
            this.tmpVector.points[0] = input.points[0];
            this.tmpVector.points[1] = input.points[1];
            this.tmpVector.points[2] = input.points[2];
            this.tmpVector.points[3] = input.points[3];
            output.points[3] = this.points[3] * this.tmpVector.points[3] - this.points[0] * this.tmpVector.points[0] - this.points[1] * this.tmpVector.points[1] - this.points[2] * this.tmpVector.points[2];
            output.points[0] = this.points[3] * this.tmpVector.points[0] + this.points[0] * this.tmpVector.points[3] + this.points[1] * this.tmpVector.points[2] - this.points[2] * this.tmpVector.points[1];
            output.points[1] = this.points[3] * this.tmpVector.points[1] + this.points[1] * this.tmpVector.points[3] + this.points[2] * this.tmpVector.points[0] - this.points[0] * this.tmpVector.points[2];
            output.points[2] = this.points[3] * this.tmpVector.points[2] + this.points[2] * this.tmpVector.points[3] + this.points[0] * this.tmpVector.points[1] - this.points[1] * this.tmpVector.points[0];
        }
    }

    public void multiplyByQuat(Quaternion input) {
        this.dirty = true;
        if (this.tmpQuaternion == null) {
            this.tmpQuaternion = new Quaternion();
        }
        this.tmpQuaternion.copyVec4(this);
        this.multiplyByQuat(input, this.tmpQuaternion);
        this.copyVec4(this.tmpQuaternion);
    }

    @Override
    public void multiplyByScalar(float scalar) {
        this.dirty = true;
        this.multiplyByScalar(scalar);
    }

    public void addQuat(Quaternion input) {
        this.dirty = true;
        this.addQuat(input, this);
    }

    public void addQuat(Quaternion input, Quaternion output) {
        output.setX(this.getX() + input.getX());
        output.setY(this.getY() + input.getY());
        output.setZ(this.getZ() + input.getZ());
        output.setW(this.getW() + input.getW());
    }

    public void subQuat(Quaternion input) {
        this.dirty = true;
        this.subQuat(input, this);
    }

    public void subQuat(Quaternion input, Quaternion output) {
        output.setX(this.getX() - input.getX());
        output.setY(this.getY() - input.getY());
        output.setZ(this.getZ() - input.getZ());
        output.setW(this.getW() - input.getW());
    }

    private void convertQuatToMatrix() {
        float x = this.points[0];
        float y = this.points[1];
        float z = this.points[2];
        float w = this.points[3];
        this.matrix.setX0(1.0f - 2.0f * (y * y) - 2.0f * (z * z));
        this.matrix.setX1(2.0f * (x * y) + 2.0f * (w * z));
        this.matrix.setX2(2.0f * (x * z) - 2.0f * (w * y));
        this.matrix.setX3(0.0f);
        this.matrix.setY0(2.0f * (x * y) - 2.0f * (w * z));
        this.matrix.setY1(1.0f - 2.0f * (x * x) - 2.0f * (z * z));
        this.matrix.setY2(2.0f * (y * z) + 2.0f * (w * x));
        this.matrix.setY3(0.0f);
        this.matrix.setZ0(2.0f * (x * z) + 2.0f * (w * y));
        this.matrix.setZ1(2.0f * (y * z) - 2.0f * (w * x));
        this.matrix.setZ2(1.0f - 2.0f * (x * x) - 2.0f * (y * y));
        this.matrix.setZ3(0.0f);
        this.matrix.setW0(0.0f);
        this.matrix.setW1(0.0f);
        this.matrix.setW2(0.0f);
        this.matrix.setW3(1.0f);
    }

    public void toAxisAngle(Vector4f output) {
        float z;
        float y;
        float x;
        if (this.getW() > 1.0f) {
            this.normalise();
        }
        float angle = 2.0f * (float)Math.toDegrees(Math.acos(this.getW()));
        float s = (float)Math.sqrt(1.0f - this.getW() * this.getW());
        if ((double)s < 0.001) {
            x = this.points[0];
            y = this.points[1];
            z = this.points[2];
        } else {
            x = this.points[0] / s;
            y = this.points[1] / s;
            z = this.points[2] / s;
        }
        output.points[0] = x;
        output.points[1] = y;
        output.points[2] = z;
        output.points[3] = angle;
    }

    public double[] toEulerAngles() {
        double[] ret = new double[]{Math.atan2(2.0f * this.points[1] * this.getW() - 2.0f * this.points[0] * this.points[2], 1.0f - 2.0f * (this.points[1] * this.points[1]) - 2.0f * (this.points[2] * this.points[2])), Math.asin(2.0f * this.points[0] * this.points[1] + 2.0f * this.points[2] * this.getW()), Math.atan2(2.0f * this.points[0] * this.getW() - 2.0f * this.points[1] * this.points[2], 1.0f - 2.0f * (this.points[0] * this.points[0]) - 2.0f * (this.points[2] * this.points[2]))};
        return ret;
    }

    public void loadIdentityQuat() {
        this.dirty = true;
        this.setX(0.0f);
        this.setY(0.0f);
        this.setZ(0.0f);
        this.setW(1.0f);
    }

    @Override
    public String toString() {
        return "{X: " + this.getX() + ", Y:" + this.getY() + ", Z:" + this.getZ() + ", W:" + this.getW() + "}";
    }

    private void generateQuaternionFromMatrix() {
        float qz;
        float qy;
        float qx;
        float qw;
        float[] mat = this.matrix.getMatrix();
        int[] indices = null;
        indices = this.matrix.size() == 16 ? (this.matrix.isColumnMajor() ? MatrixF4x4.matIndCol16_3x3 : MatrixF4x4.matIndRow16_3x3) : (this.matrix.isColumnMajor() ? MatrixF4x4.matIndCol9_3x3 : MatrixF4x4.matIndRow9_3x3);
        int m00 = indices[0];
        int m01 = indices[1];
        int m02 = indices[2];
        int m10 = indices[3];
        int m11 = indices[4];
        int m12 = indices[5];
        int m20 = indices[6];
        int m21 = indices[7];
        int m22 = indices[8];
        float tr = mat[m00] + mat[m11] + mat[m22];
        if (tr > 0.0f) {
            float s = (float)Math.sqrt((double)tr + 1.0) * 2.0f;
            qw = 0.25f * s;
            qx = (mat[m21] - mat[m12]) / s;
            qy = (mat[m02] - mat[m20]) / s;
            qz = (mat[m10] - mat[m01]) / s;
        } else if (mat[m00] > mat[m11] & mat[m00] > mat[m22]) {
            float s = (float)Math.sqrt(1.0 + (double)mat[m00] - (double)mat[m11] - (double)mat[m22]) * 2.0f;
            qw = (mat[m21] - mat[m12]) / s;
            qx = 0.25f * s;
            qy = (mat[m01] + mat[m10]) / s;
            qz = (mat[m02] + mat[m20]) / s;
        } else if (mat[m11] > mat[m22]) {
            float s = (float)Math.sqrt(1.0 + (double)mat[m11] - (double)mat[m00] - (double)mat[m22]) * 2.0f;
            qw = (mat[m02] - mat[m20]) / s;
            qx = (mat[m01] + mat[m10]) / s;
            qy = 0.25f * s;
            qz = (mat[m12] + mat[m21]) / s;
        } else {
            float s = (float)Math.sqrt(1.0 + (double)mat[m22] - (double)mat[m00] - (double)mat[m11]) * 2.0f;
            qw = (mat[m10] - mat[m01]) / s;
            qx = (mat[m02] + mat[m20]) / s;
            qy = (mat[m12] + mat[m21]) / s;
            qz = 0.25f * s;
        }
        this.setX(qx);
        this.setY(qy);
        this.setZ(qz);
        this.setW(qw);
    }

    public void setColumnMajor(float[] matrix) {
        this.matrix.setMatrix(matrix);
        this.matrix.setColumnMajor(true);
        this.generateQuaternionFromMatrix();
    }

    public void setRowMajor(float[] matrix) {
        this.matrix.setMatrix(matrix);
        this.matrix.setColumnMajor(false);
        this.generateQuaternionFromMatrix();
    }

    public void setEulerAngle(float azimuth, float pitch, float roll) {
        double heading = Math.toRadians(roll);
        double attitude = Math.toRadians(pitch);
        double bank = Math.toRadians(azimuth);
        double c1 = Math.cos(heading / 2.0);
        double s1 = Math.sin(heading / 2.0);
        double c2 = Math.cos(attitude / 2.0);
        double s2 = Math.sin(attitude / 2.0);
        double c3 = Math.cos(bank / 2.0);
        double s3 = Math.sin(bank / 2.0);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        this.setW((float)(c1c2 * c3 - s1s2 * s3));
        this.setX((float)(c1c2 * s3 + s1s2 * c3));
        this.setY((float)(s1 * c2 * c3 + c1 * s2 * s3));
        this.setZ((float)(c1 * s2 * c3 - s1 * c2 * s3));
        this.dirty = true;
    }

    public void setAxisAngle(Vector3f vec, float rot) {
        double s = Math.sin(Math.toRadians(rot / 2.0f));
        this.setX(vec.getX() * (float)s);
        this.setY(vec.getY() * (float)s);
        this.setZ(vec.getZ() * (float)s);
        this.setW((float)Math.cos(Math.toRadians(rot / 2.0f)));
        this.dirty = true;
    }

    public void setAxisAngleRad(Vector3f vec, double rot) {
        double s = rot / 2.0;
        this.setX(vec.getX() * (float)s);
        this.setY(vec.getY() * (float)s);
        this.setZ(vec.getZ() * (float)s);
        this.setW((float)rot / 2.0f);
        this.dirty = true;
    }

    public MatrixF4x4 getMatrix4x4() {
        if (this.dirty) {
            this.convertQuatToMatrix();
            this.dirty = false;
        }
        return this.matrix;
    }

    public void copyFromVec3(Vector3f vec, float w) {
        this.copyFromV3f(vec, w);
    }

    public void slerp(Quaternion input, Quaternion output, float t) {
        Quaternion bufferQuat;
        float cosHalftheta = this.dotProduct(input);
        if (cosHalftheta < 0.0f) {
            if (this.tmpQuaternion == null) {
                this.tmpQuaternion = new Quaternion();
            }
            bufferQuat = this.tmpQuaternion;
            cosHalftheta = -cosHalftheta;
            bufferQuat.points[0] = -input.points[0];
            bufferQuat.points[1] = -input.points[1];
            bufferQuat.points[2] = -input.points[2];
            bufferQuat.points[3] = -input.points[3];
        } else {
            bufferQuat = input;
        }
        if ((double)Math.abs(cosHalftheta) >= 1.0) {
            output.points[0] = this.points[0];
            output.points[1] = this.points[1];
            output.points[2] = this.points[2];
            output.points[3] = this.points[3];
        } else {
            double sinHalfTheta = Math.sqrt(1.0 - (double)(cosHalftheta * cosHalftheta));
            double halfTheta = Math.acos(cosHalftheta);
            double ratioA = Math.sin((double)(1.0f - t) * halfTheta) / sinHalfTheta;
            double ratioB = Math.sin((double)t * halfTheta) / sinHalfTheta;
            output.points[3] = (float)((double)this.points[3] * ratioA + (double)bufferQuat.points[3] * ratioB);
            output.points[0] = (float)((double)this.points[0] * ratioA + (double)bufferQuat.points[0] * ratioB);
            output.points[1] = (float)((double)this.points[1] * ratioA + (double)bufferQuat.points[1] * ratioB);
            output.points[2] = (float)((double)this.points[2] * ratioA + (double)bufferQuat.points[2] * ratioB);
        }
    }
}

