/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.sensor;

import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.momo.xeengine.sensor.MatrixF4x4;
import com.momo.xeengine.sensor.Quaternion;
import java.util.ArrayList;
import java.util.List;

public abstract class OrientationProvider
implements SensorEventListener {
    protected final Object synchronizationToken = new Object();
    protected List<Sensor> sensorList = new ArrayList<Sensor>();
    protected final MatrixF4x4 currentOrientationRotationMatrix;
    protected final Quaternion currentOrientationQuaternion;
    protected SensorManager sensorManager;

    public OrientationProvider(SensorManager sensorManager) {
        this.sensorManager = sensorManager;
        this.currentOrientationRotationMatrix = new MatrixF4x4();
        this.currentOrientationQuaternion = new Quaternion();
    }

    public void start() {
        for (Sensor sensor : this.sensorList) {
            this.sensorManager.registerListener((SensorEventListener)this, sensor, 1);
        }
    }

    public void stop() {
        for (Sensor sensor : this.sensorList) {
            this.sensorManager.unregisterListener((SensorEventListener)this, sensor);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRotationMatrix(MatrixF4x4 matrix) {
        Object object = this.synchronizationToken;
        synchronized (object) {
            matrix.set(this.currentOrientationRotationMatrix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getQuaternion(Quaternion quaternion) {
        Object object = this.synchronizationToken;
        synchronized (object) {
            quaternion.set(this.currentOrientationQuaternion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEulerAngles(float[] angles) {
        Object object = this.synchronizationToken;
        synchronized (object) {
            SensorManager.getOrientation((float[])this.currentOrientationRotationMatrix.matrix, (float[])angles);
        }
    }
}

