/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.sensor;

import android.util.Log;
import com.momo.xeengine.sensor.Matrix;
import com.momo.xeengine.sensor.Vector3f;
import com.momo.xeengine.sensor.Vector4f;

public class MatrixF4x4 {
    public static final int[] matIndCol9_3x3 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final int[] matIndCol16_3x3 = new int[]{0, 1, 2, 4, 5, 6, 8, 9, 10};
    public static final int[] matIndRow9_3x3 = new int[]{0, 3, 6, 1, 4, 7, 3, 5, 8};
    public static final int[] matIndRow16_3x3 = new int[]{0, 4, 8, 1, 5, 9, 2, 6, 10};
    public static final int[] matIndCol16_4x4 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static final int[] matIndRow16_4x4 = new int[]{0, 4, 8, 12, 1, 5, 9, 13, 2, 6, 10, 14, 3, 7, 11, 15};
    private boolean colMaj = true;
    public float[] matrix = new float[16];

    public MatrixF4x4() {
        Matrix.setIdentityM(this.matrix, 0);
    }

    public float[] getMatrix() {
        return this.matrix;
    }

    public int size() {
        return this.matrix.length;
    }

    public void setMatrix(float[] matrix) {
        if (matrix.length != 16 && matrix.length != 9) {
            throw new IllegalArgumentException("Matrix set is invalid, size is " + matrix.length + " expected 9 or 16");
        }
        this.matrix = matrix;
    }

    public void set(MatrixF4x4 source) {
        System.arraycopy(source.matrix, 0, this.matrix, 0, this.matrix.length);
    }

    public void setColumnMajor(boolean colMajor) {
        this.colMaj = colMajor;
    }

    public boolean isColumnMajor() {
        return this.colMaj;
    }

    public void multiplyVector4fByMatrix(Vector4f vector) {
        if (this.matrix.length == 16) {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            float w = 0.0f;
            float[] vectorArray = vector.array();
            if (this.colMaj) {
                for (int i = 0; i < 4; ++i) {
                    int k = i * 4;
                    x += this.matrix[k + 0] * vectorArray[i];
                    y += this.matrix[k + 1] * vectorArray[i];
                    z += this.matrix[k + 2] * vectorArray[i];
                    w += this.matrix[k + 3] * vectorArray[i];
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    x += this.matrix[0 + i] * vectorArray[i];
                    y += this.matrix[4 + i] * vectorArray[i];
                    z += this.matrix[8 + i] * vectorArray[i];
                    w += this.matrix[12 + i] * vectorArray[i];
                }
            }
            vector.setX(x);
            vector.setY(y);
            vector.setZ(z);
            vector.setW(w);
        } else {
            Log.e((String)"matrix", (String)("Matrix is invalid, is " + this.matrix.length + " long, this equation expects a 16 value matrix"));
        }
    }

    public void multiplyVector3fByMatrix(Vector3f vector) {
        if (this.matrix.length == 9) {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            float[] vectorArray = vector.toArray();
            if (!this.colMaj) {
                for (int i = 0; i < 3; ++i) {
                    int k = i * 3;
                    x += this.matrix[k + 0] * vectorArray[i];
                    y += this.matrix[k + 1] * vectorArray[i];
                    z += this.matrix[k + 2] * vectorArray[i];
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    x += this.matrix[0 + i] * vectorArray[i];
                    y += this.matrix[3 + i] * vectorArray[i];
                    z += this.matrix[6 + i] * vectorArray[i];
                }
            }
            vector.setX(x);
            vector.setY(y);
            vector.setZ(z);
        } else {
            Log.e((String)"matrix", (String)("Matrix is invalid, is " + this.matrix.length + " long, this function expects the internal matrix to be of size 9"));
        }
    }

    public void multiplyMatrix4x4ByMatrix(MatrixF4x4 matrixf) {
        float[] bufferMatrix = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] matrix = matrixf.getMatrix();
        this.multiplyMatrix(matrix, 0, bufferMatrix, 0);
        matrixf.setMatrix(bufferMatrix);
    }

    public void multiplyMatrix(float[] input, int inputOffset, float[] output, int outputOffset) {
        float[] bufferMatrix = output;
        float[] matrix = input;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4;
                int n = outputOffset + 0 + j;
                bufferMatrix[n] = bufferMatrix[n] + this.matrix[k + j] * matrix[inputOffset + 0 + i];
                int n2 = outputOffset + 4 + j;
                bufferMatrix[n2] = bufferMatrix[n2] + this.matrix[k + j] * matrix[inputOffset + 4 + i];
                int n3 = outputOffset + 8 + j;
                bufferMatrix[n3] = bufferMatrix[n3] + this.matrix[k + j] * matrix[inputOffset + 8 + i];
                int n4 = outputOffset + 12 + j;
                bufferMatrix[n4] = bufferMatrix[n4] + this.matrix[k + j] * matrix[inputOffset + 12 + i];
            }
        }
    }

    public void transpose() {
        if (this.matrix.length == 16) {
            float[] newMatrix = new float[16];
            for (int i = 0; i < 4; ++i) {
                int k = i * 4;
                newMatrix[k] = this.matrix[i];
                newMatrix[k + 1] = this.matrix[4 + i];
                newMatrix[k + 2] = this.matrix[8 + i];
                newMatrix[k + 3] = this.matrix[12 + i];
            }
            this.matrix = newMatrix;
        } else {
            float[] newMatrix = new float[9];
            for (int i = 0; i < 3; ++i) {
                int k = i * 3;
                newMatrix[k] = this.matrix[i];
                newMatrix[k + 1] = this.matrix[3 + i];
                newMatrix[k + 2] = this.matrix[6 + i];
            }
            this.matrix = newMatrix;
        }
    }

    public void setX0(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_3x3[0]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_3x3[0]] = value;
            }
        } else if (this.colMaj) {
            this.matrix[MatrixF4x4.matIndCol9_3x3[0]] = value;
        } else {
            this.matrix[MatrixF4x4.matIndRow9_3x3[0]] = value;
        }
    }

    public void setX1(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_3x3[1]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_3x3[1]] = value;
            }
        } else if (this.colMaj) {
            this.matrix[MatrixF4x4.matIndCol9_3x3[1]] = value;
        } else {
            this.matrix[MatrixF4x4.matIndRow9_3x3[1]] = value;
        }
    }

    public void setX2(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_3x3[2]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_3x3[2]] = value;
            }
        } else if (this.colMaj) {
            this.matrix[MatrixF4x4.matIndCol9_3x3[2]] = value;
        } else {
            this.matrix[MatrixF4x4.matIndRow9_3x3[2]] = value;
        }
    }

    public void setY0(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_3x3[3]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_3x3[3]] = value;
            }
        } else if (this.colMaj) {
            this.matrix[MatrixF4x4.matIndCol9_3x3[3]] = value;
        } else {
            this.matrix[MatrixF4x4.matIndRow9_3x3[3]] = value;
        }
    }

    public void setY1(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_3x3[4]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_3x3[4]] = value;
            }
        } else if (this.colMaj) {
            this.matrix[MatrixF4x4.matIndCol9_3x3[4]] = value;
        } else {
            this.matrix[MatrixF4x4.matIndRow9_3x3[4]] = value;
        }
    }

    public void setY2(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_3x3[5]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_3x3[5]] = value;
            }
        } else if (this.colMaj) {
            this.matrix[MatrixF4x4.matIndCol9_3x3[5]] = value;
        } else {
            this.matrix[MatrixF4x4.matIndRow9_3x3[5]] = value;
        }
    }

    public void setZ0(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_3x3[6]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_3x3[6]] = value;
            }
        } else if (this.colMaj) {
            this.matrix[MatrixF4x4.matIndCol9_3x3[6]] = value;
        } else {
            this.matrix[MatrixF4x4.matIndRow9_3x3[6]] = value;
        }
    }

    public void setZ1(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_3x3[7]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_3x3[7]] = value;
            }
        } else if (this.colMaj) {
            this.matrix[MatrixF4x4.matIndCol9_3x3[7]] = value;
        } else {
            this.matrix[MatrixF4x4.matIndRow9_3x3[7]] = value;
        }
    }

    public void setZ2(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_3x3[8]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_3x3[8]] = value;
            }
        } else if (this.colMaj) {
            this.matrix[MatrixF4x4.matIndCol9_3x3[8]] = value;
        } else {
            this.matrix[MatrixF4x4.matIndRow9_3x3[8]] = value;
        }
    }

    public void setX3(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_4x4[3]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_4x4[3]] = value;
            }
        } else {
            throw new IllegalStateException("length of matrix should be 16");
        }
    }

    public void setY3(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_4x4[7]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_4x4[7]] = value;
            }
        } else {
            throw new IllegalStateException("length of matrix should be 16");
        }
    }

    public void setZ3(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_4x4[11]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_4x4[11]] = value;
            }
        } else {
            throw new IllegalStateException("length of matrix should be 16");
        }
    }

    public void setW0(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_4x4[12]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_4x4[12]] = value;
            }
        } else {
            throw new IllegalStateException("length of matrix should be 16");
        }
    }

    public void setW1(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_4x4[13]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_4x4[13]] = value;
            }
        } else {
            throw new IllegalStateException("length of matrix should be 16");
        }
    }

    public void setW2(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_4x4[14]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_4x4[14]] = value;
            }
        } else {
            throw new IllegalStateException("length of matrix should be 16");
        }
    }

    public void setW3(float value) {
        if (this.matrix.length == 16) {
            if (this.colMaj) {
                this.matrix[MatrixF4x4.matIndCol16_4x4[15]] = value;
            } else {
                this.matrix[MatrixF4x4.matIndRow16_4x4[15]] = value;
            }
        } else {
            throw new IllegalStateException("length of matrix should be 16");
        }
    }
}

