/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.audio;

import android.media.SoundPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class XEEffectPlayer {
    private SoundPool mSoundPool;
    private float mLeftVolume;
    private float mRightVolume;
    private boolean mIsAudioFocus = true;
    private final HashMap<String, ArrayList<Integer>> mPathStreamIDsMap = new HashMap();
    private final Object mLockPathStreamIDsMap = new Object();
    private final HashMap<String, Integer> mPathSoundIDMap = new HashMap();
    private ConcurrentHashMap<Integer, SoundInfoForLoadedCompleted> mPlayWhenLoadedEffects = new ConcurrentHashMap();
    private static final int MAX_SIMULTANEOUS_STREAMS_DEFAULT = 5;
    private static final float SOUND_RATE = 1.0f;
    private static final int SOUND_PRIORITY = 1;
    private static final int SOUND_QUALITY = 5;
    private static final int INVALID_SOUND_ID = -1;
    private static final int INVALID_STREAM_ID = -1;
    private static final int LOAD_TIME_OUT = 500;

    XEEffectPlayer() {
        this.initData();
    }

    private void initData() {
        this.mSoundPool = new SoundPool(5, 3, 5);
        this.mSoundPool.setOnLoadCompleteListener((SoundPool.OnLoadCompleteListener)new OnLoadCompletedListener());
        this.mLeftVolume = 0.5f;
        this.mRightVolume = 0.5f;
    }

    public int preloadEffect(String path) {
        Integer soundID = this.mPathSoundIDMap.get(path);
        if (soundID == null && (soundID = Integer.valueOf(this.createSoundIDFromAsset(path))) != -1) {
            this.mPathSoundIDMap.put(path, soundID);
        }
        return soundID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadEffect(String path) {
        Object object = this.mLockPathStreamIDsMap;
        synchronized (object) {
            ArrayList<Integer> streamIDs = this.mPathStreamIDsMap.get(path);
            if (streamIDs != null) {
                for (Integer steamID : streamIDs) {
                    this.mSoundPool.stop(steamID.intValue());
                }
            }
            this.mPathStreamIDsMap.remove(path);
        }
        Integer soundID = this.mPathSoundIDMap.get(path);
        if (soundID != null) {
            this.mSoundPool.unload(soundID.intValue());
            this.mPathSoundIDMap.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playEffect(String path, boolean loop, float pitch, float pan, float gain) {
        Integer soundID = this.mPathSoundIDMap.get(path);
        int streamID = -1;
        if (soundID != null) {
            streamID = this.doPlayEffect(path, soundID, loop, pitch, pan, gain);
        } else {
            soundID = this.preloadEffect(path);
            if (soundID == -1) {
                return -1;
            }
            SoundInfoForLoadedCompleted info = new SoundInfoForLoadedCompleted(path, loop, pitch, pan, gain);
            this.mPlayWhenLoadedEffects.putIfAbsent(soundID, info);
            SoundInfoForLoadedCompleted soundInfoForLoadedCompleted = info;
            synchronized (soundInfoForLoadedCompleted) {
                try {
                    info.wait(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            streamID = info.effectID;
            this.mPlayWhenLoadedEffects.remove(soundID);
        }
        return streamID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEffect(int steamID) {
        this.mSoundPool.stop(steamID);
        Object object = this.mLockPathStreamIDsMap;
        synchronized (object) {
            for (String pPath : this.mPathStreamIDsMap.keySet()) {
                if (!this.mPathStreamIDsMap.get(pPath).contains(steamID)) continue;
                this.mPathStreamIDsMap.get(pPath).remove(this.mPathStreamIDsMap.get(pPath).indexOf(steamID));
                break;
            }
        }
    }

    public void pauseEffect(int steamID) {
        this.mSoundPool.pause(steamID);
    }

    public void resumeEffect(int steamID) {
        this.mSoundPool.resume(steamID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAllEffects() {
        Object object = this.mLockPathStreamIDsMap;
        synchronized (object) {
            if (!this.mPathStreamIDsMap.isEmpty()) {
                for (Map.Entry<String, ArrayList<Integer>> entry : this.mPathStreamIDsMap.entrySet()) {
                    for (int steamID : entry.getValue()) {
                        this.mSoundPool.pause(steamID);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAllEffects() {
        Object object = this.mLockPathStreamIDsMap;
        synchronized (object) {
            if (!this.mPathStreamIDsMap.isEmpty()) {
                for (Map.Entry<String, ArrayList<Integer>> entry : this.mPathStreamIDsMap.entrySet()) {
                    for (int steamID : entry.getValue()) {
                        this.mSoundPool.resume(steamID);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllEffects() {
        Object object = this.mLockPathStreamIDsMap;
        synchronized (object) {
            if (!this.mPathStreamIDsMap.isEmpty()) {
                for (Map.Entry<String, ArrayList<Integer>> entry : this.mPathStreamIDsMap.entrySet()) {
                    for (int steamID : entry.getValue()) {
                        this.mSoundPool.stop(steamID);
                    }
                }
            }
            this.mPathStreamIDsMap.clear();
        }
    }

    public float getEffectsVolume() {
        return (this.mLeftVolume + this.mRightVolume) / 2.0f;
    }

    public void setEffectsVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.mLeftVolume = this.mRightVolume = volume;
        if (!this.mIsAudioFocus) {
            return;
        }
        this.setEffectsVolumeInternal(this.mLeftVolume, this.mRightVolume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEffectsVolumeInternal(float left, float right) {
        Object object = this.mLockPathStreamIDsMap;
        synchronized (object) {
            if (!this.mPathStreamIDsMap.isEmpty()) {
                for (Map.Entry<String, ArrayList<Integer>> entry : this.mPathStreamIDsMap.entrySet()) {
                    for (int steamID : entry.getValue()) {
                        this.mSoundPool.setVolume(steamID, left, right);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        this.mSoundPool.release();
        Object object = this.mLockPathStreamIDsMap;
        synchronized (object) {
            this.mPathStreamIDsMap.clear();
        }
        this.mPathSoundIDMap.clear();
        this.mPlayWhenLoadedEffects.clear();
        this.mLeftVolume = 0.5f;
        this.mRightVolume = 0.5f;
        this.initData();
    }

    private int createSoundIDFromAsset(String path) {
        int soundID = this.mSoundPool.load(path, 0);
        if (soundID == 0) {
            soundID = -1;
        }
        return soundID;
    }

    private float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(value, max));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int doPlayEffect(String path, int soundId, boolean loop, float pitch, float pan, float gain) {
        float leftVolume = this.mLeftVolume * gain * (1.0f - this.clamp(pan, 0.0f, 1.0f));
        float rightVolume = this.mRightVolume * gain * (1.0f - this.clamp(-pan, 0.0f, 1.0f));
        float soundRate = this.clamp(1.0f * pitch, 0.5f, 2.0f);
        int streamID = this.mSoundPool.play(soundId, this.clamp(leftVolume, 0.0f, 1.0f), this.clamp(rightVolume, 0.0f, 1.0f), 1, loop ? -1 : 0, soundRate);
        Object object = this.mLockPathStreamIDsMap;
        synchronized (object) {
            ArrayList<Integer> streamIDs = this.mPathStreamIDsMap.get(path);
            if (streamIDs == null) {
                streamIDs = new ArrayList();
                this.mPathStreamIDsMap.put(path, streamIDs);
            }
            streamIDs.add(streamID);
        }
        return streamID;
    }

    public void onEnterBackground() {
        this.mSoundPool.autoPause();
    }

    public void onEnterForeground() {
        this.mSoundPool.autoResume();
    }

    void setAudioFocus(boolean isFocus) {
        this.mIsAudioFocus = isFocus;
        float leftVolume = this.mIsAudioFocus ? this.mLeftVolume : 0.0f;
        float rightVolume = this.mIsAudioFocus ? this.mRightVolume : 0.0f;
        this.setEffectsVolumeInternal(leftVolume, rightVolume);
    }

    public class OnLoadCompletedListener
    implements SoundPool.OnLoadCompleteListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
            SoundInfoForLoadedCompleted info;
            if (status == 0 && (info = (SoundInfoForLoadedCompleted)XEEffectPlayer.this.mPlayWhenLoadedEffects.get(sampleId)) != null) {
                info.effectID = XEEffectPlayer.this.doPlayEffect(info.path, sampleId, info.isLoop, info.pitch, info.pan, info.gain);
                SoundInfoForLoadedCompleted soundInfoForLoadedCompleted = info;
                synchronized (soundInfoForLoadedCompleted) {
                    info.notifyAll();
                }
            }
        }
    }

    private class SoundInfoForLoadedCompleted {
        boolean isLoop;
        float pitch;
        float pan;
        float gain;
        String path;
        int effectID;

        SoundInfoForLoadedCompleted(String path, boolean isLoop, float pitch, float pan, float gain) {
            this.path = path;
            this.isLoop = isLoop;
            this.pitch = pitch;
            this.pan = pan;
            this.gain = gain;
            this.effectID = -1;
        }
    }
}

