/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.ar;

import com.momo.xeengine.XE3DEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ARCore {
    private static List<IARCoreListener> listeners = new ArrayList<IARCoreListener>();
    private IARCoreListener arCoreListener;
    private static int hitTestLen;
    private static double[] hitTestIds;

    public static void setProjections(float[] projections) {
        if (!XE3DEngine.getInstance().isRunning()) {
            return;
        }
        if (projections != null && projections.length >= 16) {
            ARCore.nProjection(projections);
        }
    }

    public static void setCameraViewMatrix(float[] matrixs) {
        if (!XE3DEngine.getInstance().isRunning()) {
            return;
        }
        if (matrixs != null && matrixs.length >= 16) {
            ARCore.nCameraViewMatrix(matrixs);
        }
    }

    public static void updateAnchors(float[] anchors, double[] anchorIds) {
        if (!XE3DEngine.getInstance().isRunning()) {
            return;
        }
        if (anchors != null && anchors.length >= 24) {
            ARCore.nSetAnchorList(anchors, anchorIds);
        }
    }

    public static void addListener(IARCoreListener l) {
        if (!listeners.contains(l)) {
            listeners.add(l);
        }
    }

    public static void setARHitTestListener() {
        ARCore.nSetListener();
    }

    public static void removeListener(IARCoreListener l) {
        listeners.remove(l);
    }

    private static float[] setHitPose(float x, float y) {
        if (listeners == null || listeners.isEmpty()) {
            return null;
        }
        IARCoreListener l = listeners.get(0);
        Map<Double, float[]> hitPose = l.onHitPose(x, y);
        if (hitPose == null || hitPose.isEmpty()) {
            return null;
        }
        int size = hitPose.size();
        float[] result = new float[size * 17];
        hitTestIds = new double[size];
        int count = 0;
        for (Double key : hitPose.keySet()) {
            float[] f = hitPose.get(key);
            System.arraycopy(f, 0, result, count * 17, 17);
            ARCore.hitTestIds[count] = key;
            ++count;
        }
        hitTestLen = result.length;
        return result;
    }

    private static int getHitTestLen() {
        int retLength = hitTestLen;
        hitTestLen = 0;
        return retLength;
    }

    private static double[] getHitTestIds() {
        double[] returnIds = hitTestIds;
        hitTestIds = null;
        return returnIds;
    }

    public static long getInstance() {
        return ARCore.nGetInstance();
    }

    private static native void nProjection(float[] var0);

    private static native void nCameraViewMatrix(float[] var0);

    private static native void nSetListener();

    private static native long nGetInstance();

    private static native void nSetAnchorList(float[] var0, double[] var1);

    public static interface IARCoreListener {
        public Map<Double, float[]> onHitPose(float var1, float var2);
    }
}

