/*
 * Decompiled with CFR 0.152.
 */
package com.momo.widget;

import android.content.Context;
import android.graphics.Typeface;
import android.text.InputFilter;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.KeyEvent;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import com.momo.widget.XUIEditBoxHelper;

public class XUIEditBox
extends EditText {
    private final int kEditBoxInputModeAny = 0;
    private final int kEditBoxInputModeEmailAddr = 1;
    private final int kEditBoxInputModeNumeric = 2;
    private final int kEditBoxInputModePhoneNumber = 3;
    private final int kEditBoxInputModeUrl = 4;
    private final int kEditBoxInputModeDecimal = 5;
    private final int kEditBoxInputModeSingleLine = 6;
    private final int kEditBoxInputFlagPassword = 0;
    private final int kEditBoxInputFlagSensitive = 1;
    private final int kEditBoxInputFlagInitialCapsWord = 2;
    private final int kEditBoxInputFlagInitialCapsSentence = 3;
    private final int kEditBoxInputFlagInitialCapsAllCharacters = 4;
    private final int kEditBoxInputFlagLowercaseAllCharacters = 5;
    private final int kKeyboardReturnTypeDefault = 0;
    private final int kKeyboardReturnTypeDone = 1;
    private final int kKeyboardReturnTypeSend = 2;
    private final int kKeyboardReturnTypeSearch = 3;
    private final int kKeyboardReturnTypeGo = 4;
    private final int kKeyboardReturnTypeNext = 5;
    public static final int kEndActionUnknown = 0;
    public static final int kEndActionNext = 1;
    public static final int kEndActionReturn = 3;
    private static final int kTextHorizontalAlignmentLeft = 0;
    private static final int kTextHorizontalAlignmentCenter = 1;
    private static final int kTextHorizontalAlignmentRight = 2;
    private static final int kTextVerticalAlignmentTop = 0;
    private static final int kTextVerticalAlignmentCenter = 1;
    private static final int kTextVerticalAlignmentBottom = 2;
    private int mInputFlagConstraints;
    private int mInputModeConstraints;
    private int mMaxLength;
    private int mReturnKeyType;
    private Boolean changedTextProgrammatically = false;
    private float mScaleX;
    int endAction = 0;

    public Boolean getChangedTextProgrammatically() {
        return this.changedTextProgrammatically;
    }

    public void setChangedTextProgrammatically(Boolean changedTextProgrammatically) {
        this.changedTextProgrammatically = changedTextProgrammatically;
    }

    public XUIEditBox(Context context) {
        super(context);
    }

    public void setEditBoxViewRect(int left, int top, int maxWidth, int maxHeight) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.leftMargin = left;
        layoutParams.topMargin = top;
        layoutParams.width = maxWidth;
        layoutParams.height = maxHeight;
        layoutParams.gravity = 51;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public float getOpenGLViewScaleX() {
        return this.mScaleX;
    }

    public void setOpenGLViewScaleX(float mScaleX) {
        this.mScaleX = mScaleX;
    }

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.mMaxLength)});
    }

    public void setMultilineEnabled(boolean flag) {
        this.mInputModeConstraints |= 0x20000;
    }

    public void setReturnType(int returnType) {
        switch (returnType) {
            case 0: {
                this.setImeOptions(0x10000001);
                break;
            }
            case 1: {
                this.setImeOptions(0x10000006);
                break;
            }
            case 2: {
                this.setImeOptions(0x10000004);
                break;
            }
            case 3: {
                this.setImeOptions(0x10000003);
                break;
            }
            case 4: {
                this.setImeOptions(0x10000002);
                break;
            }
            case 5: {
                this.setImeOptions(0x10000005);
                break;
            }
            default: {
                this.setImeOptions(0x10000001);
            }
        }
        this.mReturnKeyType = returnType;
    }

    public int GetReturnType() {
        return this.mReturnKeyType;
    }

    public void setTextHorizontalAlignment(int alignment) {
        int gravity = this.getGravity();
        switch (alignment) {
            case 0: {
                gravity = gravity & 0xFFFFFFFA | 3;
                break;
            }
            case 1: {
                gravity = gravity & 0xFFFFFFFA & 0xFFFFFFFC | 1;
                break;
            }
            case 2: {
                gravity = gravity & 0xFFFFFFFC | 5;
                break;
            }
            default: {
                gravity = gravity & 0xFFFFFFFA | 3;
            }
        }
        this.setGravity(gravity);
    }

    public void setTextVerticalAlignment(int alignment) {
        int gravity = this.getGravity();
        int padding = XUIEditBoxHelper.getPadding(this.mScaleX);
        switch (alignment) {
            case 0: {
                this.setPadding(padding, padding * 3 / 4, 0, 0);
                gravity = gravity & 0xFFFFFFAF | 0x30;
                break;
            }
            case 1: {
                this.setPadding(padding, 0, 0, padding / 2);
                gravity = gravity & 0xFFFFFFCF & 0xFFFFFFAF | 0x10;
                break;
            }
            case 2: {
                gravity = gravity & 0xFFFFFFCF | 0x50;
                break;
            }
            default: {
                this.setPadding(padding, 0, 0, padding / 2);
                gravity = gravity & 0xFFFFFFCF & 0xFFFFFFAF | 0x10;
            }
        }
        this.setGravity(gravity);
    }

    public void setInputMode(int inputMode) {
        this.setTextHorizontalAlignment(0);
        this.setTextVerticalAlignment(1);
        switch (inputMode) {
            case 0: {
                this.setTextVerticalAlignment(0);
                this.mInputModeConstraints = 131073;
                break;
            }
            case 1: {
                this.mInputModeConstraints = 33;
                break;
            }
            case 2: {
                this.mInputModeConstraints = 4098;
                break;
            }
            case 3: {
                this.mInputModeConstraints = 3;
                break;
            }
            case 4: {
                this.mInputModeConstraints = 17;
                break;
            }
            case 5: {
                this.mInputModeConstraints = 12290;
                break;
            }
            case 6: {
                this.mInputModeConstraints = 1;
                break;
            }
        }
        this.setInputType(this.mInputModeConstraints | this.mInputFlagConstraints);
    }

    public boolean onKeyDown(int pKeyCode, KeyEvent pKeyEvent) {
        switch (pKeyCode) {
            case 4: {
                return true;
            }
        }
        return super.onKeyDown(pKeyCode, pKeyEvent);
    }

    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        return super.onKeyPreIme(keyCode, event);
    }

    public void setInputFlag(int inputFlag) {
        switch (inputFlag) {
            case 0: {
                this.mInputFlagConstraints = 129;
                this.setTypeface(Typeface.DEFAULT);
                this.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
                break;
            }
            case 1: {
                this.mInputFlagConstraints = 524288;
                break;
            }
            case 2: {
                this.mInputFlagConstraints = 8192;
                break;
            }
            case 3: {
                this.mInputFlagConstraints = 16384;
                break;
            }
            case 4: {
                this.mInputFlagConstraints = 4096;
                break;
            }
            case 5: {
                this.mInputFlagConstraints = 1;
                break;
            }
        }
        this.setInputType(this.mInputFlagConstraints | this.mInputModeConstraints);
    }
}

