/*
 * Decompiled with CFR 0.152.
 */
package com.momo.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import com.momo.widget.XUITypefaces;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class XUIBitmap {
    private static final int HORIZONTAL_ALIGN_LEFT = 1;
    private static final int HORIZONTAL_ALIGN_RIGHT = 2;
    private static final int HORIZONTAL_ALIGN_CENTER = 3;
    private static final int VERTICAL_ALIGN_TOP = 1;
    private static final int VERTICAL_ALIGN_BOTTOM = 2;
    private static final int VERTICAL_ALIGN_CENTER = 3;
    private static Context sContext;

    public static void setContext(Context context) {
        sContext = context;
    }

    private static native void nativeInitBitmapDC(int var0, int var1, byte[] var2);

    public static int getTextHeight(String text, int maxWidth, float textSize, Typeface typeface) {
        TextPaint paint = new TextPaint(129);
        paint.setTextSize(textSize);
        paint.setTypeface(typeface);
        int lineCount = 0;
        int index = 0;
        int length = text.length();
        while (index < length) {
            int charsToAdvance = paint.breakText((CharSequence)text, index, length, true, (float)maxWidth, null);
            if (charsToAdvance == 0) {
                ++index;
                continue;
            }
            index += charsToAdvance;
            ++lineCount;
        }
        float actualHeight = Math.abs(paint.ascent()) + Math.abs(paint.descent());
        return (int)Math.floor((float)lineCount * actualHeight);
    }

    public static Typeface calculateShrinkTypeFace(String text, int width, int height, Layout.Alignment hAlignment, float textSize, TextPaint paint, boolean enableWrap) {
        if (width == 0 || height == 0) {
            return paint.getTypeface();
        }
        float actualWidth = width + 1;
        float actualHeight = height + 1;
        float fontSize = textSize + 1.0f;
        if (!enableWrap) {
            while (actualWidth > (float)width || actualHeight > (float)height) {
                actualWidth = (int)Math.ceil(StaticLayout.getDesiredWidth((CharSequence)text, (TextPaint)paint));
                actualHeight = XUIBitmap.getTextHeight(text, (int)actualWidth, fontSize -= 1.0f, paint.getTypeface());
                paint.setTextSize(fontSize);
                if (!(fontSize <= 0.0f)) continue;
                paint.setTextSize(textSize);
                break;
            }
        } else {
            while (actualHeight > (float)height || actualWidth > (float)width) {
                StaticLayout layout = new StaticLayout((CharSequence)text, paint, width, hAlignment, 1.0f, 0.0f, false);
                actualWidth = layout.getWidth();
                actualHeight = layout.getLineTop(layout.getLineCount());
                paint.setTextSize(fontSize -= 1.0f);
                if (!(fontSize <= 0.0f)) continue;
                paint.setTextSize(textSize);
                break;
            }
        }
        return paint.getTypeface();
    }

    public static boolean createTextBitmapShadowStroke(byte[] bytes, String fontName, int fontSize, int fontTintR, int fontTintG, int fontTintB, int fontTintA, int nHAlignment, int nVAlignment, int width, int height, boolean shadow, float shadowDX, float shadowDY, float shadowBlur, float shadowOpacity, boolean stroke, int strokeR, int strokeG, int strokeB, int strokeA, float strokeSize, boolean enableWrap, int overflow) {
        int maxWidth;
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        String string = new String(bytes);
        Layout.Alignment hAlignment = Layout.Alignment.ALIGN_NORMAL;
        switch (nHAlignment) {
            case 3: {
                hAlignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 2: {
                hAlignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 1: {
                break;
            }
        }
        TextPaint paint = XUIBitmap.newPaint(fontName, fontSize);
        if (stroke) {
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(strokeSize);
        }
        if ((maxWidth = width) <= 0) {
            maxWidth = (int)Math.ceil(StaticLayout.getDesiredWidth((CharSequence)string, (TextPaint)paint));
        }
        StaticLayout layout = null;
        int layoutWidth = 0;
        int layoutHeight = 0;
        if (overflow == 1 && !enableWrap) {
            int widthBoundary = (int)Math.ceil(StaticLayout.getDesiredWidth((CharSequence)string, (TextPaint)paint));
            layout = new StaticLayout((CharSequence)string, paint, widthBoundary, hAlignment, 1.0f, 0.0f, false);
        } else {
            if (overflow == 2) {
                XUIBitmap.calculateShrinkTypeFace(string, width, height, hAlignment, fontSize, paint, enableWrap);
            }
            layout = new StaticLayout((CharSequence)string, paint, maxWidth, hAlignment, 1.0f, 0.0f, false);
        }
        layoutWidth = layout.getWidth();
        layoutHeight = layout.getLineTop(layout.getLineCount());
        int bitmapWidth = Math.max(layoutWidth, width);
        int bitmapHeight = layoutHeight;
        if (height > 0) {
            bitmapHeight = height;
        }
        if (overflow == 1 && !enableWrap && width > 0) {
            bitmapWidth = width;
        }
        if (bitmapWidth == 0 || bitmapHeight == 0) {
            return false;
        }
        int offsetX = 0;
        if (nHAlignment == 3) {
            offsetX = (bitmapWidth - layoutWidth) / 2;
        } else if (nHAlignment == 2) {
            offsetX = bitmapWidth - layoutWidth;
        }
        int offsetY = 0;
        switch (nVAlignment) {
            case 3: {
                offsetY = (bitmapHeight - layoutHeight) / 2;
                break;
            }
            case 2: {
                offsetY = bitmapHeight - layoutHeight;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)offsetX, (float)offsetY);
        if (stroke) {
            paint.setARGB(strokeA, strokeR, strokeG, strokeB);
            layout.draw(canvas);
        }
        paint.setStyle(Paint.Style.FILL);
        paint.setARGB(fontTintA, fontTintR, fontTintG, fontTintB);
        layout.draw(canvas);
        XUIBitmap.initNativeObject(bitmap);
        return true;
    }

    private static TextPaint newPaint(String fontName, int fontSize) {
        TextPaint paint = new TextPaint();
        paint.setTextSize((float)fontSize);
        paint.setAntiAlias(true);
        if (fontName.endsWith(".ttf")) {
            try {
                Typeface typeFace = XUITypefaces.get(sContext, fontName);
                paint.setTypeface(typeFace);
            }
            catch (Exception e) {
                Log.e((String)"XUIBitmap", (String)("error to create ttf type face: " + fontName));
                paint.setTypeface(Typeface.create((String)fontName, (int)0));
            }
        } else {
            paint.setTypeface(Typeface.create((String)fontName, (int)0));
        }
        return paint;
    }

    private static void initNativeObject(Bitmap bitmap) {
        byte[] pixels = XUIBitmap.getPixels(bitmap);
        if (pixels == null) {
            return;
        }
        XUIBitmap.nativeInitBitmapDC(bitmap.getWidth(), bitmap.getHeight(), pixels);
    }

    private static byte[] getPixels(Bitmap bitmap) {
        if (bitmap != null) {
            byte[] pixels = new byte[bitmap.getWidth() * bitmap.getHeight() * 4];
            ByteBuffer buf = ByteBuffer.wrap(pixels);
            buf.order(ByteOrder.nativeOrder());
            bitmap.copyPixelsToBuffer((Buffer)buf);
            return pixels;
        }
        return null;
    }

    public static int getFontSizeAccordingHeight(int height) {
        TextPaint paint = new TextPaint();
        Rect bounds = new Rect();
        paint.setTypeface(Typeface.DEFAULT);
        int text_size = 1;
        boolean found_desired_size = false;
        while (!found_desired_size) {
            paint.setTextSize((float)text_size);
            String text = "SghMNy";
            paint.getTextBounds(text, 0, text.length(), bounds);
            ++text_size;
            if (height - bounds.height() > 2) continue;
            found_desired_size = true;
        }
        return text_size;
    }

    private static String getStringWithEllipsis(String string, float width, float fontSize) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        TextPaint paint = new TextPaint();
        paint.setTypeface(Typeface.DEFAULT);
        paint.setTextSize(fontSize);
        return TextUtils.ellipsize((CharSequence)string, (TextPaint)paint, (float)width, (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString();
    }
}

