/*
 * Decompiled with CFR 0.152.
 */
package com.momo.widget;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.momo.widget.RenderView;

public class RenderViewContainer
extends FrameLayout {
    private RenderView renderView;
    private boolean isSetRender = false;

    public RenderViewContainer(Context context) {
        super(context);
        this.init();
    }

    public RenderViewContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RenderViewContainer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setBackgroundColor(0);
    }

    public void onPause() {
        if (this.renderView != null) {
            this.renderView.onPause();
        }
    }

    public void onResume() {
        if (this.renderView != null) {
            this.renderView.onResume();
        }
    }

    public void setGLSurfaceViewVisiable(int visiable) {
        if (this.renderView != null) {
            this.renderView.setVisibility(visiable);
        }
    }

    public void addGLSurfaceView() {
        this.removeAllViews();
        this.renderView = new RenderView(this.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.renderView.setLayoutParams(params);
        this.addView((View)this.renderView);
        this.isSetRender = false;
    }

    public void setRender(GLSurfaceView.Renderer renderer) {
        if (this.renderView != null && !this.isSetRender) {
            this.renderView.setRenderer(renderer);
            this.isSetRender = true;
        }
    }
}

