/*
 * Decompiled with CFR 0.152.
 */
package com.momo.widget;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.TextureView;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.xnative.XEWindow;

public class MTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private boolean isMultipleTouchEnabled = true;
    private boolean isTouchModeEnable = true;

    public MTextureView(Context context) {
        this(context, null);
    }

    public MTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setFocusableInTouchMode(true);
        this.setSurfaceTextureListener(this);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        GLES20.glClear((int)16640);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        GLES20.glClear((int)16640);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        GLES20.glClear((int)16640);
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        GLES20.glClear((int)16640);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isTouchModeEnable) {
            return super.onTouchEvent(event);
        }
        final int pointerNumber = event.getPointerCount();
        final int[] ids = new int[pointerNumber];
        final float[] xs = new float[pointerNumber];
        final float[] ys = new float[pointerNumber];
        for (int i = 0; i < pointerNumber; ++i) {
            ids[i] = event.getPointerId(i);
            xs[i] = event.getX(i);
            ys[i] = event.getY(i);
        }
        XE3DEngine engine = XE3DEngine.getInstance();
        final XEWindow window = engine.getWindow();
        if (window == null) {
            return true;
        }
        block0 : switch (event.getAction() & 0xFF) {
            case 5: {
                int indexPointerDown = event.getAction() >> 8;
                if (!this.isMultipleTouchEnabled && indexPointerDown != 0) break;
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesBegin(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 0: {
                int idDown = event.getPointerId(0);
                float xDown = xs[0];
                float yDown = ys[0];
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesBegin(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 2: {
                if (!this.isMultipleTouchEnabled) {
                    for (int i = 0; i < pointerNumber; ++i) {
                        if (ids[i] != 0) continue;
                        int[] idsMove = new int[]{0};
                        final float[] xsMove = new float[]{xs[i]};
                        final float[] ysMove = new float[]{ys[i]};
                        engine.queueEvent(new Runnable(){

                            @Override
                            public void run() {
                                window.handleTouchesMove(pointerNumber, ids, xsMove, ysMove);
                            }
                        });
                        break block0;
                    }
                    break;
                }
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesMove(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 6: {
                int indexPointUp = event.getAction() >> 8;
                if (!this.isMultipleTouchEnabled && indexPointUp != 0) break;
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 1: {
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 3: {
                if (!this.isMultipleTouchEnabled) {
                    for (int i = 0; i < pointerNumber; ++i) {
                        if (ids[i] != 0) continue;
                        int[] idsCancel = new int[]{0};
                        final float[] xsCancel = new float[]{xs[i]};
                        final float[] ysCancel = new float[]{ys[i]};
                        engine.queueEvent(new Runnable(){

                            @Override
                            public void run() {
                                window.handleTouchesCancel(pointerNumber, ids, xsCancel, ysCancel);
                            }
                        });
                        break block0;
                    }
                    break;
                }
                engine.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
        }
        return true;
    }

    public void setMultipleTouchEnabled(boolean multipleTouchEnabled) {
        this.isMultipleTouchEnabled = multipleTouchEnabled;
    }

    public void setTouchModeEnable(boolean touchModeEnable) {
        this.isTouchModeEnable = touchModeEnable;
    }
}

