/*
 * Decompiled with CFR 0.152.
 */
package com.momo.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLUtils;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.TextureView;
import com.momo.widget.IGameView;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.xnative.XESystemEventDispatcher;
import com.momo.xeengine.xnative.XEWindow;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;

public class GameTextureView
extends TextureView
implements IGameView {
    public static final String TAG = "GameTextureView";
    private IGameView.IGameController gameController;
    private GameRender gameRender;
    private boolean mMultipleTouchEnabled = true;

    public void setGameController(IGameView.IGameController callback) {
        this.gameController = callback;
    }

    public GameTextureView(Context context) {
        super(context);
        this.init();
    }

    public GameTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setFocusableInTouchMode(true);
        this.gameRender = new GameRender();
        this.setSurfaceTextureListener(this.gameRender);
        XE3DEngine.getInstance().init(this.getContext());
    }

    public void setBackgroundTransparent(boolean bgTransparent) {
        this.setOpaque(!bgTransparent);
    }

    @Override
    public void startGame() {
        Log.d((String)TAG, (String)"startGame: ");
        this.gameRender.start();
    }

    @Override
    public void endGame() {
        XE3DEngine.getInstance().endEngine();
    }

    @Override
    public void pauseGame() {
        XESystemEventDispatcher.callPause();
    }

    @Override
    public void resumeGame() {
        XESystemEventDispatcher.callResume();
    }

    public boolean onTouchEvent(MotionEvent event) {
        int pointerNumber = event.getPointerCount();
        int[] ids = new int[pointerNumber];
        float[] xs = new float[pointerNumber];
        float[] ys = new float[pointerNumber];
        for (int i = 0; i < pointerNumber; ++i) {
            ids[i] = event.getPointerId(i);
            xs[i] = event.getX(i);
            ys[i] = event.getY(i);
        }
        XEWindow window = XE3DEngine.getInstance().getWindow();
        if (window == null) {
            return true;
        }
        block0 : switch (event.getAction() & 0xFF) {
            case 5: {
                int indexPointerDown = event.getAction() >> 8;
                if (!this.mMultipleTouchEnabled && indexPointerDown != 0) break;
                window.handleTouchesBegin(pointerNumber, ids, xs, ys);
                break;
            }
            case 0: {
                int idDown = event.getPointerId(0);
                float xDown = xs[0];
                float yDown = ys[0];
                window.handleTouchesBegin(pointerNumber, ids, xs, ys);
                break;
            }
            case 2: {
                if (!this.mMultipleTouchEnabled) {
                    for (int i = 0; i < pointerNumber; ++i) {
                        if (ids[i] != 0) continue;
                        int[] idsMove = new int[]{0};
                        float[] xsMove = new float[]{xs[i]};
                        float[] ysMove = new float[]{ys[i]};
                        window.handleTouchesMove(pointerNumber, ids, xsMove, ysMove);
                        break block0;
                    }
                    break;
                }
                window.handleTouchesMove(pointerNumber, ids, xs, ys);
                break;
            }
            case 6: {
                int indexPointUp = event.getAction() >> 8;
                if (!this.mMultipleTouchEnabled && indexPointUp != 0) break;
                window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                break;
            }
            case 1: {
                window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                break;
            }
            case 3: {
                if (!this.mMultipleTouchEnabled) {
                    for (int i = 0; i < pointerNumber; ++i) {
                        if (ids[i] != 0) continue;
                        int[] idsCancel = new int[]{0};
                        float[] xsCancel = new float[]{xs[i]};
                        float[] ysCancel = new float[]{ys[i]};
                        window.handleTouchesCancel(pointerNumber, ids, xsCancel, ysCancel);
                        break block0;
                    }
                    break;
                }
                window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                break;
            }
        }
        return true;
    }

    public void setMultipleTouchEnabled(boolean multipleTouchEnabled) {
        this.mMultipleTouchEnabled = multipleTouchEnabled;
    }

    public boolean isMultipleTouchEnabled() {
        return this.mMultipleTouchEnabled;
    }

    public Bitmap shot() {
        this.setDrawingCacheEnabled(true);
        this.buildDrawingCache();
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)this.getDrawingCache());
        this.setDrawingCacheEnabled(false);
        return bitmap;
    }

    class GameRender
    implements TextureView.SurfaceTextureListener {
        private static final int RENDER_MSG = 0;
        @SuppressLint(value={"HandlerLeak"})
        private Handler mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                GameRender.this.render();
                this.sendEmptyMessage(0);
            }
        };
        private EGL10 mEgl;
        private EGLDisplay mEglDisplay = EGL10.EGL_NO_DISPLAY;
        private EGLContext mEglContext = EGL10.EGL_NO_CONTEXT;
        private EGLSurface mEglSurface = EGL10.EGL_NO_SURFACE;
        private GL mGL;
        private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
        private static final int EGL_OPENGL_ES2_BIT = 4;
        private int height;
        private int width;

        GameRender() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            this.width = width;
            this.height = height;
            this.initGL(surface);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            XE3DEngine.getInstance().resizeWindow(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            this.mHandler.removeMessages(0);
            this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
            this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglSurface);
            this.mEglContext = EGL10.EGL_NO_CONTEXT;
            this.mEglSurface = EGL10.EGL_NO_SURFACE;
            XE3DEngine.getInstance().endEngine();
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }

        public void start() {
            if (GameTextureView.this.gameController != null) {
                XE3DEngine.getInstance().setLibraryPath(GameTextureView.this.gameController.getGameResPath());
                XE3DEngine.getInstance().runEngine(this.width, this.height);
                XE3DEngine.getInstance().clearBackground();
                GameTextureView.this.gameController.onGameStart();
                this.mHandler.sendEmptyMessage(0);
            }
        }

        private void initGL(SurfaceTexture surface) {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetdisplay failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
            }
            int[] version = new int[2];
            if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
                throw new RuntimeException("eglInitialize failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
            }
            int[] configAttribs = new int[]{12320, 32, 12325, 24, 12321, 8, 12322, 8, 12323, 8, 12324, 8, 12352, 4, 12339, 4, 12344};
            EGLConfig[] configs = new EGLConfig[1];
            int[] numConfigs = new int[1];
            if (!this.mEgl.eglChooseConfig(this.mEglDisplay, configAttribs, configs, 1, numConfigs)) {
                throw new RuntimeException("eglChooseConfig failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
            }
            int[] contextAttribs = new int[]{12440, 2, 12344};
            this.mEglContext = this.mEgl.eglCreateContext(this.mEglDisplay, configs[0], EGL10.EGL_NO_CONTEXT, contextAttribs);
            this.mEglSurface = this.mEgl.eglCreateWindowSurface(this.mEglDisplay, configs[0], (Object)surface, null);
            if (this.mEglSurface == EGL10.EGL_NO_SURFACE || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                int error = this.mEgl.eglGetError();
                if (error == 12299) {
                    throw new RuntimeException("eglCreateWindowSurface returned  EGL_BAD_NATIVE_WINDOW. ");
                }
                throw new RuntimeException("eglCreateWindowSurface failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                throw new RuntimeException("eglMakeCurrent failed : " + GLUtils.getEGLErrorString((int)this.mEgl.eglGetError()));
            }
            this.mGL = this.mEglContext.getGL();
        }

        public void render() {
            XE3DEngine.getInstance().getDirector().resizeWindow(GameTextureView.this.getWidth(), GameTextureView.this.getHeight());
            XE3DEngine.getInstance().getDirector().render();
            this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface);
        }
    }
}

