/*
 * Decompiled with CFR 0.152.
 */
package com.momo.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.momo.test.Logger;
import com.momo.widget.IGameView;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.xnative.XESystemEventDispatcher;
import com.momo.xeengine.xnative.XEWindow;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GameSurfaceView
extends GLSurfaceView
implements IGameView {
    private IGameView.IGameController gameController;
    private boolean mMultipleTouchEnabled = true;
    private boolean bgTransparent = false;
    private boolean shouldShotAfterRender = false;
    private boolean gameStarted = false;
    private boolean isSurfaceCreated = false;
    private boolean shouldStartAfterSurfaceCreated = false;

    public void setGameController(IGameView.IGameController callback) {
        this.gameController = callback;
    }

    public GameSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GameSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        XE3DEngine.getInstance().init(this.getContext());
        this.setEGLContextClientVersion(2);
        this.setFocusableInTouchMode(true);
        this.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        this.setZOrderOnTop(true);
        this.setRenderer(new GameRender());
    }

    public void setBackgroundTransparent(boolean bgTransparent) {
        this.bgTransparent = bgTransparent;
        if (this.bgTransparent) {
            this.getHolder().setFormat(-2);
        } else {
            this.getHolder().setFormat(-1);
        }
    }

    @Override
    public void startGame() {
        if (!this.gameStarted) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    GameSurfaceView.this.engineStartGame();
                }
            });
        }
    }

    private void engineStartGame() {
        if (!this.isSurfaceCreated) {
            this.shouldStartAfterSurfaceCreated = true;
            return;
        }
        if (this.gameController != null) {
            Logger.p("startGame");
            XE3DEngine.getInstance().setLibraryPath(this.gameController.getGameResPath());
            XE3DEngine.getInstance().runEngine(this.getWidth(), this.getHeight());
            XE3DEngine.getInstance().clearBackground();
            this.gameController.onGameStart();
            this.gameStarted = true;
        }
    }

    @Override
    public void endGame() {
        if (this.gameStarted) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    XE3DEngine.getInstance().endEngine();
                }
            });
        }
    }

    @Override
    public void pauseGame() {
        if (this.gameStarted) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    XESystemEventDispatcher.callPause();
                }
            });
        }
    }

    @Override
    public void resumeGame() {
        if (this.gameStarted) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    XESystemEventDispatcher.callResume();
                }
            });
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        final int pointerNumber = event.getPointerCount();
        final int[] ids = new int[pointerNumber];
        final float[] xs = new float[pointerNumber];
        final float[] ys = new float[pointerNumber];
        for (int i = 0; i < pointerNumber; ++i) {
            ids[i] = event.getPointerId(i);
            xs[i] = event.getX(i);
            ys[i] = event.getY(i);
        }
        final XEWindow window = XE3DEngine.getInstance().getWindow();
        if (window == null) {
            return true;
        }
        block0 : switch (event.getAction() & 0xFF) {
            case 5: {
                int indexPointerDown = event.getAction() >> 8;
                if (!this.mMultipleTouchEnabled && indexPointerDown != 0) break;
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesBegin(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 0: {
                int idDown = event.getPointerId(0);
                float xDown = xs[0];
                float yDown = ys[0];
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesBegin(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 2: {
                if (!this.mMultipleTouchEnabled) {
                    for (int i = 0; i < pointerNumber; ++i) {
                        if (ids[i] != 0) continue;
                        int[] idsMove = new int[]{0};
                        final float[] xsMove = new float[]{xs[i]};
                        final float[] ysMove = new float[]{ys[i]};
                        this.queueEvent(new Runnable(){

                            @Override
                            public void run() {
                                window.handleTouchesMove(pointerNumber, ids, xsMove, ysMove);
                            }
                        });
                        break block0;
                    }
                    break;
                }
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesMove(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 6: {
                int indexPointUp = event.getAction() >> 8;
                if (!this.mMultipleTouchEnabled && indexPointUp != 0) break;
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 1: {
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
            case 3: {
                if (!this.mMultipleTouchEnabled) {
                    for (int i = 0; i < pointerNumber; ++i) {
                        if (ids[i] != 0) continue;
                        int[] idsCancel = new int[]{0};
                        final float[] xsCancel = new float[]{xs[i]};
                        final float[] ysCancel = new float[]{ys[i]};
                        this.queueEvent(new Runnable(){

                            @Override
                            public void run() {
                                window.handleTouchesCancel(pointerNumber, ids, xsCancel, ysCancel);
                            }
                        });
                        break block0;
                    }
                    break;
                }
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        window.handleTouchesEnd(pointerNumber, ids, xs, ys);
                    }
                });
                break;
            }
        }
        return true;
    }

    public void setMultipleTouchEnabled(boolean multipleTouchEnabled) {
        this.mMultipleTouchEnabled = multipleTouchEnabled;
    }

    public boolean isMultipleTouchEnabled() {
        return this.mMultipleTouchEnabled;
    }

    public void shot() {
        this.shouldShotAfterRender = true;
    }

    private class GameRender
    implements GLSurfaceView.Renderer {
        private GameRender() {
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            GameSurfaceView.this.isSurfaceCreated = true;
            if (GameSurfaceView.this.shouldStartAfterSurfaceCreated) {
                GameSurfaceView.this.engineStartGame();
            }
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            XE3DEngine.getInstance().resizeWindow(width, height);
        }

        public void onDrawFrame(GL10 gl) {
            XE3DEngine.getInstance().resizeWindow(GameSurfaceView.this.getWidth(), GameSurfaceView.this.getHeight());
            XE3DEngine.getInstance().render();
            if (GameSurfaceView.this.shouldShotAfterRender) {
                GameSurfaceView.this.shouldShotAfterRender = false;
                int width = GameSurfaceView.this.getWidth();
                int height = GameSurfaceView.this.getHeight();
                if (width == 0 || height == 0) {
                    return;
                }
                ByteBuffer PixelBuffer = ByteBuffer.allocate(width * height * 4);
                PixelBuffer.position(0);
                GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)PixelBuffer);
                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.copyPixelsFromBuffer((Buffer)PixelBuffer);
                Matrix matrix = new Matrix();
                matrix.postScale(1.0f, -1.0f);
                matrix.postRotate(0.0f);
                Bitmap bitmap = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                GameSurfaceView.this.gameController.onShot(bitmap);
            }
        }
    }
}

