/*
 * Decompiled with CFR 0.152.
 */
package com.momo.test;

import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    private static String TAG_DEFAULT = "[XENGINE]";
    private static boolean enable = false;
    private static volatile Map<String, Long> sPointMap;

    public static void setEnable(boolean enable) {
        Logger.enable = enable;
    }

    public static void p(Object ... args) {
        if (enable) {
            Log.e((String)TAG_DEFAULT, (String)Logger.appendStr(args));
        }
    }

    public static void d(Object ... args) {
        if (enable) {
            Log.d((String)TAG_DEFAULT, (String)Logger.appendStr(args));
        }
    }

    public static void e(Object ... args) {
        if (enable) {
            Log.e((String)TAG_DEFAULT, (String)Logger.appendStr(args));
        }
    }

    public static void printStakeTrace(Throwable e) {
        if (enable && e != null) {
            e.printStackTrace();
        }
    }

    private static String appendStr(Object ... args) {
        StringBuilder sb = new StringBuilder();
        if (args == null) {
            return "null ";
        }
        for (Object arg : args) {
            sb.append(arg == null ? "null" : arg.toString()).append(" ");
        }
        return sb.toString();
    }

    public static void mark(String mark) {
        if (enable) {
            if (sPointMap == null) {
                sPointMap = new HashMap<String, Long>();
            }
            if (TextUtils.isEmpty((CharSequence)mark)) {
                throw new IllegalArgumentException("mark should not be null");
            }
            long currentTimeMillis = System.currentTimeMillis();
            sPointMap.put(mark, currentTimeMillis);
        }
    }

    public static long check(String mark) {
        if (enable) {
            if (sPointMap == null) {
                throw new IllegalArgumentException("please mark point first");
            }
            if (TextUtils.isEmpty((CharSequence)mark)) {
                throw new IllegalArgumentException("mark should not be null");
            }
            Long lastMarkTime = sPointMap.get(mark);
            long costTime = System.currentTimeMillis() - (lastMarkTime == null ? 0L : lastMarkTime);
            Logger.e("time consume with mark_" + mark + "===> " + costTime + " mm");
            return costTime;
        }
        return 0L;
    }
}

