/*
 * Decompiled with CFR 0.152.
 */
package com.momo.render;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.text.TextUtils;
import com.momo.gl.filter.LazyFilter;
import com.momo.render.IXeInnerRender;
import com.momo.render.SharedExecutor;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeview.XeRenderViewController;

public class XeSharedEngineRender
implements IXeInnerRender {
    private final XeRenderViewController.OnPreparedCallback mXeSurfaceCallback;
    private SharedExecutor.OnRenderCallback mOnRenderCallback;
    private int mTextureShare;
    private LazyFilter mLazyFilter;
    private String mTaskName = this.toString() + this.hashCode();
    private String mRootPath;
    private boolean isPrepared;
    private String mSceneId;

    public XeSharedEngineRender(XeRenderViewController.OnPreparedCallback xeSurfaceCallback) {
        this.mXeSurfaceCallback = xeSurfaceCallback;
    }

    @Override
    public void init(Context context, String rootPath) {
        this.mRootPath = rootPath;
        XE3DEngine.getInstance().init(context);
    }

    @Override
    public void onSurfacePrepared() {
    }

    @Override
    public void onSurfaceChanged(final int width, final int height) {
        if (this.mOnRenderCallback == null) {
            SharedExecutor.getInstance().init(EGL14.eglGetCurrentContext());
            this.mOnRenderCallback = new SharedExecutor.OnRenderCallback(){

                @Override
                public void onTextureCreated(String name, int textureId) {
                    XeSharedEngineRender.this.mTextureShare = textureId;
                    XE3DEngine.getInstance().setLibraryPath(XeSharedEngineRender.this.mRootPath);
                    XE3DEngine.getInstance().runEngine(width, height);
                    XE3DEngine.getInstance().clearBackground();
                    if (XeSharedEngineRender.this.mXeSurfaceCallback != null) {
                        XeSharedEngineRender.this.mXeSurfaceCallback.onPrepared();
                        XeSharedEngineRender.this.isPrepared = true;
                    }
                }

                @Override
                public int getBgTexture() {
                    return 0;
                }

                @Override
                public void onRender(String name) {
                    XE3DEngine.getInstance().resizeWindow(width, height);
                    if (TextUtils.isEmpty((CharSequence)XeSharedEngineRender.this.mSceneId)) {
                        XE3DEngine.getInstance().render();
                    } else {
                        XE3DEngine.getInstance().render(XeSharedEngineRender.this.mSceneId);
                    }
                    GLES20.glFinish();
                }
            };
            SharedExecutor.getInstance().addRenderTask(this.mTaskName, width, height, this.mOnRenderCallback);
            SharedExecutor.getInstance().startRender();
            this.mLazyFilter = new LazyFilter();
            this.mLazyFilter.create();
        }
        if (this.isPrepared) {
            this.mXeSurfaceCallback.onSurfaceChanged(width, height);
        }
    }

    @Override
    public void onDrawFrame() {
        this.mSceneId = null;
        this.render();
    }

    private void render() {
        SharedExecutor.getInstance().render(this.mTaskName);
        if (this.mTextureShare != 0) {
            this.mLazyFilter.draw(this.mTextureShare);
        }
    }

    @Override
    public void onDrawFrame(String sceneId) {
        if (!sceneId.equals(this.mSceneId)) {
            this.mSceneId = sceneId;
        }
        this.render();
    }

    @Override
    public void onDestroyed() {
        SharedExecutor.getInstance().removeTask(this.mTaskName);
        this.mOnRenderCallback = null;
        if (this.mXeSurfaceCallback != null) {
            this.mXeSurfaceCallback.onDestroyed();
        }
    }
}

