/*
 * Decompiled with CFR 0.152.
 */
package com.momo.render;

import android.content.Context;
import com.momo.render.IXeInnerRender;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeview.XeRenderViewController;

public class XeEngineRender
implements IXeInnerRender {
    private String mRootPath;
    private XeRenderViewController.OnPreparedCallback mXeSurfaceCallback;
    private boolean isPrepared;

    public XeEngineRender(XeRenderViewController.OnPreparedCallback xeSurfaceCallback) {
        this.mXeSurfaceCallback = xeSurfaceCallback;
    }

    @Override
    public void init(Context context, String rootPath) {
        this.mRootPath = rootPath;
        XE3DEngine.getInstance().init(context);
    }

    @Override
    public void onSurfacePrepared() {
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        if (!this.isPrepared) {
            XE3DEngine.getInstance().setLibraryPath(this.mRootPath);
            XE3DEngine.getInstance().runEngine(width, height);
            XE3DEngine.getInstance().clearBackground();
            if (this.mXeSurfaceCallback != null) {
                this.mXeSurfaceCallback.onPrepared();
            }
            this.isPrepared = true;
        }
        XE3DEngine.getInstance().resizeWindow(width, height);
        if (this.mXeSurfaceCallback != null) {
            this.mXeSurfaceCallback.onSurfaceChanged(width, height);
        }
    }

    @Override
    public void onDrawFrame() {
        XE3DEngine.getInstance().render();
    }

    @Override
    public void onDrawFrame(String sceneId) {
        XE3DEngine.getInstance().render(sceneId);
    }

    @Override
    public void onDestroyed() {
        XE3DEngine.getInstance().endEngine();
        if (this.mXeSurfaceCallback != null) {
            this.mXeSurfaceCallback.onDestroyed();
        }
    }
}

