/*
 * Decompiled with CFR 0.152.
 */
package com.momo.gl.utils;

import android.opengl.Matrix;

public enum MatrixUtils {

    public static final int TYPE_FITXY = 0;
    public static final int TYPE_CENTERCROP = 1;
    public static final int TYPE_CENTERINSIDE = 2;
    public static final int TYPE_FITSTART = 3;
    public static final int TYPE_FITEND = 4;

    public static float[] getOriginalTextureCo() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    }

    public static float[] getOriginalVertexCo() {
        return new float[]{-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    }

    public static float[] getOriginalMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static void getMatrix(float[] matrix, int type, int imgWidth, int imgHeight, int viewWidth, int viewHeight) {
        if (imgHeight > 0 && imgWidth > 0 && viewWidth > 0 && viewHeight > 0) {
            float[] projection = new float[16];
            float[] camera = new float[16];
            if (type == 0) {
                Matrix.orthoM((float[])projection, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                Matrix.setLookAtM((float[])camera, (int)0, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                Matrix.multiplyMM((float[])matrix, (int)0, (float[])projection, (int)0, (float[])camera, (int)0);
                return;
            }
            float sWhImg = (float)imgWidth / (float)imgHeight;
            float sWhView = (float)viewWidth / (float)viewHeight;
            if (sWhImg > sWhView) {
                switch (type) {
                    case 1: {
                        Matrix.orthoM((float[])projection, (int)0, (float)(-sWhView / sWhImg), (float)(sWhView / sWhImg), (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 2: {
                        Matrix.orthoM((float[])projection, (int)0, (float)-1.0f, (float)1.0f, (float)(-sWhImg / sWhView), (float)(sWhImg / sWhView), (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 3: {
                        Matrix.orthoM((float[])projection, (int)0, (float)-1.0f, (float)1.0f, (float)(1.0f - 2.0f * sWhImg / sWhView), (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 4: {
                        Matrix.orthoM((float[])projection, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)(2.0f * sWhImg / sWhView - 1.0f), (float)1.0f, (float)3.0f);
                        break;
                    }
                }
            } else {
                switch (type) {
                    case 1: {
                        Matrix.orthoM((float[])projection, (int)0, (float)-1.0f, (float)1.0f, (float)(-sWhImg / sWhView), (float)(sWhImg / sWhView), (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 2: {
                        Matrix.orthoM((float[])projection, (int)0, (float)(-sWhView / sWhImg), (float)(sWhView / sWhImg), (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 3: {
                        Matrix.orthoM((float[])projection, (int)0, (float)-1.0f, (float)(2.0f * sWhView / sWhImg - 1.0f), (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                    case 4: {
                        Matrix.orthoM((float[])projection, (int)0, (float)(1.0f - 2.0f * sWhView / sWhImg), (float)1.0f, (float)-1.0f, (float)1.0f, (float)1.0f, (float)3.0f);
                        break;
                    }
                }
            }
            Matrix.setLookAtM((float[])camera, (int)0, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.multiplyMM((float[])matrix, (int)0, (float[])projection, (int)0, (float[])camera, (int)0);
        }
    }

    public static float[] flip(float[] m, boolean x, boolean y) {
        if (x || y) {
            Matrix.scaleM((float[])m, (int)0, (float)(x ? -1.0f : 1.0f), (float)(y ? -1.0f : 1.0f), (float)1.0f);
        }
        return m;
    }
}

