/*
 * Decompiled with CFR 0.152.
 */
package com.momo.gl.utils;

import android.content.res.Resources;
import android.opengl.GLES20;
import android.os.Build;
import java.io.InputStream;

public enum GpuUtils {


    public static String readText(Resources mRes, String path) {
        StringBuilder result = new StringBuilder();
        try {
            int ch;
            InputStream is = mRes.getAssets().open(path);
            byte[] buffer = new byte[1024];
            while (-1 != (ch = is.read(buffer))) {
                result.append(new String(buffer, 0, ch));
            }
        }
        catch (Exception e) {
            return null;
        }
        return result.toString().replaceAll("\\r\\n", "\n");
    }

    public static int loadShader(int shaderType, String source) {
        if (source == null) {
            GpuUtils.glError(1, "Shader source ==null : shaderType =" + shaderType);
            return 0;
        }
        int shader = GLES20.glCreateShader((int)shaderType);
        if (0 != shader) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                GpuUtils.glError(1, "Could not compile shader:" + shaderType);
                GpuUtils.glError(1, "GLES20 Error:" + GLES20.glGetShaderInfoLog((int)shader));
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    public static int createGLProgram(String vertexSource, String fragmentSource) {
        int vertex = GpuUtils.loadShader(35633, vertexSource);
        if (vertex == 0) {
            return 0;
        }
        int fragment = GpuUtils.loadShader(35632, fragmentSource);
        if (fragment == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)vertex);
            GLES20.glAttachShader((int)program, (int)fragment);
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                GpuUtils.glError(1, "Could not link program:" + GLES20.glGetProgramInfoLog((int)program));
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    public static int createGLProgramByAssetsFile(Resources res, String vertex, String fragment) {
        return GpuUtils.createGLProgram(GpuUtils.readText(res, vertex), GpuUtils.readText(res, fragment));
    }

    private static void glError(int code, Object index) {
    }

    public static int createTextureID(boolean isOes) {
        int target = 3553;
        if (Build.VERSION.SDK_INT >= 15) {
            target = isOes ? 36197 : 3553;
        }
        int[] texture = new int[1];
        GLES20.glGenTextures((int)1, (int[])texture, (int)0);
        GLES20.glBindTexture((int)target, (int)texture[0]);
        GLES20.glTexParameterf((int)target, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)target, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)target, (int)10243, (int)33071);
        return texture[0];
    }
}

