/*
 * Decompiled with CFR 0.152.
 */
package com.momo.gl.filter;

import android.content.res.Resources;
import android.opengl.GLES20;
import com.momo.gl.filter.IRenderer;
import com.momo.gl.utils.GpuUtils;
import com.momo.gl.utils.MatrixUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.LinkedList;

public class BaseFilter
implements IRenderer {
    public static final String BASE_VERT = "attribute vec4 aVertexCo;\nattribute vec2 aTextureCo;\n\nuniform mat4 uVertexMatrix;\nuniform mat4 uTextureMatrix;\n\nvarying vec2 vTextureCo;\n\nvoid main(){\n    gl_Position = uVertexMatrix*aVertexCo;\n    vTextureCo = (uTextureMatrix*vec4(aTextureCo,0,1)).xy;\n}";
    private float[] mVertexMatrix = MatrixUtils.getOriginalMatrix();
    private float[] mTextureMatrix = MatrixUtils.getOriginalMatrix();
    protected FloatBuffer mVertexBuffer;
    protected FloatBuffer mTextureBuffer;
    protected int mWidth;
    protected int mHeight;
    protected Resources mRes;
    private String mVertex;
    private String mFragment;
    protected int mGLProgram;
    protected int mGLVertexCo;
    protected int mGLTextureCo;
    protected int mGLVertexMatrix;
    protected int mGLTextureMatrix;
    protected int mGLTexture;
    private int mGLWidth;
    private int mGLHeight;
    private boolean isUseSize = false;
    private final LinkedList<Runnable> mTasks = new LinkedList();

    protected BaseFilter(Resources resource, String vertex, String fragment) {
        this.mRes = resource;
        this.mVertex = vertex;
        this.mFragment = fragment;
        this.initBuffer();
    }

    protected void initBuffer() {
        ByteBuffer vertex = ByteBuffer.allocateDirect(32);
        vertex.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = vertex.asFloatBuffer();
        this.mVertexBuffer.put(MatrixUtils.getOriginalVertexCo());
        this.mVertexBuffer.position(0);
        ByteBuffer texture = ByteBuffer.allocateDirect(32);
        texture.order(ByteOrder.nativeOrder());
        this.mTextureBuffer = texture.asFloatBuffer();
        this.mTextureBuffer.put(MatrixUtils.getOriginalTextureCo());
        this.mTextureBuffer.position(0);
    }

    public void setVertexCo(float[] vertexCo) {
        this.mVertexBuffer.clear();
        this.mVertexBuffer.put(vertexCo);
        this.mVertexBuffer.position(0);
    }

    public void setTextureCo(float[] textureCo) {
        this.mTextureBuffer.clear();
        this.mTextureBuffer.put(textureCo);
        this.mTextureBuffer.position(0);
    }

    public void setVertexBuffer(FloatBuffer vertexBuffer) {
        this.mVertexBuffer = vertexBuffer;
    }

    public void setTextureBuffer(FloatBuffer textureBuffer) {
        this.mTextureBuffer = textureBuffer;
    }

    public void setVertexMatrix(float[] matrix) {
        this.mVertexMatrix = matrix;
    }

    public void setTextureMatrix(float[] matrix) {
        this.mTextureMatrix = matrix;
    }

    public float[] getVertexMatrix() {
        return this.mVertexMatrix;
    }

    public float[] getTextureMatrix() {
        return this.mTextureMatrix;
    }

    protected void shaderNeedTextureSize(boolean need) {
        this.isUseSize = need;
    }

    protected void onCreate() {
        this.mGLProgram = this.mRes != null ? GpuUtils.createGLProgramByAssetsFile(this.mRes, this.mVertex, this.mFragment) : GpuUtils.createGLProgram(this.mVertex, this.mFragment);
        this.mGLVertexCo = GLES20.glGetAttribLocation((int)this.mGLProgram, (String)"aVertexCo");
        this.mGLTextureCo = GLES20.glGetAttribLocation((int)this.mGLProgram, (String)"aTextureCo");
        this.mGLVertexMatrix = GLES20.glGetUniformLocation((int)this.mGLProgram, (String)"uVertexMatrix");
        this.mGLTextureMatrix = GLES20.glGetUniformLocation((int)this.mGLProgram, (String)"uTextureMatrix");
        this.mGLTexture = GLES20.glGetUniformLocation((int)this.mGLProgram, (String)"uTexture");
        if (this.isUseSize) {
            this.mGLWidth = GLES20.glGetUniformLocation((int)this.mGLProgram, (String)"uWidth");
            this.mGLHeight = GLES20.glGetUniformLocation((int)this.mGLProgram, (String)"uHeight");
        }
    }

    protected void onSizeChanged(int width, int height) {
    }

    @Override
    public final void create() {
        if (this.mVertex != null && this.mFragment != null) {
            this.onCreate();
        }
    }

    @Override
    public void sizeChanged(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.onSizeChanged(width, height);
    }

    @Override
    public void draw(int texture) {
        this.onClear();
        this.onUseProgram();
        this.onSetExpandData();
        this.onBindTexture(texture);
        this.onDraw();
    }

    @Override
    public void destroy() {
        GLES20.glDeleteProgram((int)this.mGLProgram);
    }

    protected void onTaskExec() {
        while (!this.mTasks.isEmpty()) {
            this.mTasks.removeFirst().run();
        }
    }

    protected void onUseProgram() {
        GLES20.glUseProgram((int)this.mGLProgram);
        this.onTaskExec();
    }

    protected void onDraw() {
        GLES20.glEnableVertexAttribArray((int)this.mGLVertexCo);
        GLES20.glVertexAttribPointer((int)this.mGLVertexCo, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mVertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLTextureCo);
        GLES20.glVertexAttribPointer((int)this.mGLTextureCo, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mTextureBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.mGLVertexCo);
        GLES20.glDisableVertexAttribArray((int)this.mGLTextureCo);
    }

    protected void onClear() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16640);
    }

    public void runOnGLThread(Runnable runnable) {
        this.mTasks.addLast(runnable);
    }

    protected void onSetExpandData() {
        GLES20.glUniformMatrix4fv((int)this.mGLVertexMatrix, (int)1, (boolean)false, (float[])this.mVertexMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mGLTextureMatrix, (int)1, (boolean)false, (float[])this.mTextureMatrix, (int)0);
        if (this.isUseSize) {
            GLES20.glUniform1f((int)this.mGLWidth, (float)this.mWidth);
            GLES20.glUniform1f((int)this.mGLHeight, (float)this.mHeight);
        }
    }

    protected void onBindTexture(int textureId) {
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glUniform1i((int)this.mGLTexture, (int)0);
    }
}

