/*
 * Decompiled with CFR 0.152.
 */
package com.momo.gl;

import android.annotation.TargetApi;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;

public class EGL14Wrapper {
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private final String TAG = "EGLWrapper14";
    public EGLDisplay mEGLDisplay;
    public EGLContext mEGLContext;
    public EGLConfig eglConfig;
    public EGLSurface eglSurface;
    public int esVersion = 3;
    public boolean isAlpha = true;
    public static EGL14 mEGL = null;
    private static EGL14Wrapper mInstance;

    public EGL14Wrapper() {
    }

    public EGL14Wrapper(boolean isAlpha) {
        this.isAlpha = isAlpha;
    }

    public static EGLContext getGloableContex() {
        if (mInstance == null) {
            mInstance = new EGL14Wrapper();
            mInstance.createDummyScreenEgl();
            mInstance.makeCurrent();
        }
        return EGL14Wrapper.mInstance.mEGLContext;
    }

    public static void release() {
        if (mInstance != null) {
            mInstance.releaseEgl();
            mInstance = null;
        }
    }

    @TargetApi(value=17)
    public void createDummyScreenEgl() {
        int[] nArray;
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (EGL14.EGL_NO_DISPLAY == this.mEGLDisplay) {
            throw new RuntimeException("eglGetDisplay,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        Log.e((String)"EGL14Wrapper", (String)"eglGetDisplay");
        int[] versions = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])versions, (int)0, (int[])versions, (int)1)) {
            throw new RuntimeException("eglInitialize,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        Log.e((String)"EGL14Wrapper", (String)"eglInitialize");
        int[] configsCount = new int[1];
        EGLConfig[] configs = new EGLConfig[1];
        if (this.isAlpha) {
            int[] nArray2 = new int[15];
            nArray2[0] = 12352;
            nArray2[1] = 4;
            nArray2[2] = 12324;
            nArray2[3] = 8;
            nArray2[4] = 12323;
            nArray2[5] = 8;
            nArray2[6] = 12322;
            nArray2[7] = 8;
            nArray2[8] = 12321;
            nArray2[9] = 8;
            nArray2[10] = 12325;
            nArray2[11] = 16;
            nArray2[12] = 12326;
            nArray2[13] = 0;
            nArray = nArray2;
            nArray2[14] = 12344;
        } else {
            int[] nArray3 = new int[13];
            nArray3[0] = 12352;
            nArray3[1] = 4;
            nArray3[2] = 12324;
            nArray3[3] = 8;
            nArray3[4] = 12323;
            nArray3[5] = 8;
            nArray3[6] = 12322;
            nArray3[7] = 8;
            nArray3[8] = 12325;
            nArray3[9] = 0;
            nArray3[10] = 12326;
            nArray3[11] = 0;
            nArray = nArray3;
            nArray3[12] = 12344;
        }
        int[] configSpec = nArray;
        EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])configSpec, (int)0, (EGLConfig[])configs, (int)0, (int)1, (int[])configsCount, (int)0);
        if (configsCount[0] <= 0) {
            throw new RuntimeException("eglChooseConfig,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        Log.e((String)"EGL14Wrapper", (String)"eglChooseConfig");
        this.eglConfig = configs[0];
        int[] surfaceAttribs = new int[]{12375, 1, 12374, 1, 12344};
        int[] contextSpec = new int[]{12440, 2, 12344};
        this.mEGLContext = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.eglConfig, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])contextSpec, (int)0);
        if (EGL14.EGL_NO_CONTEXT == this.mEGLContext) {
            throw new RuntimeException("eglCreateContext,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        Log.e((String)"EGL14Wrapper", (String)"eglCreateContext");
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext, (int)12440, (int[])values, (int)0);
        this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.eglConfig, (int[])surfaceAttribs, (int)0);
        if (null == this.eglSurface || EGL14.EGL_NO_SURFACE == this.eglSurface) {
            throw new RuntimeException("eglCreateWindowSurface,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        Log.e((String)"EGL14Wrapper", (String)"eglCreatePbufferSurface");
    }

    @TargetApi(value=17)
    public void createDummyScreenEgl(EGLContext ctx) {
        int[] nArray;
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (EGL14.EGL_NO_DISPLAY == this.mEGLDisplay) {
            throw new RuntimeException("eglGetDisplay,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        int[] versions = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])versions, (int)0, (int[])versions, (int)1)) {
            throw new RuntimeException("eglInitialize,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        int[] configsCount = new int[1];
        EGLConfig[] configs = new EGLConfig[1];
        if (this.isAlpha) {
            int[] nArray2 = new int[15];
            nArray2[0] = 12352;
            nArray2[1] = 4;
            nArray2[2] = 12324;
            nArray2[3] = 8;
            nArray2[4] = 12323;
            nArray2[5] = 8;
            nArray2[6] = 12322;
            nArray2[7] = 8;
            nArray2[8] = 12321;
            nArray2[9] = 8;
            nArray2[10] = 12325;
            nArray2[11] = 16;
            nArray2[12] = 12326;
            nArray2[13] = 0;
            nArray = nArray2;
            nArray2[14] = 12344;
        } else {
            int[] nArray3 = new int[13];
            nArray3[0] = 12352;
            nArray3[1] = 4;
            nArray3[2] = 12324;
            nArray3[3] = 8;
            nArray3[4] = 12323;
            nArray3[5] = 8;
            nArray3[6] = 12322;
            nArray3[7] = 8;
            nArray3[8] = 12325;
            nArray3[9] = 0;
            nArray3[10] = 12326;
            nArray3[11] = 0;
            nArray = nArray3;
            nArray3[12] = 12344;
        }
        int[] configSpec = nArray;
        EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])configSpec, (int)0, (EGLConfig[])configs, (int)0, (int)1, (int[])configsCount, (int)0);
        if (configsCount[0] <= 0) {
            throw new RuntimeException("eglChooseConfig,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        this.eglConfig = configs[0];
        int[] surfaceAttribs = new int[]{12375, 1, 12374, 1, 12344};
        int[] contextSpec = new int[]{12440, 2, 12344};
        this.mEGLContext = ctx != null ? EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.eglConfig, (EGLContext)ctx, (int[])contextSpec, (int)0) : EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.eglConfig, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])contextSpec, (int)0);
        if (EGL14.EGL_NO_CONTEXT == this.mEGLContext) {
            throw new RuntimeException("eglCreateContext,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext, (int)12440, (int[])values, (int)0);
        this.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.eglConfig, (int[])surfaceAttribs, (int)0);
        if (null == this.eglSurface || EGL14.EGL_NO_SURFACE == this.eglSurface) {
            throw new RuntimeException("eglCreateWindowSurface,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
    }

    @TargetApi(value=17)
    public void createMediaCodecEgl(EGLContext sharedContext, Object mediaInputSurface) {
        int[] nArray;
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (EGL14.EGL_NO_DISPLAY == this.mEGLDisplay) {
            throw new RuntimeException("eglGetDisplay,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        int[] versions = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])versions, (int)0, (int[])versions, (int)1)) {
            throw new RuntimeException("eglInitialize,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        int[] configsCount = new int[1];
        EGLConfig[] configs = new EGLConfig[1];
        if (this.isAlpha) {
            int[] nArray2 = new int[15];
            nArray2[0] = 12352;
            nArray2[1] = 4;
            nArray2[2] = 12324;
            nArray2[3] = 8;
            nArray2[4] = 12323;
            nArray2[5] = 8;
            nArray2[6] = 12322;
            nArray2[7] = 8;
            nArray2[8] = 12610;
            nArray2[9] = 1;
            nArray2[10] = 12325;
            nArray2[11] = 16;
            nArray2[12] = 12326;
            nArray2[13] = 0;
            nArray = nArray2;
            nArray2[14] = 12344;
        } else {
            int[] nArray3 = new int[15];
            nArray3[0] = 12352;
            nArray3[1] = 4;
            nArray3[2] = 12324;
            nArray3[3] = 8;
            nArray3[4] = 12323;
            nArray3[5] = 8;
            nArray3[6] = 12322;
            nArray3[7] = 8;
            nArray3[8] = 12610;
            nArray3[9] = 1;
            nArray3[10] = 12325;
            nArray3[11] = 0;
            nArray3[12] = 12326;
            nArray3[13] = 0;
            nArray = nArray3;
            nArray3[14] = 12344;
        }
        int[] configSpec = nArray;
        EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])configSpec, (int)0, (EGLConfig[])configs, (int)0, (int)1, (int[])configsCount, (int)0);
        if (configsCount[0] <= 0) {
            throw new RuntimeException("eglChooseConfig,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        this.eglConfig = configs[0];
        int[] surfaceAttribs = new int[]{12344};
        int[] contextSpec = new int[]{12440, 2, 12344};
        this.mEGLContext = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.eglConfig, (EGLContext)sharedContext, (int[])contextSpec, (int)0);
        if (EGL14.EGL_NO_CONTEXT == this.mEGLContext) {
            throw new RuntimeException("eglCreateContext,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext, (int)12440, (int[])values, (int)0);
        this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.eglConfig, (Object)mediaInputSurface, (int[])surfaceAttribs, (int)0);
        if (null == this.eglSurface || EGL14.EGL_NO_SURFACE == this.eglSurface) {
            throw new RuntimeException("eglCreateWindowSurface,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
    }

    @TargetApi(value=17)
    public void createScreenEgl(EGLContext sharedContext, Object screenSurface) {
        int[] nArray;
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (EGL14.EGL_NO_DISPLAY == this.mEGLDisplay) {
            throw new RuntimeException("eglGetDisplay,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        int[] versions = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])versions, (int)0, (int[])versions, (int)1)) {
            throw new RuntimeException("eglInitialize,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        int[] configsCount = new int[1];
        EGLConfig[] configs = new EGLConfig[1];
        if (this.isAlpha) {
            int[] nArray2 = new int[15];
            nArray2[0] = 12352;
            nArray2[1] = 4;
            nArray2[2] = 12324;
            nArray2[3] = 8;
            nArray2[4] = 12323;
            nArray2[5] = 8;
            nArray2[6] = 12322;
            nArray2[7] = 8;
            nArray2[8] = 12321;
            nArray2[9] = 8;
            nArray2[10] = 12325;
            nArray2[11] = 16;
            nArray2[12] = 12326;
            nArray2[13] = 0;
            nArray = nArray2;
            nArray2[14] = 12344;
        } else {
            int[] nArray3 = new int[13];
            nArray3[0] = 12352;
            nArray3[1] = 4;
            nArray3[2] = 12324;
            nArray3[3] = 8;
            nArray3[4] = 12323;
            nArray3[5] = 8;
            nArray3[6] = 12322;
            nArray3[7] = 8;
            nArray3[8] = 12325;
            nArray3[9] = 0;
            nArray3[10] = 12326;
            nArray3[11] = 0;
            nArray = nArray3;
            nArray3[12] = 12344;
        }
        int[] configSpec = nArray;
        EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])configSpec, (int)0, (EGLConfig[])configs, (int)0, (int)1, (int[])configsCount, (int)0);
        if (configsCount[0] <= 0) {
            throw new RuntimeException("eglChooseConfig,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        this.eglConfig = configs[0];
        int[] surfaceAttribs = new int[]{12344};
        int[] contextSpec = new int[]{12440, 2, 12344};
        this.mEGLContext = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.eglConfig, (EGLContext)sharedContext, (int[])contextSpec, (int)0);
        if (EGL14.EGL_NO_CONTEXT == this.mEGLContext) {
            throw new RuntimeException("eglCreateContext,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext, (int)12440, (int[])values, (int)0);
        this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.eglConfig, (Object)screenSurface, (int[])surfaceAttribs, (int)0);
        if (null == this.eglSurface || EGL14.EGL_NO_SURFACE == this.eglSurface) {
            throw new RuntimeException("eglCreateWindowSurface,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
        }
    }

    @TargetApi(value=17)
    public synchronized void releaseEgl() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY && this.eglSurface != EGL14.EGL_NO_SURFACE && this.mEGLContext != EGL14.EGL_NO_CONTEXT) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.mEGLContext)) {
                // empty if block
            }
            EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.eglSurface);
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
            this.eglSurface = EGL14.EGL_NO_SURFACE;
            this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
            this.mEGLContext = EGL14.EGL_NO_CONTEXT;
            this.eglConfig = null;
        }
    }

    @TargetApi(value=17)
    public boolean makeCurrent(EGLSurface readSurface) {
        if (this.mEGLDisplay != null && this.eglSurface != null && this.mEGLContext != null) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.eglSurface, (EGLSurface)readSurface, (EGLContext)this.mEGLContext)) {
                throw new RuntimeException("eglMakeCurrent,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
            }
            return true;
        }
        return false;
    }

    @TargetApi(value=17)
    public boolean makeCurrent() {
        if (this.mEGLDisplay != null && this.eglSurface != null && this.mEGLContext != null) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.mEGLContext)) {
                throw new RuntimeException("eglMakeCurrent,failed:" + GLUtils.getEGLErrorString((int)EGL14.eglGetError()));
            }
            return true;
        }
        return false;
    }

    @TargetApi(value=17)
    public void swapBuffer() {
        if (this.mEGLDisplay != null && this.eglSurface != null && !EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.eglSurface)) {
            throw new RuntimeException("eglSwapBuffers,failed!");
        }
    }

    public static int createOneExternalTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        return textures[0];
    }

    public static void releaseTexture(int texutreId) {
        int[] textureArray = new int[]{texutreId};
        GLES20.glDeleteTextures((int)1, (int[])textureArray, (int)0);
    }

    @TargetApi(value=17)
    public int getHeight() {
        int[] value = new int[1];
        if (this.mEGLDisplay != null && this.eglSurface != null && this.mEGLContext != null) {
            EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.eglSurface, (int)12375, (int[])value, (int)0);
        }
        return value[0];
    }

    @TargetApi(value=17)
    public int getWidth() {
        int[] value = new int[1];
        if (this.mEGLDisplay != null && this.eglSurface != null && this.mEGLContext != null) {
            EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.eglSurface, (int)12374, (int[])value, (int)0);
        }
        return value[0];
    }
}

