/*
 * Decompiled with CFR 0.152.
 */
package com.momo.egl;

import android.annotation.TargetApi;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.util.Log;
import com.momo.egl.EGLConfigAttrs;
import com.momo.egl.EGLContextAttrs;

@TargetApi(value=17)
public class EglHelper {
    private boolean isDebug = false;
    private EGLDisplay mEGLDisplay;
    private EGLConfig mEGLConfig;
    private EGLContext mEGLContext;
    private EGLSurface mEGLSurface;

    public EglHelper(int display) {
        this.changeDisplay(display);
    }

    public EglHelper() {
        this(0);
    }

    private void changeDisplay(int display) {
        this.mEGLDisplay = EGL14.eglGetDisplay((int)display);
        int[] versions = new int[2];
        EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])versions, (int)0, (int[])versions, (int)1);
        this.log(EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)12371));
        this.log(EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)12372));
        this.log(EGL14.eglQueryString((EGLDisplay)this.mEGLDisplay, (int)12373));
    }

    public EGLConfig getConfig(EGLConfigAttrs attrs) {
        EGLConfig[] configs = new EGLConfig[1];
        int[] configNum = new int[1];
        EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])attrs.build(), (int)0, (EGLConfig[])configs, (int)0, (int)1, (int[])configNum, (int)0);
        if (configNum[0] > 0) {
            if (attrs.isDefault()) {
                this.mEGLConfig = configs[0];
            }
            return configs[0];
        }
        return null;
    }

    public EGLConfig getDefaultConfig() {
        return this.mEGLConfig;
    }

    public EGLSurface getDefaultSurface() {
        return this.mEGLSurface;
    }

    public EGLContext getDefaultContext() {
        return this.mEGLContext;
    }

    public EGLContext createContext(EGLConfig config, EGLContext share, EGLContextAttrs attrs) {
        EGLContext context = EGL14.eglCreateContext((EGLDisplay)this.mEGLDisplay, (EGLConfig)config, (EGLContext)share, (int[])attrs.build(), (int)0);
        if (attrs.isDefault()) {
            this.mEGLContext = context;
        }
        return context;
    }

    public EGLSurface createWindowSurface(EGLConfig config, Object surface) {
        return EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)config, (Object)surface, (int[])new int[]{12344}, (int)0);
    }

    public EGLSurface createWindowSurface(Object surface) {
        return EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)surface, (int[])new int[]{12344}, (int)0);
    }

    public EGLSurface createPBufferSurface(EGLConfig config, int width, int height) {
        return EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)config, (int[])new int[]{12375, width, 12374, height, 12344}, (int)0);
    }

    public boolean createGLESWithSurface(EGLConfigAttrs attrs, EGLContextAttrs ctxAttrs, Object surface) {
        EGLConfig config = this.getConfig(attrs.surfaceType(4).makeDefault(true));
        if (config == null) {
            this.log("getConfig failed : " + EGL14.eglGetError());
            return false;
        }
        this.mEGLContext = this.createContext(config, EGL14.EGL_NO_CONTEXT, ctxAttrs.makeDefault(true));
        if (this.mEGLContext == EGL14.EGL_NO_CONTEXT) {
            this.log("createContext failed : " + EGL14.eglGetError());
            return false;
        }
        this.mEGLSurface = this.createWindowSurface(surface);
        if (this.mEGLSurface == EGL14.EGL_NO_SURFACE) {
            this.log("createWindowSurface failed : " + EGL14.eglGetError());
            return false;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (EGLSurface)this.mEGLSurface, (EGLContext)this.mEGLContext)) {
            this.log("eglMakeCurrent failed : " + EGL14.eglGetError());
            return false;
        }
        return true;
    }

    public boolean makeCurrent(EGLSurface draw, EGLSurface read, EGLContext context) {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)draw, (EGLSurface)read, (EGLContext)context)) {
            this.log("eglMakeCurrent failed : " + EGL14.eglGetError());
        }
        return true;
    }

    public boolean makeCurrent(EGLSurface surface, EGLContext context) {
        return this.makeCurrent(surface, surface, context);
    }

    public boolean makeCurrent(EGLSurface surface) {
        return this.makeCurrent(surface, this.mEGLContext);
    }

    public boolean makeCurrent() {
        return this.makeCurrent(this.mEGLSurface, this.mEGLContext);
    }

    @TargetApi(value=18)
    public void setPresentationTime(EGLSurface surface, long time) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)surface, (long)time);
    }

    public EGLSurface createGLESWithPBuffer(EGLConfigAttrs attrs, EGLContextAttrs ctxAttrs, int width, int height) {
        EGLConfig config = this.getConfig(attrs.surfaceType(1));
        if (config == null) {
            this.log("getConfig failed : " + EGL14.eglGetError());
            return null;
        }
        EGLContext eglContext = this.createContext(config, EGL14.EGL_NO_CONTEXT, ctxAttrs);
        if (eglContext == EGL14.EGL_NO_CONTEXT) {
            this.log("createContext failed : " + EGL14.eglGetError());
            return null;
        }
        EGLSurface eglSurface = this.createPBufferSurface(config, width, height);
        if (eglSurface == EGL14.EGL_NO_SURFACE) {
            this.log("createWindowSurface failed : " + EGL14.eglGetError());
            return null;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eglSurface, (EGLSurface)eglSurface, (EGLContext)eglContext)) {
            this.log("eglMakeCurrent failed : " + EGL14.eglGetError());
            return null;
        }
        return eglSurface;
    }

    public void swapBuffers(EGLSurface surface) {
        if (surface != null) {
            try {
                EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)surface);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean destroyGLES(EGLSurface surface, EGLContext context) {
        EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
        if (surface != null) {
            EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)surface);
        }
        if (context != null) {
            EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)context);
        }
        EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
        this.log("gl destroy gles");
        return true;
    }

    public void destroySurface(EGLSurface surface) {
        EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)surface);
    }

    public EGLDisplay getDisplay() {
        return this.mEGLDisplay;
    }

    private void log(String log) {
        if (this.isDebug) {
            Log.e((String)"EGLHelper", (String)log);
        }
    }
}

