/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.FaceRigDataInfo;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.util.FacerigHelper;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.bean.XEFaceInfo;
import com.momo.xeengine.xnative.XEFace;
import com.momocv.SingleFaceInfo;
import com.momocv.facerig.FaceRigInfo;
import java.util.ArrayList;

public class XEFaceInfoHelper {
    private static final int LEFT_EYE_OPEN = 4;
    private static final int LEFT_EYE_CLOSING = 8;
    private static final int LEFT_EYE_BLINK = 16;
    private static final int RIGHT_EYE_OPEN = 32;
    private static final int RIGHT_EYE_CLOSING = 64;
    private static final int RIGHT_EYE_BLINK = 128;
    private static final int EYE_BLINK = 256;
    private static final int SMILE = 512;
    private static final int DUCK_FACE = 1024;
    private static final int NOD = 2048;
    private static final int MOUSE_STATE_OPEN = 1;
    private static final int MOUSE_STATE_CLOSE = 2;
    private static int INDEX_FACE_LEFT = 0;
    private static int INDEX_FACE_RIGHT = 16;
    private static int INDEX_MOUSE_UP = 62;
    private static int INDEX_MOUSE_DOWN = 66;
    private static int mouseOpenState = 2;
    private static final int POINTS_LENGTH = 68;
    private static final int FACE_STATE_OPEN = 0;
    private static final int FACE_STATE_CLOSE = 1;
    private int smileState = 1;
    private int duckFaceState = 1;
    private int leftEyeOpenState = 0;
    private int leftEyeBlinkState = 1;
    private int leftEyeBlinkCount = 0;
    private int rightEyeOpenState = 0;
    private int rightEyeBlinkState = 0;
    private int rightEyeBlinkCount = 0;
    private float leftEyeOpenAmount = 1.0f;
    private float rightEyeOpenAmount = 1.0f;

    public static void setFaceInfo(MMCVInfo mMCVInfo) {
        Object object;
        float[] fArray;
        Object object2;
        FaceAttributeInfo faceAttributeInfo;
        float[] fArray2;
        if (mMCVInfo == null || !XE3DEngine.getInstance().isRunning()) {
            return;
        }
        ArrayList<FaceAttributeInfo> arrayList = new ArrayList<FaceAttributeInfo>();
        FaceRigDataInfo faceRigDataInfo = mMCVInfo.getSingleFaceRigInfo();
        boolean bl = false;
        boolean bl2 = FacerigHelper.getUseAnimojiFaceRig();
        if (faceRigDataInfo != null && (fArray2 = bl2 ? faceRigDataInfo.getFacerigV2Scores() : faceRigDataInfo.getFacerigScores()) != null && fArray2.length > 0) {
            SingleFaceInfo[] singleFaceInfoArray = null;
            if (bl2) {
                singleFaceInfoArray = mMCVInfo.singleFaceRigInfo.videoInfo.facesinfo_;
            } else {
                faceAttributeInfo = faceRigDataInfo.info;
                if (faceAttributeInfo != null) {
                    singleFaceInfoArray = ((FaceRigInfo)faceAttributeInfo).facesinfo_;
                }
            }
            if (singleFaceInfoArray != null && singleFaceInfoArray.length > 0) {
                faceAttributeInfo = new XEFaceInfo();
                ((XEFaceInfo)faceAttributeInfo).trackId = singleFaceInfoArray[0].tracking_id_;
                object2 = singleFaceInfoArray[0].euler_angles_;
                if (object2 != null && ((XEFaceInfo)object2).length >= 3) {
                    ((XEFaceInfo)faceAttributeInfo).pitch = (float)object2[0];
                    ((XEFaceInfo)faceAttributeInfo).yaw = (float)object2[1];
                    ((XEFaceInfo)faceAttributeInfo).roll = (float)object2[2];
                }
                ((XEFaceInfo)faceAttributeInfo).landmarks68 = singleFaceInfoArray[0].landmarks_68_;
                ((XEFaceInfo)faceAttributeInfo).expression = 0;
                fArray = new float[]{singleFaceInfoArray[0].face_rect_[0], singleFaceInfoArray[0].face_rect_[1], singleFaceInfoArray[0].face_rect_[2] - singleFaceInfoArray[0].face_rect_[0], singleFaceInfoArray[0].face_rect_[3] - singleFaceInfoArray[0].face_rect_[1]};
                ((XEFaceInfo)faceAttributeInfo).faceBounds = fArray;
                ((XEFaceInfo)faceAttributeInfo).cameraMatrix = singleFaceInfoArray[0].camera_matrix_;
                ((XEFaceInfo)faceAttributeInfo).rotationMatrix = singleFaceInfoArray[0].rotation_matrix_;
                ((XEFaceInfo)faceAttributeInfo).rotationVector = singleFaceInfoArray[0].rotation_vector_;
                ((XEFaceInfo)faceAttributeInfo).translationVector = singleFaceInfoArray[0].translation_vector_;
                ((XEFaceInfo)faceAttributeInfo).projectionMatrix = singleFaceInfoArray[0].projection_matrix_;
                ((XEFaceInfo)faceAttributeInfo).modelViewMatrix = singleFaceInfoArray[0].modelview_matrix_;
                ((XEFaceInfo)faceAttributeInfo).landmarks96 = singleFaceInfoArray[0].landmarks_96_;
                if (bl2) {
                    ((XEFaceInfo)faceAttributeInfo).facerigStates = mMCVInfo.getSingleFaceRigInfo().getFacerigV2Scores();
                } else {
                    object = mMCVInfo.getSingleFaceRigInfo();
                    if (object != null) {
                        ((XEFaceInfo)faceAttributeInfo).facerigStates = mMCVInfo.getSingleFaceRigInfo().getFacerigScores();
                    }
                }
                ((XEFaceInfo)faceAttributeInfo).meType = ((XEFaceInfo)faceAttributeInfo).facerigStates == null ? 0 : 1;
                arrayList.add(faceAttributeInfo);
            }
            bl = true;
            XEFace.setFaceInfo(arrayList);
        }
        if (bl) {
            return;
        }
        int n = mMCVInfo.getMaxFaceCnt();
        if (n <= 0) {
            if (XE3DEngine.getInstance().isRunning()) {
                XEFace.setFaceInfo(null);
            }
            return;
        }
        for (int i = 0; i < n; ++i) {
            faceAttributeInfo = mMCVInfo.getFaceAttributeInfo(i);
            if (faceAttributeInfo == null) continue;
            object2 = new XEFaceInfo();
            object2.expression = faceAttributeInfo.getExpression();
            object2.landmarks68 = faceAttributeInfo.getWarpedLandmarks68() == null ? faceAttributeInfo.getLandmarks68() : faceAttributeInfo.getWarpedLandmarks68();
            object2.landmarks96 = faceAttributeInfo.getWarpedLandmarks96() == null ? faceAttributeInfo.getLandmarks96() : faceAttributeInfo.getWarpedLandmarks96();
            object2.trackId = faceAttributeInfo.getTrackingId();
            fArray = faceAttributeInfo.getEulerAngles();
            if (fArray != null && fArray.length >= 3) {
                object2.pitch = fArray[0];
                object2.yaw = fArray[1];
                object2.roll = fArray[2];
            }
            object2.expression = 0;
            object = new float[]{faceAttributeInfo.getFaceRect()[0], faceAttributeInfo.getFaceRect()[1], faceAttributeInfo.getFaceRect()[2] - faceAttributeInfo.getFaceRect()[0], faceAttributeInfo.getFaceRect()[3] - faceAttributeInfo.getFaceRect()[1]};
            object2.faceBounds = object;
            object2.cameraMatrix = faceAttributeInfo.getCameraMatrix();
            object2.rotationMatrix = faceAttributeInfo.getRotationMatrix();
            object2.rotationVector = faceAttributeInfo.getRotationVector();
            object2.translationVector = faceAttributeInfo.getTranslationVector();
            object2.projectionMatrix = faceAttributeInfo.getProjectionMatrixOpengl();
            object2.modelViewMatrix = faceAttributeInfo.getModelviewMatrix();
            FaceRigDataInfo faceRigDataInfo2 = mMCVInfo.getSingleFaceRigInfo();
            if (faceRigDataInfo2 != null) {
                object2.facerigStates = mMCVInfo.getSingleFaceRigInfo().getFacerigScores();
            }
            object2.meType = object2.facerigStates == null ? 0 : 1;
            arrayList.add((FaceAttributeInfo)object2);
        }
        XEFace.setFaceInfo(arrayList);
    }

    private void adjustState(MMCVInfo mMCVInfo, int n) {
        FaceAttributeInfo faceAttributeInfo;
        int n2 = 0;
        if (mMCVInfo == null) {
            return;
        }
        if (n >= mMCVInfo.getMaxFaceCnt()) {
            n = 0;
        }
        if ((faceAttributeInfo = mMCVInfo.getFaceAttributeInfo(n)) != null) {
            n2 |= XEFaceInfoHelper.updateMouseState(faceAttributeInfo.getLandmarks68());
            this.smileState = 2;
            this.duckFaceState = 2;
            if (faceAttributeInfo.getExpression() == 1) {
                this.duckFaceState = 1;
                n2 |= 0x400;
            } else if (faceAttributeInfo.getExpression() == 2) {
                this.smileState = 1;
                n2 |= 0x200;
            }
            n2 |= this.updateEyeState(faceAttributeInfo);
            if (this.rightEyeOpenState == 0 && this.leftEyeOpenState == 1) {
                ++this.leftEyeBlinkCount;
                this.leftEyeBlinkState = this.leftEyeBlinkCount > 1 ? 0 : 1;
            } else {
                this.leftEyeBlinkCount = 0;
                this.leftEyeBlinkState = 1;
            }
            if (this.rightEyeOpenState == 1 && this.leftEyeOpenState == 0) {
                ++this.rightEyeBlinkCount;
                this.rightEyeBlinkState = this.rightEyeBlinkCount > 1 ? 0 : 1;
            } else {
                this.rightEyeBlinkCount = 0;
                this.rightEyeBlinkState = 1;
            }
            boolean bl = false;
            if (this.leftEyeBlinkState == 0) {
                n2 |= 0x10;
                bl = true;
            }
            if (this.rightEyeBlinkState == 0) {
                n2 |= 0x80;
                bl = true;
            }
            if (bl) {
                n2 |= 0x100;
            }
        }
    }

    private int updateEyeState(FaceAttributeInfo faceAttributeInfo) {
        float f = faceAttributeInfo.getLeftEyeCloseProb();
        this.rightEyeOpenAmount = faceAttributeInfo.getRightEyeCloseProb();
        this.leftEyeOpenState = (double)f >= 0.7 ? 1 : 0;
        this.rightEyeOpenState = (double)this.rightEyeOpenAmount >= 0.7 ? 1 : 0;
        int n = 0;
        n = this.leftEyeOpenState == 0 ? (n |= 4) : (n |= 8);
        n = this.rightEyeOpenState == 0 ? (n |= 0x20) : (n |= 0x40);
        return n;
    }

    private static int updateMouseState(float[] fArray) {
        int n = 2;
        if (fArray == null) {
            return n;
        }
        float f = fArray[INDEX_FACE_LEFT];
        float f2 = fArray[INDEX_FACE_LEFT + 68];
        float f3 = fArray[INDEX_FACE_RIGHT];
        float f4 = fArray[INDEX_FACE_RIGHT + 68];
        float f5 = fArray[INDEX_MOUSE_DOWN];
        float f6 = fArray[INDEX_MOUSE_DOWN + 68];
        float f7 = fArray[INDEX_MOUSE_UP];
        float f8 = fArray[INDEX_MOUSE_UP + 68];
        float f9 = (float)Math.hypot(f - f3, f2 - f4);
        float f10 = (float)Math.hypot(f7 - f5, f8 - f6);
        n = f10 > f9 * 1.0f / 10.0f ? 1 : 2;
        return n;
    }
}

