/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.content.res.Resources;
import android.opengl.GLES20;
import com.mm.mdlog.MDLog;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class ShaderUtil {
    private static int loadShader(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string);
            GLES20.glCompileShader((int)n2);
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 0) {
                MDLog.e((String)"mediaRender", (String)("Could not compile shader " + n + ":"));
                MDLog.e((String)"mediaRender", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                n2 = 0;
            }
        }
        return n2;
    }

    public static int createProgram(String string, String string2) {
        int n = ShaderUtil.loadShader(35633, string);
        if (n == 0) {
            return 0;
        }
        int n2 = ShaderUtil.loadShader(35632, string2);
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        if (n3 != 0) {
            GLES20.glAttachShader((int)n3, (int)n);
            ShaderUtil.checkGlError("glAttachShader");
            GLES20.glAttachShader((int)n3, (int)n2);
            ShaderUtil.checkGlError("glAttachShader");
            GLES20.glLinkProgram((int)n3);
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
            if (nArray[0] != 1) {
                MDLog.e((String)"mediaRender", (String)"Could not link program: ");
                MDLog.e((String)"mediaRender", (String)GLES20.glGetProgramInfoLog((int)n3));
                GLES20.glDeleteProgram((int)n3);
                n3 = 0;
            }
        }
        return n3;
    }

    public static void checkGlError(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            MDLog.e((String)"mediaRender", (String)(string + ": glError " + n));
            throw new RuntimeException(string + ": glError " + n);
        }
    }

    public static String loadFromAssetsFile(String string, Resources resources) {
        String string2 = null;
        try {
            InputStream inputStream = resources.getAssets().open(string);
            int n = 0;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            inputStream.close();
            string2 = new String(byArray, "UTF-8");
            string2 = string2.replaceAll("\\r\\n", "\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }
}

