/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.MMParamsInfo;
import com.core.glcore.util.ErrorDotStatistics;
import com.mm.mdlog.MDLog;
import com.momocv.segmentation.Segmentation;
import com.momocv.segmentation.SegmentationInfo;
import com.momocv.segmentation.SegmentationParams;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class SegmentHelper {
    private static Segmentation segmentation;
    private static byte[] modelBuff;
    private static String modelPath;
    private static int width;
    private static int height;
    private static boolean is_front_camera;
    private static int rotate_degree;
    private static int restore_degree;
    private static SegmentationInfo info;
    private static AtomicInteger counter;
    private static int segmentCount;

    public static int getWidth() {
        return width;
    }

    public static void setWidth(int n) {
        width = n;
    }

    public static int getHeight() {
        return height;
    }

    public static void setHeight(int n) {
        height = n;
    }

    public static boolean isFrontCamera() {
        return is_front_camera;
    }

    public static void setIsFrontCamera(boolean bl) {
        is_front_camera = bl;
    }

    public static int getRotateDegree() {
        return rotate_degree;
    }

    public static void setRotateDegree(int n) {
        rotate_degree = n;
    }

    public static int getRestoreDegree() {
        return restore_degree;
    }

    public static void setRestoreDegree(int n) {
        restore_degree = n;
    }

    public static String getModelPath() {
        return modelPath;
    }

    public static void setModelPath(String string) {
        modelPath = string;
    }

    public static void setSegmentCount(int n) {
        segmentCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] process(MMFrameInfo mMFrameInfo, MMParamsInfo mMParamsInfo) {
        if (modelPath == null) {
            if (SegmentHelper.info.mask_ == null) {
                SegmentHelper.info.mask_ = new byte[mMFrameInfo.getWidth() * mMFrameInfo.getHeight()];
                Arrays.fill(SegmentHelper.info.mask_, (byte)-1);
            }
            return SegmentHelper.info.mask_;
        }
        if (counter.getAndDecrement() > 0 && SegmentHelper.info.mask_ != null) {
            return SegmentHelper.info.mask_;
        }
        if (modelBuff == null) {
            FileInputStream fileInputStream = null;
            try {
                boolean bl;
                fileInputStream = new FileInputStream(modelPath);
                int n = fileInputStream.available();
                modelBuff = new byte[n];
                fileInputStream.read(modelBuff);
                if (segmentation == null) {
                    segmentation = new Segmentation();
                }
                if (!(bl = segmentation.LoadModel(modelBuff))) {
                    MDLog.e((String)"ImageProcess", (String)"The Segment mode lode failed !!!");
                }
            }
            catch (Throwable throwable) {
                MDLog.printErrStackTrace((String)"ImageProcess", (Throwable)throwable);
                ErrorDotStatistics.getInstance().addErrInfo("[101013]The Segment mode lode failed !!!" + throwable.toString());
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    MDLog.e((String)"ImageProcess", (String)("The Segment mode lode failed !!!" + exception.toString()));
                }
            }
        }
        if (modelBuff != null) {
            if (segmentation == null) {
                segmentation = new Segmentation();
            }
            if (SegmentHelper.info.mask_ == null) {
                SegmentHelper.info.mask_ = new byte[mMFrameInfo.getWidth() * mMFrameInfo.getHeight()];
                Arrays.fill(SegmentHelper.info.mask_, (byte)-1);
            }
            counter.set(segmentCount);
            segmentation.ProcessFrame(mMFrameInfo.getFrame(), (SegmentationParams)mMParamsInfo.getParams(), info);
        }
        counter.decrementAndGet();
        return SegmentHelper.info.mask_;
    }

    public static void release() {
        if (segmentation != null) {
            segmentation.Release();
            segmentation = null;
        }
        if (SegmentHelper.info.mask_ != null) {
            SegmentHelper.info.mask_ = null;
        }
        if (modelBuff != null) {
            modelBuff = null;
        }
        if (counter != null) {
            counter.set(0);
        }
        segmentCount = 0;
        MDLog.i((String)"ImageProcess", (String)"SegmentHelper release !!!");
    }

    static {
        width = 0;
        height = 0;
        is_front_camera = true;
        rotate_degree = 0;
        restore_degree = 90;
        info = new SegmentationInfo();
        counter = new AtomicInteger(0);
        segmentCount = 0;
    }
}

