/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.content.Context;
import android.database.Cursor;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import java.io.File;
import java.io.FileInputStream;

public class MediaPlayerDataSourceHelper {
    public static void setMediaPlayerDataSource(Context context, MediaPlayer mediaPlayer, String string) {
        if (string.startsWith("content://")) {
            try {
                Uri uri = Uri.parse((String)string);
                string = MediaPlayerDataSourceHelper.getRingtonePathFromContentUri(context, uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (Build.VERSION.SDK_INT < 11) {
                try {
                    MediaPlayerDataSourceHelper.setMediaPlayerDataSourcePreHoneyComb(context, mediaPlayer, string);
                }
                catch (Exception exception) {
                    MediaPlayerDataSourceHelper.setMediaPlayerDataSourcePostHoneyComb(context, mediaPlayer, string);
                }
            } else {
                MediaPlayerDataSourceHelper.setMediaPlayerDataSourcePostHoneyComb(context, mediaPlayer, string);
            }
        }
        catch (Exception exception) {
            try {
                MediaPlayerDataSourceHelper.setMediaPlayerDataSourceUsingFileDescriptor(context, mediaPlayer, string);
            }
            catch (Exception exception2) {
                String string2 = MediaPlayerDataSourceHelper.getRingtoneUriFromPath(context, string);
                mediaPlayer.reset();
                mediaPlayer.setDataSource(string2);
            }
        }
    }

    private static void setMediaPlayerDataSourcePreHoneyComb(Context context, MediaPlayer mediaPlayer, String string) {
        mediaPlayer.reset();
        mediaPlayer.setDataSource(string);
    }

    private static void setMediaPlayerDataSourcePostHoneyComb(Context context, MediaPlayer mediaPlayer, String string) {
        mediaPlayer.reset();
        mediaPlayer.setDataSource(context, Uri.parse((String)Uri.encode((String)string)));
    }

    private static void setMediaPlayerDataSourceUsingFileDescriptor(Context context, MediaPlayer mediaPlayer, String string) {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        mediaPlayer.reset();
        mediaPlayer.setDataSource(fileInputStream.getFD());
        fileInputStream.close();
    }

    private static String getRingtoneUriFromPath(Context context, String string) {
        Uri uri = MediaStore.Audio.Media.getContentUriForPath((String)string);
        Cursor cursor = context.getContentResolver().query(uri, null, "_data='" + string + "'", null, null);
        cursor.moveToFirst();
        long l = cursor.getLong(cursor.getColumnIndex("_id"));
        cursor.close();
        if (!uri.toString().endsWith(String.valueOf(l))) {
            return uri + "/" + l;
        }
        return uri.toString();
    }

    public static String getRingtonePathFromContentUri(Context context, Uri uri) {
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = context.getContentResolver().query(uri, stringArray, null, null, null);
        cursor.moveToFirst();
        String string = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
        cursor.close();
        return string;
    }
}

