/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.os.Process;
import android.text.TextUtils;
import com.core.glcore.util.Log4Cam;
import com.mm.mdlog.MDLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.json.JSONArray;
import org.json.JSONException;

public class MDLogSetter {
    private static final String MDLOG_SP_NAME = "__immomo__momo__mdlog__";
    private static final String MDLOG_SP_KEY_LEVEL = "mdlog_sp_key_level";
    private static final String MDLOG_SP_KEY_CONSOLE_OPEN = "mdlog_sp_logcat_state";
    private static final String MDLOG_SP_KEY_FILTER_TAG = "mdlog_sp_key_filter_tag";
    private static Context context;

    public static void init(Context context) {
        int n;
        MDLogSetter.context = context.getApplicationContext();
        String string = MDLogSetter.getProcessNameInternal(context);
        String string2 = "";
        if (TextUtils.equals((CharSequence)string, (CharSequence)context.getPackageName())) {
            string2 = "main";
        } else if (string != null && string.contains(":") && (n = string.indexOf(":")) > 0) {
            string2 = string.substring(string.indexOf(":") + 1);
        }
        MDLog.openFileWrite(null, (String)MDLogSetter.getLogPath());
        MDLog.setLevel((int)7);
    }

    public static String getLogPath() {
        return MDLogSetter.getMDLogPath().getAbsolutePath();
    }

    public static void saveLogLevel(int n) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(MDLOG_SP_NAME, 4);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(MDLOG_SP_KEY_LEVEL, n);
        editor.commit();
    }

    public static int getLogLevel(int n) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(MDLOG_SP_NAME, 4);
        return sharedPreferences.getInt(MDLOG_SP_KEY_LEVEL, n);
    }

    public static void saveLogFilterTags(List<String> list) {
        if (list != null) {
            JSONArray jSONArray = new JSONArray(list);
            SharedPreferences sharedPreferences = context.getSharedPreferences(MDLOG_SP_NAME, 4);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(MDLOG_SP_KEY_FILTER_TAG, jSONArray.toString());
            editor.commit();
        }
    }

    public static List<String> getLogFilterTags() {
        SharedPreferences sharedPreferences = context.getSharedPreferences(MDLOG_SP_NAME, 4);
        String string = sharedPreferences.getString(MDLOG_SP_KEY_FILTER_TAG, null);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                JSONArray jSONArray = new JSONArray(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = jSONArray.length();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(jSONArray.getString(i));
                }
                return arrayList;
            }
            catch (JSONException jSONException) {
                Log4Cam.printStackTrace(jSONException);
            }
        }
        return null;
    }

    public static void saveLogcatState(int n) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(MDLOG_SP_NAME, 4);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(MDLOG_SP_KEY_CONSOLE_OPEN, n);
        editor.commit();
    }

    public static int getLogcatState(int n) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(MDLOG_SP_NAME, 4);
        return sharedPreferences.getInt(MDLOG_SP_KEY_CONSOLE_OPEN, n);
    }

    public static String compressLogFiles() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("_yyyyMMdd_HH_mm");
        String string = simpleDateFormat.format(date);
        File file = new File(MDLogSetter.getMDLogPath().getAbsolutePath() + "/logbak");
        if (!file.exists()) {
            file.mkdirs();
        }
        String string2 = file.getAbsolutePath() + "/log_" + string + ".zip";
        MDLogSetter.zipMDLogFiles(MDLogSetter.getLogPath(), string2);
        return string2;
    }

    private static void zipMDLogFiles(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile() || !fileArray[i].getName().endsWith("xlog")) continue;
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                zipOutputStream.putNextEntry(new ZipEntry(file.getName() + File.separator + fileArray[i].getName()));
                int n = 0;
                while ((n = ((InputStream)fileInputStream).read()) != -1) {
                    zipOutputStream.write(n);
                }
                ((InputStream)fileInputStream).close();
            }
        }
        zipOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getProcessNameInternal(Context context) {
        Object object2;
        int n = Process.myPid();
        if (context == null || n <= 0) {
            return "";
        }
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = null;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        try {
            for (Object object2 : activityManager.getRunningAppProcesses()) {
                if (((ActivityManager.RunningAppProcessInfo)object2).pid != n) continue;
                runningAppProcessInfo = object2;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (runningAppProcessInfo != null) {
            return runningAppProcessInfo.processName;
        }
        Object object3 = new byte[128];
        object2 = null;
        try {
            object2 = new FileInputStream("/proc/" + n + "/cmdline");
            int n2 = ((FileInputStream)object2).read((byte[])object3);
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    if (object3[i] <= 128 && object3[i] > 0) continue;
                    n2 = i;
                    break;
                }
                String string = new String((byte[])object3, 0, n2);
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (object2 != null) {
                    ((FileInputStream)object2).close();
                }
            }
            catch (Exception exception) {}
        }
        return "";
    }

    public static final File getMDLogPath() {
        File file = new File(Environment.getExternalStorageDirectory().getAbsolutePath(), "mdlog");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

