/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.content.Context;
import android.text.TextUtils;
import com.core.glcore.util.DateSerializer;
import com.core.glcore.util.FileUtil;
import com.core.glcore.util.IntSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.mm.mdlog.MDLog;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Date;

public class JsonUtil {
    private static JsonUtil instance = new JsonUtil();
    private Gson gson;
    private GsonBuilder builder;

    private JsonUtil() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Integer.TYPE, (Object)new IntSerializer());
        gsonBuilder.registerTypeAdapter(Integer.class, (Object)new IntSerializer());
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateSerializer());
        gsonBuilder.serializeNulls();
        this.gson = gsonBuilder.create();
    }

    public static Gson buildInGson() {
        return JsonUtil.getInstance().gson;
    }

    public static JsonUtil getInstance() {
        return instance;
    }

    public String toJson(Object object) {
        return this.gson.toJson(object);
    }

    public <T> T fromJson(String string, Class<T> clazz) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return (T)string;
        }
        return (T)this.gson.fromJson(string, clazz);
    }

    public <T> T fromJson(JsonElement jsonElement, Class<T> clazz) {
        if (jsonElement == null) {
            return null;
        }
        return (T)this.gson.fromJson(jsonElement, clazz);
    }

    public <T> T fromJson(String string, Type type) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (type.equals(String.class)) {
            return (T)string;
        }
        Object object = this.gson.fromJson(string, type);
        return (T)object;
    }

    public <T> T fromJson(JsonElement jsonElement, Type type) {
        return (T)this.gson.fromJson(jsonElement, type);
    }

    public String jsonStringFromRawFile(Context context, int n) {
        return FileUtil.readString(context.getResources().openRawResource(n), "UTF-8");
    }

    public String jsonStringFromFile(Context context, String string) {
        return FileUtil.readString(string);
    }

    public <T> T jsonObjectFromRawFile(Context context, int n, Class<T> clazz) {
        return this.fromJson(this.jsonStringFromRawFile(context, n), clazz);
    }

    public <T> T jsonObjectFromRawFile(Context context, int n, Type type) {
        return this.fromJson(this.jsonStringFromRawFile(context, n), type);
    }

    public <T> T jsonObjectFromFilePath(Context context, String string, Type type) {
        return this.fromJson(FileUtil.readString(string), type);
    }

    public <T> T fromJson(Reader reader, Class<T> clazz) {
        return (T)this.gson.fromJson(reader, clazz);
    }

    public void registerTypeAdapter(Type type, Object object) {
        this.builder.registerTypeAdapter(type, object);
        this.gson = this.builder.create();
    }

    public static void registerAdapter(Type type, JsonDeserializer jsonDeserializer) {
        try {
            JsonUtil.getInstance().registerTypeAdapter(type, jsonDeserializer);
        }
        catch (Exception exception) {
            MDLog.e((String)"json util", (String)"registerAdapter", (Object[])new Object[]{exception});
        }
    }
}

