/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.view.Display;
import android.view.View;
import com.core.glcore.config.Size;
import com.core.glcore.cv.MMCVImageInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageFrame;
import com.core.glcore.util.PngImageDecoder;
import com.mm.mdlog.MDLog;
import com.momocv.imgloader.ImageLoader;
import com.momocv.imgloader.ImageLoaderInfo;
import com.momocv.imgloader.ImageLoaderParams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class ImageUtils {
    private static final String TAG = "ImageUtils";

    public static void storeImage(Bitmap bitmap, File file) {
        if (file == null) {
            MDLog.d((String)TAG, (String)"Error creating media file, check storage permissions: ");
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            MDLog.e((String)TAG, (String)("File not found: " + fileNotFoundException.getMessage()));
        }
        catch (IOException iOException) {
            MDLog.e((String)TAG, (String)("Error accessing file: " + iOException.getMessage()));
        }
    }

    public static void storeImageToSystemLib(Bitmap bitmap, Context context) {
        MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (Bitmap)bitmap, (String)"title", (String)"description");
    }

    public static int getBitmapWidth(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return 0;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        return options.outWidth;
    }

    public static Size getBitmapSize(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        return new Size(options.outWidth, options.outHeight);
    }

    public static byte[] bitmap2Bytes(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @SuppressLint(value={"NewApi"})
    public static int getScreenHeight(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point point = new Point();
            display.getSize(point);
            return point.y;
        }
        return display.getHeight();
    }

    @SuppressLint(value={"NewApi"})
    public static int getScreenWidth(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point point = new Point();
            display.getSize(point);
            return point.x;
        }
        return display.getWidth();
    }

    public static Bitmap getBitmapFromView(View view, int n, int n2) {
        int n3 = View.MeasureSpec.makeMeasureSpec((int)n, (int)0x40000000);
        int n4 = View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
        view.measure(n3, n4);
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        return bitmap;
    }

    public static Bitmap decodeBitmapWithUri(Uri uri, Context context, int n, boolean bl) {
        String string = ImageUtils.getRealPathFromUri(uri, context);
        return ImageUtils.decodeBitmap(string, n, true);
    }

    public static Bitmap decodeBitmap(String string, int n, boolean bl) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        int n2 = options.outWidth;
        int n3 = options.outHeight;
        float f = Math.min(n3, n2) < n ? 1.0f : (float)Math.max(n2, n3) / (float)n;
        if (f < 0.0f && !bl) {
            return BitmapFactory.decodeFile((String)string);
        }
        options.inSampleSize = (int)f;
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        if (null == bitmap) {
            return null;
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((float)n2 / f)), (int)((int)((float)n3 / f)), (boolean)true);
    }

    public static Bitmap decodeBitmap(Bitmap bitmap, int n) {
        int n2;
        if (bitmap == null) {
            return null;
        }
        int n3 = bitmap.getWidth();
        if (Math.max(n3, n2 = bitmap.getHeight()) <= n) {
            return bitmap;
        }
        float f = Math.max(n3, n2) / n;
        Matrix matrix = new Matrix();
        matrix.setScale(f, f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static String getRealPathFromUri(Uri uri, Context context) {
        String[] stringArray = new String[]{"_data"};
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(uri, stringArray, null, null, null);
        int n = cursor.getColumnIndexOrThrow("_data");
        cursor.moveToFirst();
        return cursor.getString(n);
    }

    public static int[] getScaleSizeOfBitMap(String string) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        int n = 0;
        int n2 = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BitmapFactory.decodeStream((InputStream)new FileInputStream(string), null, (BitmapFactory.Options)options);
            n = options.outWidth;
            n2 = options.outHeight;
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return new int[]{n, n2};
    }

    public static float getFitScreenScale(Bitmap bitmap, int n) {
        int n2 = bitmap.getWidth();
        return n2 / n;
    }

    public static int getBitmapDegree(String string) {
        int n = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(string);
            int n2 = exifInterface.getAttributeInt("Orientation", 1);
            switch (n2) {
                case 6: {
                    n = 90;
                    break;
                }
                case 3: {
                    n = 180;
                    break;
                }
                case 8: {
                    n = 270;
                }
            }
        }
        catch (IOException iOException) {
            MDLog.printErrStackTrace((String)"getImageSpinAngle", (Throwable)iOException);
        }
        return n;
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, float f) {
        if (bitmap == null || f == 0.0f) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        matrix.postRotate(f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap addIconToBackground(Context context, int n, Bitmap bitmap) {
        Bitmap bitmap2 = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        Bitmap bitmap3 = bitmap;
        if (!bitmap2.isMutable()) {
            bitmap2 = bitmap2.copy(Bitmap.Config.ARGB_8888, true);
        }
        Paint paint = new Paint();
        Canvas canvas = new Canvas(bitmap2);
        int n2 = bitmap2.getWidth();
        int n3 = bitmap2.getHeight();
        int n4 = n2 - 20;
        int n5 = n3 - 20;
        int n6 = (n2 - n4) / 2;
        int n7 = (n3 - n5) / 2;
        Rect rect = new Rect(0, 0, bitmap3.getWidth(), bitmap3.getHeight());
        Rect rect2 = new Rect(n6, n7, n4, n5);
        canvas.drawBitmap(bitmap3, rect, rect2, paint);
        canvas.save();
        canvas.restore();
        return bitmap2;
    }

    private static Rect getBitmapRectCenterInsideHelper(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        double d;
        double d2;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        if (n3 < n) {
            d3 = (double)n3 / (double)n;
        }
        if (n4 < n2) {
            d4 = (double)n4 / (double)n2;
        }
        if (d3 != Double.POSITIVE_INFINITY || d4 != Double.POSITIVE_INFINITY) {
            if (d3 <= d4) {
                d2 = n3;
                d = (double)n2 * d2 / (double)n;
            } else {
                d = n4;
                d2 = (double)n * d / (double)n2;
            }
        } else {
            d = n2;
            d2 = n;
        }
        if (d2 == (double)n3) {
            n6 = 0;
            n5 = (int)Math.round(((double)n4 - d) / 2.0);
        } else if (d == (double)n4) {
            n6 = (int)Math.round(((double)n3 - d2) / 2.0);
            n5 = 0;
        } else {
            n6 = (int)Math.round(((double)n3 - d2) / 2.0);
            n5 = (int)Math.round(((double)n4 - d) / 2.0);
        }
        Rect rect = new Rect(n6, n5, n6 + (int)Math.ceil(d2), n5 + (int)Math.ceil(d));
        return rect;
    }

    public static Bitmap getCroppedImage(Bitmap bitmap, int n, int n2) {
        float f = bitmap.getWidth();
        float f2 = bitmap.getHeight();
        float f3 = f / f2;
        float f4 = (float)n / (float)n2;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (f3 > f4) {
            f8 = f2;
            f7 = f8 * f4;
            f5 = (f - f7) / 2.0f;
            f6 = 0.0f;
        } else {
            f7 = f;
            f8 = f7 / f4;
            f6 = (f2 - f8) / 2.0f;
            f5 = 0.0f;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)f5), (int)((int)f6), (int)((int)f7), (int)((int)f8));
        return bitmap2;
    }

    public static boolean isEdgeColorBitmap(Bitmap bitmap) {
        int n;
        int n2;
        int n3;
        int n4 = bitmap.getWidth();
        int n5 = bitmap.getHeight();
        int n6 = (n4 + n5) * 2;
        int[] nArray = new int[n6];
        int n7 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n7] = ImageUtils.rgbToGray(bitmap.getPixel(n3, 0));
            nArray[++n7] = ImageUtils.rgbToGray(bitmap.getPixel(n3, n5 - 1));
            ++n7;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            nArray[n7] = ImageUtils.rgbToGray(bitmap.getPixel(0, n3));
            nArray[++n7] = ImageUtils.rgbToGray(bitmap.getPixel(n4 - 1, n3));
            ++n7;
        }
        int[] nArray2 = new int[256];
        for (n2 = 0; n2 < 256; ++n2) {
            nArray2[n2] = 0;
        }
        for (n2 = 0; n2 < n6; ++n2) {
            n = nArray[n2];
            int n8 = nArray2[n];
            nArray2[n] = ++n8;
        }
        Arrays.sort(nArray2);
        n2 = 0;
        for (n = 255; n > 252; --n) {
            n2 += nArray2[n];
        }
        return (double)((float)n2 / (float)n6) > 0.3;
    }

    public static int rgbToGray(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        int n5 = (int)((float)n2 * 0.299f + (float)n3 * 0.587f + (float)n4 * 0.114f);
        return n5;
    }

    public static Bitmap createEmotionBitMap(int n, int n2, Bitmap bitmap) {
        float f = bitmap.getWidth();
        float f2 = bitmap.getHeight();
        float f3 = (float)n / (float)n2;
        int n3 = (int)f;
        int n4 = (int)(f / f3);
        Bitmap bitmap2 = Bitmap.createBitmap((int)((int)f), (int)((int)(f / f3)), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawColor(-1);
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setAlpha(125);
        Rect rect = new Rect(0, 0, n3, n4);
        Rect rect2 = new Rect(0, (int)(((float)n4 - f2) / 2.0f), n3, n4 + (int)(((float)n4 - f2) / 2.0f));
        canvas.drawBitmap(bitmap, rect, rect2, null);
        return bitmap2;
    }

    public static Bitmap loadResizedImage(File file, int n, int n2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        int n3 = 1;
        while (options.outWidth / n3 > n || options.outHeight / n3 > n2) {
            ++n3;
        }
        Bitmap bitmap = null;
        Bitmap bitmap2 = null;
        if (n3 > 1) {
            double d;
            double d2;
            int n4;
            options = new BitmapFactory.Options();
            options.inSampleSize = --n3;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            options.inPurgeable = true;
            bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
            if (bitmap == null) {
                return null;
            }
            int n5 = bitmap.getWidth();
            if ((double)n5 / (double)n < (double)(n4 = bitmap.getHeight()) / (double)n2) {
                d2 = n2;
                d = d2 / (double)n4 * (double)n5;
            } else {
                d = n;
                d2 = d / (double)n5 * (double)n4;
            }
            bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)Math.round((float)d), (int)Math.round((float)d2), (boolean)true);
            bitmap.recycle();
            bitmap = bitmap2;
            System.gc();
        } else {
            bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
        }
        return ImageUtils.rotateImage(bitmap, file);
    }

    public static Bitmap getScaleBitmap(String string, int n, int n2) {
        return ImageUtils.loadResizedImage(new File(string), n, n2);
    }

    public static Bitmap rotateImage(Bitmap bitmap, File file) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        int n = 0;
        try {
            n = ImageUtils.getImageOrientation(file.getAbsolutePath());
            if (n != 0) {
                Matrix matrix = new Matrix();
                matrix.postRotate((float)n);
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                bitmap.recycle();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bitmap2;
    }

    private static int getImageOrientation(String string) {
        ExifInterface exifInterface = new ExifInterface(string);
        int n = exifInterface.getAttributeInt("Orientation", 1);
        switch (n) {
            case 1: {
                return 0;
            }
            case 6: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    public static Bitmap optimizeImageSize(File file, int n, int n2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        int n3 = options.outHeight;
        int n4 = options.outWidth;
        if (options.outWidth > options.outHeight) {
            n3 = options.outWidth;
            n4 = options.outHeight;
        }
        float f = 1.0f;
        if (n3 >= n2) {
            f = (float)n3 / (float)n2;
        } else if (n4 > n) {
            f = (float)n4 / (float)n;
        }
        int n5 = (int)((float)options.outWidth / f);
        int n6 = (int)((float)options.outHeight / f);
        Bitmap bitmap = null;
        Bitmap bitmap2 = null;
        if (f > 2.0f) {
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            options2.inSampleSize = (int)f;
            options2.inPreferredConfig = Bitmap.Config.ARGB_8888;
            bitmap2 = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options2);
        } else {
            bitmap2 = BitmapFactory.decodeFile((String)file.getAbsolutePath());
        }
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)n5, (int)n6, (boolean)true);
        if (!bitmap2.equals(bitmap) && !bitmap2.isRecycled()) {
            bitmap2.recycle();
        }
        if (bitmap == null || bitmap.isRecycled()) {
            bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
        }
        return ImageUtils.rotateImage(bitmap, file);
    }

    public static boolean saveImage(Bitmap bitmap, int n, File file) {
        if (file == null) {
            MDLog.e((String)TAG, (String)"Error creating media file, check storage permissions: ");
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, n, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            MDLog.e((String)TAG, (String)("File not found: " + fileNotFoundException.getMessage()));
            return false;
        }
        catch (IOException iOException) {
            MDLog.e((String)TAG, (String)("Error accessing file: " + iOException.getMessage()));
            return false;
        }
    }

    public static void decodeMMCVImage(MMFrameInfo mMFrameInfo, String string) {
        if (mMFrameInfo != null) {
            ImageFrame imageFrame = mMFrameInfo.getPngImage();
            if ((imageFrame = PngImageDecoder.imageLoad(string, imageFrame)) != null) {
                mMFrameInfo.setWidth(imageFrame.getWidth());
                mMFrameInfo.setHeight(imageFrame.getHeight());
                mMFrameInfo.setStep_(imageFrame.getWidth());
                mMFrameInfo.setPngImage(imageFrame);
            } else {
                MDLog.e((String)"ImageUtil", (String)"Decode one Image failed");
            }
        } else {
            MDLog.e((String)"ImageUtil", (String)"Decode one Image Error , mmcvImage is null");
        }
    }

    public static void decodeMMCVImage2(MMFrameInfo mMFrameInfo, String string) {
        MMCVImageInfo mMCVImageInfo = new MMCVImageInfo();
        mMCVImageInfo.setDstFormat_(4);
        ImageLoader.Load((String)string, (ImageLoaderParams)mMCVImageInfo.getImageLoaderParams(), (ImageLoaderInfo)mMCVImageInfo.getImageLoaderInfo());
        if (mMCVImageInfo.getMmframe() != null) {
            if (mMFrameInfo != null) {
                mMFrameInfo.setFrame(mMCVImageInfo.getMmframe());
            } else {
                MDLog.e((String)"ImageUtil", (String)"Decode one Image Error , mmcvImage is null");
            }
        }
    }
}

