/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.SystemClock;
import android.text.TextUtils;
import com.core.glcore.util.GLSurface;
import com.core.glcore.util.GpuBenmark;
import com.core.glcore.util.GpuBenmarkChangeListener;
import com.core.glcore.util.GpuBenmarkListener;
import com.core.glcore.util.PreferenceUtil;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GpuBenmarkUtils {
    public static final int GPU_BENMARK_HIGH = 1;
    public static final int GPU_BENMARK_MEDIUM = 2;
    public static final int GPU_BENMARK_LOWER = 3;
    private EGLConfig eglConfig = null;
    private EGLDisplay eglDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext eglContext = EGL14.EGL_NO_CONTEXT;
    private Context mContext;
    private GpuBenmark gpuBenmark;
    private GpuBenmarkChangeListener mGpuBenmarkChangeListener;
    private double mGpubenmarkValue;
    private int i;
    private final ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(3, 5, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(128));

    public GpuBenmarkUtils(Context context) {
        this.mContext = context;
    }

    public void setGpuBenmarkChangeListener(GpuBenmarkChangeListener gpuBenmarkChangeListener) {
        this.mGpuBenmarkChangeListener = gpuBenmarkChangeListener;
    }

    public int getGpuBenmark(boolean bl) {
        int n = PreferenceUtil.getGpuBenmarkLevel(this.mContext);
        if (bl && n != 0) {
            this.updata();
        }
        if (n == 0) {
            return this.judgeGpuLevelFast();
        }
        return n;
    }

    private void updata() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                GpuBenmarkUtils.this.i = 0;
                while (GpuBenmarkUtils.this.i < 3) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            GpuBenmarkUtils.this.gpuBenmark = new GpuBenmark();
                            GpuBenmarkUtils.this.gpuBenmark.setGpuBenmarkListener(new GpuBenmarkListener(){

                                @Override
                                public void getGpuBenmark(double d) {
                                    GpuBenmarkUtils.this.mGpubenmarkValue = GpuBenmarkUtils.this.mGpubenmarkValue + d / 3.0;
                                    if (GpuBenmarkUtils.this.i == 2) {
                                        int n = PreferenceUtil.getGpuBenmarkLevel(GpuBenmarkUtils.this.mContext);
                                        int n2 = GpuBenmarkUtils.this.judgeGpuLevel(GpuBenmarkUtils.this.mGpubenmarkValue);
                                        GpuBenmarkUtils.this.mGpuBenmarkChangeListener.getGpuBenmarkLevel(n2);
                                        if (n != n2) {
                                            PreferenceUtil.setGpuBenmarkLevel(GpuBenmarkUtils.this.mContext, n2);
                                        }
                                    }
                                    GpuBenmarkUtils.this.gpuBenmark.releaseGL();
                                }
                            });
                            GpuBenmarkUtils.this.gpuBenmark.startGpuBenmark();
                        }
                    };
                    GpuBenmarkUtils.this.poolExecutor.execute(runnable);
                    SystemClock.sleep((long)1000L);
                    GpuBenmarkUtils.this.i++;
                }
            }
        }, "live-media-GpuBenmarkUtils").start();
    }

    private int judgeGpuLevel(double d) {
        int n = this.getGLExtensions();
        if (n >= 77 && d <= 320.0) {
            return 1;
        }
        if (n >= 70 && d > 320.0 && d <= 500.0 || n >= 77) {
            return 2;
        }
        return 3;
    }

    private int judgeGpuLevelFast() {
        int n = this.getGLExtensions();
        if (n >= 77) {
            return 1;
        }
        if (n > 70 && n < 77) {
            return 2;
        }
        return 3;
    }

    private int getGLExtensions() {
        this.createGL();
        int n = 0;
        String string = GLES20.glGetString((int)7939);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String[] stringArray = string.split(" ");
            n = stringArray.length;
        }
        this.destroyGL();
        return n;
    }

    private void createGL() {
        this.eglDisplay = EGL14.eglGetDisplay((int)0);
        int[] nArray = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.eglDisplay, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
            throw new RuntimeException("EGL error " + EGL14.eglGetError());
        }
        int[] nArray2 = new int[]{12320, 32, 12321, 8, 12322, 8, 12323, 8, 12324, 8, 12352, 4, 12339, 4, 12344};
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray3 = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.eglDisplay, (int[])nArray2, (int)0, (EGLConfig[])eGLConfigArray, (int)0, (int)eGLConfigArray.length, (int[])nArray3, (int)0)) {
            throw new RuntimeException("EGL error " + EGL14.eglGetError());
        }
        this.eglConfig = eGLConfigArray[0];
        int[] nArray4 = new int[]{12440, 2, 12344};
        this.eglContext = EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])nArray4, (int)0);
        if (this.eglContext == EGL14.EGL_NO_CONTEXT) {
            throw new RuntimeException("EGL error " + EGL14.eglGetError());
        }
        GLSurface gLSurface = new GLSurface(512, 512);
        int[] nArray5 = new int[]{12375, gLSurface.viewport.width, 12374, gLSurface.viewport.height, 12344};
        gLSurface.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (int[])nArray5, (int)0);
        EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)gLSurface.eglSurface, (EGLSurface)gLSurface.eglSurface, (EGLContext)this.eglContext);
    }

    private void destroyGL() {
        EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
        this.eglContext = EGL14.EGL_NO_CONTEXT;
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
    }
}

