/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.opengl.GLES20;
import com.core.glcore.util.GLRenderer;
import com.core.glcore.util.GLSurface;
import com.core.glcore.util.GpuRenderListener;
import com.core.glcore.util.ShaderUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GpuBenmarkRenderer
extends GLRenderer {
    private static final String TAG = "TestRenderer";
    private int program;
    private int vPosition;
    private int uColor;
    private FloatBuffer vertices;
    private float[] verticals = new float[14400];
    private GpuRenderListener gpuRenderListener;
    private static final String verticesShader = "attribute vec2 vPosition;            \nvoid main(){                         \n   gl_Position = vec4(vPosition,0,1);\n}";
    private static final String fragmentShader = "precision mediump float;         \nuniform vec4 uColor;             \nvoid main(){                     \n   gl_FragColor = uColor;        \n}";

    public void setGpuRenderListener(GpuRenderListener gpuRenderListener) {
        this.gpuRenderListener = gpuRenderListener;
    }

    private FloatBuffer getVertices() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        int n = 0;
        double d = 0.15707963267948966;
        for (int i = 0; i < 180; i += 9) {
            double d2 = (double)i * Math.PI / 180.0;
            for (int j = 0; j < 360; j += 9) {
                double d3 = (double)j * Math.PI / 180.0;
                this.verticals[n++] = (float)((double)f + (double)f4 * Math.sin(d2 + d) * Math.cos(d3 + d));
                this.verticals[n++] = (float)((double)f2 + (double)f4 * Math.cos(d2 + d));
                this.verticals[n++] = (float)((double)f3 + (double)f4 * Math.sin(d2 + d) * Math.sin(d3 + d));
                this.verticals[n++] = (float)((double)f + (double)f4 * Math.sin(d2) * Math.cos(d3));
                this.verticals[n++] = (float)((double)f2 + (double)f4 * Math.cos(d2));
                this.verticals[n++] = (float)((double)f3 + (double)f4 * Math.sin(d2) * Math.sin(d3));
                this.verticals[n++] = (float)((double)f + (double)f4 * Math.sin(d2) * Math.cos(d3 + d));
                this.verticals[n++] = (float)((double)f2 + (double)f4 * Math.cos(d2));
                this.verticals[n++] = (float)((double)f3 + (double)f4 * Math.sin(d2) * Math.sin(d3 + d));
                this.verticals[n++] = (float)((double)f + (double)f4 * Math.sin(d2 + d) * Math.cos(d3 + d));
                this.verticals[n++] = (float)((double)f2 + (double)f4 * Math.cos(d2 + d));
                this.verticals[n++] = (float)((double)f3 + (double)f4 * Math.sin(d2 + d) * Math.sin(d3 + d));
                this.verticals[n++] = (float)((double)f + (double)f4 * Math.sin(d2 + d) * Math.cos(d3));
                this.verticals[n++] = (float)((double)f2 + (double)f4 * Math.cos(d2 + d));
                this.verticals[n++] = (float)((double)f3 + (double)f4 * Math.sin(d2 + d) * Math.sin(d3));
                this.verticals[n++] = (float)((double)f + (double)f4 * Math.sin(d2) * Math.cos(d3));
                this.verticals[n++] = (float)((double)f2 + (double)f4 * Math.cos(d2));
                this.verticals[n++] = (float)((double)f3 + (double)f4 * Math.sin(d2) * Math.sin(d3));
            }
        }
        this.vertices = ByteBuffer.allocateDirect(this.verticals.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer().put(this.verticals);
        this.vertices.position(0);
        return this.vertices;
    }

    @Override
    public void onCreated() {
        this.program = ShaderUtil.createProgram(verticesShader, fragmentShader);
        this.vPosition = GLES20.glGetAttribLocation((int)this.program, (String)"vPosition");
        this.uColor = GLES20.glGetUniformLocation((int)this.program, (String)"uColor");
        this.vertices = this.getVertices();
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onDrawFrame(GLSurface gLSurface) {
        double d = System.currentTimeMillis();
        GLES20.glClearColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        for (int i = 0; i < 1500; ++i) {
            GLES20.glUseProgram((int)this.program);
            GLES20.glVertexAttribPointer((int)this.vPosition, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.vertices);
            GLES20.glEnableVertexAttribArray((int)this.vPosition);
            GLES20.glUniform4f((int)this.uColor, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            GLES20.glDrawArrays((int)4, (int)0, (int)4800);
        }
        double d2 = System.currentTimeMillis();
        double d3 = d2 - d;
        this.gpuRenderListener.getRenderTime(d3);
    }

    @Override
    public void onDestroy() {
    }
}

