/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.NonNull;
import com.core.glcore.util.GLSurface;
import com.mm.mdlog.MDLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

public abstract class GLRenderer
extends Thread {
    private static final String TAG = "mediaRender";
    private EGLConfig eglConfig = null;
    private EGLDisplay eglDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext eglContext = EGL14.EGL_NO_CONTEXT;
    private ArrayBlockingQueue<Event> eventQueue;
    private final List<GLSurface> outputSurfaces;
    private boolean rendering;
    private boolean isRelease;

    public GLRenderer() {
        this.setName("GLRenderer-" + this.getId());
        this.outputSurfaces = new ArrayList<GLSurface>();
        this.rendering = false;
        this.isRelease = false;
        this.eventQueue = new ArrayBlockingQueue(100);
    }

    private boolean makeOutputSurface(GLSurface gLSurface) {
        try {
            switch (gLSurface.type) {
                case 0: {
                    int[] nArray = new int[]{12344};
                    gLSurface.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (Object)gLSurface.surface, (int[])nArray, (int)0);
                    break;
                }
                case 1: {
                    int[] nArray = new int[]{12375, gLSurface.viewport.width, 12374, gLSurface.viewport.height, 12344};
                    gLSurface.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (int[])nArray, (int)0);
                    break;
                }
                case 2: {
                    MDLog.w((String)TAG, (String)"nonsupport pixmap surface");
                    return false;
                }
                default: {
                    MDLog.w((String)TAG, (String)("surface type error " + gLSurface.type));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            MDLog.e((String)TAG, (String)"can't create eglSurface");
            gLSurface.eglSurface = EGL14.EGL_NO_SURFACE;
            return false;
        }
        return true;
    }

    public void addSurface(@NonNull GLSurface gLSurface) {
        Event event = new Event(1);
        event.param = gLSurface;
        if (!this.eventQueue.offer(event)) {
            MDLog.e((String)TAG, (String)"queue full");
        }
    }

    public void removeSurface(@NonNull GLSurface gLSurface) {
        Event event = new Event(2);
        event.param = gLSurface;
        if (!this.eventQueue.offer(event)) {
            MDLog.e((String)TAG, (String)"queue full");
        }
    }

    public void startRender() {
        if (!this.eventQueue.offer(new Event(3))) {
            MDLog.e((String)TAG, (String)"queue full");
        }
        if (this.getState() == Thread.State.NEW) {
            super.start();
        }
    }

    public void stopRender() {
        if (!this.eventQueue.offer(new Event(5))) {
            MDLog.e((String)TAG, (String)"queue full");
        }
    }

    public boolean postRunnable(@NonNull Runnable runnable) {
        Event event = new Event(6);
        event.param = runnable;
        if (!this.eventQueue.offer(event)) {
            MDLog.e((String)TAG, (String)"queue full");
            return false;
        }
        return true;
    }

    @Override
    public void start() {
        MDLog.w((String)TAG, (String)"Don't call this function");
    }

    public void requestRender() {
        this.eventQueue.offer(new Event(4));
    }

    public void createGL() {
        this.eglDisplay = EGL14.eglGetDisplay((int)0);
        int[] nArray = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.eglDisplay, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
            throw new RuntimeException("EGL error " + EGL14.eglGetError());
        }
        int[] nArray2 = new int[]{12320, 32, 12321, 8, 12322, 8, 12323, 8, 12324, 8, 12352, 4, 12339, 4, 12344};
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray3 = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.eglDisplay, (int[])nArray2, (int)0, (EGLConfig[])eGLConfigArray, (int)0, (int)eGLConfigArray.length, (int[])nArray3, (int)0)) {
            throw new RuntimeException("EGL error " + EGL14.eglGetError());
        }
        this.eglConfig = eGLConfigArray[0];
        int[] nArray4 = new int[]{12440, 2, 12344};
        this.eglContext = EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])nArray4, (int)0);
        if (this.eglContext == EGL14.EGL_NO_CONTEXT) {
            throw new RuntimeException("EGL error " + EGL14.eglGetError());
        }
        GLSurface gLSurface = new GLSurface(512, 512);
        int[] nArray5 = new int[]{12375, gLSurface.viewport.width, 12374, gLSurface.viewport.height, 12344};
        gLSurface.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (int[])nArray5, (int)0);
        EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)gLSurface.eglSurface, (EGLSurface)gLSurface.eglSurface, (EGLContext)this.eglContext);
    }

    public void destroyGL() {
        EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
        this.eglContext = EGL14.EGL_NO_CONTEXT;
        this.eglDisplay = EGL14.EGL_NO_DISPLAY;
    }

    private void render() {
        for (GLSurface gLSurface : this.outputSurfaces) {
            if (gLSurface.eglSurface == EGL14.EGL_NO_SURFACE && !this.makeOutputSurface(gLSurface)) continue;
            EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)gLSurface.eglSurface, (EGLSurface)gLSurface.eglSurface, (EGLContext)this.eglContext);
            GLES20.glViewport((int)gLSurface.viewport.x, (int)gLSurface.viewport.y, (int)gLSurface.viewport.width, (int)gLSurface.viewport.height);
            this.onDrawFrame(gLSurface);
            EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)gLSurface.eglSurface);
        }
    }

    @Override
    public void run() {
        MDLog.d((String)TAG, (String)(this.getName() + ": render create"));
        this.createGL();
        this.onCreated();
        block11: while (!this.isRelease) {
            try {
                Event event = this.eventQueue.take();
                switch (event.event) {
                    case 1: {
                        Object object = (GLSurface)event.param;
                        MDLog.d((String)TAG, (String)("add:" + object));
                        this.makeOutputSurface((GLSurface)object);
                        this.outputSurfaces.add((GLSurface)object);
                        continue block11;
                    }
                    case 2: {
                        Object object = (GLSurface)event.param;
                        MDLog.d((String)TAG, (String)("remove:" + object));
                        EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)((GLSurface)object).eglSurface);
                        this.outputSurfaces.remove(object);
                        continue block11;
                    }
                    case 3: {
                        this.rendering = true;
                        continue block11;
                    }
                    case 4: {
                        if (!this.rendering) continue block11;
                        this.onUpdate();
                        this.render();
                        continue block11;
                    }
                    case 5: {
                        this.rendering = false;
                        continue block11;
                    }
                    case 6: {
                        ((Runnable)event.param).run();
                        continue block11;
                    }
                    case 7: {
                        this.isRelease = true;
                        continue block11;
                    }
                }
                MDLog.e((String)TAG, (String)("event error: " + event));
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.onDestroy();
        for (GLSurface gLSurface : this.outputSurfaces) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)gLSurface.eglSurface);
            gLSurface.eglSurface = EGL14.EGL_NO_SURFACE;
        }
        this.destroyGL();
        this.eventQueue.clear();
        MDLog.d((String)TAG, (String)(this.getName() + ": render release"));
    }

    public void release() {
        if (this.eventQueue.offer(new Event(7))) {
            while (this.isAlive()) {
                try {
                    this.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public abstract void onCreated();

    public abstract void onUpdate();

    public abstract void onDrawFrame(GLSurface var1);

    public abstract void onDestroy();

    private static String getEGLErrorString() {
        return GLUtils.getEGLErrorString((int)EGL14.eglGetError());
    }

    private static class Event {
        static final int ADD_SURFACE = 1;
        static final int REMOVE_SURFACE = 2;
        static final int START_RENDER = 3;
        static final int REQ_RENDER = 4;
        static final int STOP_RENDER = 5;
        static final int RUNNABLE = 6;
        static final int RELEASE = 7;
        final int event;
        Object param;

        Event(int n) {
            this.event = n;
        }
    }
}

