/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.mm.mdlog.MDLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class GLESTools {
    public static final int NO_TEXTURE = -1;
    public static int FLOAT_SIZE_BYTES = 4;
    public static int SHORT_SIZE_BYTES = 2;

    public static String readTextFile(Resources resources, int n) {
        InputStream inputStream = resources.openRawResource(n);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return stringBuilder.toString();
    }

    public static int createProgram(Resources resources, int n, int n2) {
        String string = GLESTools.readTextFile(resources, n);
        String string2 = GLESTools.readTextFile(resources, n2);
        return GLESTools.createProgram(string, string2);
    }

    public static int createProgram(String string, String string2) {
        if (string == null || string2 == null) {
            throw new RuntimeException("invalid shader code");
        }
        int n = GLES20.glCreateShader((int)35633);
        int n2 = GLES20.glCreateShader((int)35632);
        GLES20.glShaderSource((int)n, (String)string);
        GLES20.glShaderSource((int)n2, (String)string2);
        int[] nArray = new int[1];
        GLES20.glCompileShader((int)n);
        GLES20.glGetShaderiv((int)n, (int)35713, (int[])nArray, (int)0);
        if (0 == nArray[0]) {
            throw new RuntimeException("vertext shader compile,failed:" + GLES20.glGetShaderInfoLog((int)n));
        }
        GLES20.glCompileShader((int)n2);
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
        if (0 == nArray[0]) {
            throw new RuntimeException("fragment shader compile,failed:" + GLES20.glGetShaderInfoLog((int)n2));
        }
        int n3 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n3, (int)n);
        GLES20.glAttachShader((int)n3, (int)n2);
        GLES20.glLinkProgram((int)n3);
        GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
        if (0 == nArray[0]) {
            throw new RuntimeException("link program,failed:" + GLES20.glGetProgramInfoLog((int)n3));
        }
        return n3;
    }

    public static void checkGlError(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            String string2 = string + ": glError 0x" + Integer.toHexString(n);
            MDLog.d((String)"mediaRender", (String)string2);
            throw new RuntimeException(string2);
        }
    }

    public static int loadTexture(Bitmap bitmap, int n) {
        int[] nArray = new int[1];
        if (n == -1) {
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            GLES20.glBindTexture((int)3553, (int)nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            GLES20.glBindTexture((int)3553, (int)0);
        } else {
            GLES20.glBindTexture((int)3553, (int)n);
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)bitmap);
            nArray[0] = n;
        }
        return nArray[0];
    }

    public static void createFrameBuff(int[] nArray, int[] nArray2, int n, int n2) {
        GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
        GLES20.glGenTextures((int)1, (int[])nArray2, (int)0);
        GLES20.glBindTexture((int)3553, (int)nArray2[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n, (int)n2, (int)0, (int)6408, (int)5121, null);
        GLESTools.checkGlError("createCamFrameBuff");
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glBindFramebuffer((int)36160, (int)nArray[0]);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)nArray2[0], (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLESTools.checkGlError("createCamFrameBuff");
    }
}

