/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    public static final String SD_PATH = Environment.getExternalStorageDirectory().getPath();
    public static final String FILE_CACHE_PATH = SD_PATH + "/cvmomo";
    public static final String FILE_TEMP_PATH = SD_PATH + "/cvmomo/temp";
    public static final String FILE_LOG_PATH = SD_PATH + "/cvmomo/log";
    public static final String FILE_AVATAR_PATH = SD_PATH + "/cvmomo/avatar";
    public static final String FILE_DRAFT_PATH = SD_PATH + "/cvmomo/draft";
    public static final String FILE_INSTALL_PATH = SD_PATH + "/cvmomo/install";
    public static String UTF_8 = "UTF-8";
    public static String GBK = "GBK";
    public static String ISO_8859_1 = "ISO-8859-1";

    public static File getUpdateApk(int n) {
        if (!new File(FILE_INSTALL_PATH).exists()) {
            new File(FILE_INSTALL_PATH).mkdirs();
        }
        return new File(FILE_INSTALL_PATH + "/liuxing_" + n + ".apk");
    }

    public static String getPhotoFileName() {
        Date date = new Date(System.currentTimeMillis());
        return date.getTime() + ".jpeg";
    }

    public static long getFileSize(File file, FileFilter fileFilter) {
        if (null == file || !file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        File[] fileArray = null == fileFilter ? file.listFiles() : file.listFiles(fileFilter);
        long l = 0L;
        for (File file2 : fileArray) {
            l += FileUtil.getFileSize(file2, fileFilter);
        }
        return l;
    }

    public static void deleteFile(File file, long l) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            if (System.currentTimeMillis() - file.lastModified() < l) {
                return;
            }
            file.delete();
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            FileUtil.deleteFile(file2);
        }
        file.delete();
    }

    public static void deleteFile(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            FileUtil.deleteFile(file2);
        }
        file.delete();
    }

    public static void deleteFile(String string) {
        FileUtil.deleteFile(new File(string));
    }

    public static List<String> getFilePathsByFile(File file, FilenameFilter filenameFilter) {
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        if (file.isFile()) {
            return Arrays.asList(file.getPath());
        }
        if (null == filenameFilter) {
            return Arrays.asList(file.list());
        }
        return Arrays.asList(file.list(filenameFilter));
    }

    public static List<String> getFilePathsByFile(File file) {
        return FileUtil.getFilePathsByFile(file, null);
    }

    public static List<String> getFilePathsByFile(String string) {
        return FileUtil.getFilePathsByFile(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream inputStream, String string) {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
            String string3 = stringBuilder.toString();
            StreamUtil.close(bufferedReader);
            return string3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            StreamUtil.close(bufferedReader);
        }
        return null;
    }

    public static String readString(String string) {
        return FileUtil.readString(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file) {
        if (null == file || !file.exists()) {
            return "";
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder((int)file.length());
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string);
            }
            String string2 = stringBuilder.toString();
            StreamUtil.close(bufferedReader);
            return string2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            StreamUtil.close(bufferedReader);
        }
        return "";
    }

    public static void writeString(String string, String string2) {
        FileUtil.writeString(new File(string), string2);
    }

    public static void writeString(File file, String string) {
        FileUtil.outString(file, string, null, false);
    }

    public static void appendString(File file, String string) {
        FileUtil.outString(file, string, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outString(File file, String string, String string2, boolean bl) {
        if (null == file || file.exists() && file.isDirectory()) {
            throw new IOException("\u590d\u5236\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, bl);
            fileOutputStream.write(null == string2 ? string.getBytes() : string.getBytes(string2));
        }
        catch (Throwable throwable) {
            StreamUtil.close(fileOutputStream);
            throw throwable;
        }
        StreamUtil.close(fileOutputStream);
    }

    public static void writeObject(String string, Object object) {
        FileUtil.writeObject(new File(string), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(File file, Object object) {
        if (null == file || file.exists() && file.isDirectory()) {
            throw new IOException("\u590d\u5236\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
        }
        BufferedOutputStream bufferedOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(object);
        }
        catch (Throwable throwable) {
            StreamUtil.close(objectOutputStream);
            StreamUtil.close(bufferedOutputStream);
            throw throwable;
        }
        StreamUtil.close(objectOutputStream);
        StreamUtil.close(bufferedOutputStream);
    }

    public static <T> T readObject(String string) {
        return FileUtil.readObject(new File(string));
    }

    public static <T> T readObject(File file) {
        Object object = null;
        BufferedInputStream bufferedInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            objectInputStream = new ObjectInputStream(bufferedInputStream);
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                classNotFoundException.printStackTrace();
                throw new IOException(classNotFoundException);
            }
            catch (Throwable throwable) {
                StreamUtil.close(objectInputStream);
                StreamUtil.close(bufferedInputStream);
                throw throwable;
            }
        }
        StreamUtil.close(objectInputStream);
        StreamUtil.close(bufferedInputStream);
        return (T)object;
    }

    public static void checkFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static boolean exist(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return new File(string).exists();
    }

    public static File getCacheDirectory(Context context) {
        File file = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            file = FileUtil.getExternalCacheDir(context);
        }
        if (file == null) {
            file = context.getCacheDir();
        }
        if (file == null) {
            file = context.getCacheDir();
        }
        return file;
    }

    private static File getExternalCacheDir(Context context) {
        File file = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File file2 = new File(new File(file, context.getPackageName()), "cache");
        if (!file2.exists()) {
            if (!file2.mkdirs()) {
                return null;
            }
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file2;
    }

    public static String FormetFileSize(long l) {
        if (l == 0L) {
            return "0.00B";
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.00");
        String string = "";
        string = l < 1024L ? decimalFormat.format((double)l) + "B" : (l < 0x100000L ? decimalFormat.format((double)l / 1024.0) + "K" : (l < 0x40000000L ? decimalFormat.format((double)l / 1048576.0) + "M" : decimalFormat.format((double)l / 1.073741824E9) + "G"));
        return string;
    }

    public static long getFileCount(File file) {
        long l = 0L;
        File[] fileArray = file.listFiles();
        l = fileArray.length;
        for (File file2 : fileArray) {
            if (!file2.isDirectory()) continue;
            l += FileUtil.getFileCount(file2);
            --l;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFileByPath(Context context, String string, Object object) {
        GsonBuilder gsonBuilder;
        GsonBuilder gsonBuilder2 = gsonBuilder = new GsonBuilder();
        synchronized (gsonBuilder2) {
            Gson gson = gsonBuilder.excludeFieldsWithModifiers(new int[]{128}).create();
            try {
                FileOutputStream fileOutputStream = context.openFileOutput(string, 0);
                String string2 = gson.toJson(object);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(string2);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) {
        block7: {
            if (null == file || null == file2) {
                return;
            }
            if (!file.exists() || file2.isDirectory()) {
                throw new IOException("\u590d\u5236\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
            }
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                StreamUtil.copy(fileInputStream, fileOutputStream);
                StreamUtil.close(fileOutputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break block7;
            }
            finally {
                StreamUtil.close(fileOutputStream);
                StreamUtil.close(fileInputStream);
            }
            StreamUtil.close(fileInputStream);
        }
    }

    public static void copyDir(String string, String string2) {
        new File(string2).mkdirs();
        File[] fileArray = new File(string).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            Object object2;
            if (fileArray[i].isFile()) {
                object2 = fileArray[i];
                object = new File(new File(string2).getAbsolutePath() + File.separator + fileArray[i].getName());
                FileUtil.copyFile((File)object2, (File)object);
            }
            if (!fileArray[i].isDirectory()) continue;
            object2 = string + fileArray[i].getName();
            object = string2 + "/" + fileArray[i].getName();
            FileUtil.copyDir((String)object2, (String)object);
        }
    }

    public static File copyFileToDir(File file, File file2) {
        if (null == file || null == file2) {
            return null;
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new IOException("\u590d\u5236\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027");
        }
        File file3 = new File(file2, file.getName());
        FileUtil.copyFile(file, file3);
        return file3;
    }

    public static String getChoosedPicturePath(Uri uri, Activity activity) {
        Object object;
        Object object2;
        String string = "";
        if (null == uri) {
            return "";
        }
        if (uri.toString().startsWith("content://")) {
            object2 = new String[]{"_data"};
            object = activity.managedQuery(uri, object2, null, null, null);
            int n = object.getColumnIndexOrThrow("_data");
            object.moveToFirst();
            string = object.getString(n);
        } else {
            string = uri.toString().startsWith("file://") ? uri.toString().substring("file://".length()) : uri.toString();
        }
        object2 = null;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        object = string.toLowerCase();
        if (((String)object).endsWith(".jpg") || ((String)object).endsWith(".png") || ((String)object).endsWith(".jpeg")) {
            object2 = string;
        }
        return object2;
    }

    public static File compressFile(Context context, String string, int n) {
        File file;
        File file2 = new File(Environment.getExternalStorageDirectory() + "/DCIM/photo");
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((file = new File(file2, System.currentTimeMillis() + ".jpg")).exists()) {
            file.delete();
        }
        try {
            ExifInterface exifInterface = new ExifInterface(string);
            int n2 = exifInterface.getAttributeInt("Orientation", 1);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            Bitmap bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            float f = 1280.0f;
            float f2 = 720.0f;
            int n3 = options.outHeight;
            int n4 = options.outWidth;
            int n5 = 1;
            if ((float)n3 > f || (float)n4 > f2) {
                int n6;
                int n7 = Math.round((float)n3 / f);
                int n8 = n5 = n7 > (n6 = Math.round((float)n4 / f2)) ? n7 : n6;
            }
            if (n5 < 1) {
                n5 = 1;
            }
            options.inSampleSize = n5;
            bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
            Matrix matrix = new Matrix();
            if (n != -1) {
                matrix.setRotate((float)n);
            } else {
                matrix.setRotate((float)FileUtil.readPictureDegree(string));
            }
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file.getPath());
            bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
            bitmap.recycle();
            bitmap2.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBitmap(Bitmap bitmap, String string) {
        if (bitmap != null) {
            File file = new File(string);
            if (file.exists()) {
                return;
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                bitmap.recycle();
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtil.close(fileOutputStream);
                    throw throwable;
                }
                StreamUtil.close(fileOutputStream);
            }
            StreamUtil.close(fileOutputStream);
        }
    }

    public static int readPictureDegree(String string) {
        int n = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(string);
            int n2 = exifInterface.getAttributeInt("Orientation", 1);
            switch (n2) {
                case 6: {
                    n = 90;
                    break;
                }
                case 3: {
                    n = 180;
                    break;
                }
                case 8: {
                    n = 270;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public static boolean delAllFile(String string) {
        boolean bl = false;
        File file = new File(string);
        if (!file.exists()) {
            return bl;
        }
        if (!file.isDirectory()) {
            return bl;
        }
        String[] stringArray = file.list();
        File file2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            file2 = string.endsWith(File.separator) ? new File(string + stringArray[i]) : new File(string + File.separator + stringArray[i]);
            if (file2.isFile()) {
                file2.delete();
            }
            if (!file2.isDirectory()) continue;
            FileUtil.delAllFile(string + "/" + stringArray[i]);
            FileUtil.delFolder(string + "/" + stringArray[i]);
            bl = true;
        }
        return bl;
    }

    public static String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String string = uri.getScheme();
        String string2 = null;
        if (string == null) {
            string2 = uri.getPath();
        } else if ("file".equals(string)) {
            string2 = uri.getPath();
        } else if ("content".equals(string) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int n;
            if (cursor.moveToFirst() && (n = cursor.getColumnIndex("_data")) > -1) {
                string2 = cursor.getString(n);
            }
            cursor.close();
        }
        return string2;
    }

    public static void delFolder(String string) {
        try {
            FileUtil.delAllFile(string);
            String string2 = string;
            string2 = string2.toString();
            File file = new File(string2);
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getRawDataFromFile(String string) {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            int n = fileInputStream.available();
            byArray = new byte[n];
            fileInputStream.read(byArray);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStrFromAssert(Context context, String string) {
        StringBuilder stringBuilder;
        block6: {
            AssetManager assetManager = context.getAssets();
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            stringBuilder = new StringBuilder();
            try {
                String string2;
                inputStream = assetManager.open(string);
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                }
                StreamUtil.close(bufferedReader);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break block6;
            }
            finally {
                StreamUtil.close(bufferedReader);
                StreamUtil.close(inputStream);
            }
            StreamUtil.close(inputStream);
        }
        return stringBuilder.toString();
    }

    static {
        if (!new File(FILE_CACHE_PATH).exists()) {
            new File(FILE_CACHE_PATH).mkdirs();
        }
        if (!new File(FILE_TEMP_PATH).exists()) {
            new File(FILE_TEMP_PATH).mkdirs();
        }
        if (!new File(FILE_INSTALL_PATH).exists()) {
            new File(FILE_INSTALL_PATH).mkdirs();
        }
        if (!new File(FILE_LOG_PATH).exists()) {
            new File(FILE_LOG_PATH).mkdirs();
        }
    }

    public static class ZipUtil {
        public static final String EXT = ".zip";
        private static final String BASE_DIR = "";
        private static final String PATH = File.separator;
        private static final int BUFFER = 1024;

        public static void decompress(String string) {
            File file = new File(string);
            ZipUtil.decompress(file);
        }

        public static void decompress(File file) {
            String string = file.getParent();
            ZipUtil.decompress(file, string);
        }

        public static void decompress(File file, File file2) {
            ZipUtil.decompress(new FileInputStream(file), file2);
        }

        public static void decompress(InputStream inputStream, File file) {
            CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, new CRC32());
            ZipInputStream zipInputStream = new ZipInputStream(checkedInputStream);
            ZipUtil.decompress(file, zipInputStream);
            zipInputStream.close();
        }

        public static void decompress(File file, String string) {
            ZipUtil.decompress(file, new File(string));
        }

        public static void decompress(String string, String string2) {
            File file = new File(string);
            ZipUtil.decompress(file, string2);
        }

        private static void decompress(File file, ZipInputStream zipInputStream) {
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.getName().contains("../")) {
                    throw new SecurityException("unsecurity zipfile!");
                }
                String string = file.getPath() + File.separator + zipEntry.getName();
                File file2 = new File(string);
                ZipUtil.fileProber(file2);
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                } else {
                    ZipUtil.decompressFile(file2, zipInputStream);
                }
                zipInputStream.closeEntry();
            }
        }

        private static void fileProber(File file) {
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                ZipUtil.fileProber(file2);
                file2.mkdir();
            }
        }

        private static void decompressFile(File file, ZipInputStream zipInputStream) {
            int n;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[1024];
            while ((n = zipInputStream.read(byArray, 0, 1024)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.close();
        }
    }

    public static class StreamUtil {
        private static int ioBufferSize = 1024;

        public static void close(InputStream inputStream) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public static void close(OutputStream outputStream) {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public static void close(Reader reader) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public static void close(Writer writer) {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public static int copy(InputStream inputStream, OutputStream outputStream) {
            int n;
            byte[] byArray = new byte[ioBufferSize];
            int n2 = 0;
            while ((n = inputStream.read(byArray, 0, ioBufferSize)) != -1) {
                outputStream.write(byArray, 0, n);
                n2 += n;
            }
            return n2;
        }

        public static int copy(Reader reader, Writer writer) {
            int n;
            char[] cArray = new char[ioBufferSize];
            int n2 = 0;
            while ((n = reader.read(cArray, 0, ioBufferSize)) >= 0) {
                writer.write(cArray, 0, n);
                n2 += n;
            }
            writer.flush();
            return n2;
        }
    }
}

