/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import com.core.glcore.cv.FaceRigDataInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.MMParamsInfo;
import com.core.glcore.util.FaceRigHandler;
import com.mm.mdlog.MDLog;
import com.momocv.FaceParams;
import com.momocv.facerig.FaceRig;
import com.momocv.facerigv2.FaceRigV2;
import com.momocv.facerigv2.FacerigV2Params;
import com.momocv.videoprocessor.VideoInfo;
import com.momocv.videoprocessor.VideoParams;
import com.momocv.videoprocessor.VideoProcessor;

public class FacerigHelper {
    private static volatile byte[] facerigData;
    private static volatile boolean useFacerig;
    private static FaceRigHandler faceRigHandler;
    private static volatile boolean started;
    private static FaceRig mFaceRig;
    private static FaceRigV2 mFaceRigV2;
    private static VideoProcessor mVideoProcessor;
    private static volatile int mProcCode;
    private static volatile int mDetectCode;
    private static volatile boolean showFaceRig;
    private static volatile boolean detectFace;
    private static volatile boolean facerigFeatureAchieved;
    private static volatile boolean cvModelLoaded;
    private static volatile boolean waiting;
    private static volatile boolean isSetFacerig;
    private static volatile boolean mUseAnimojiFaceRig;
    private static volatile boolean mFaceRigLoadSucesss;
    private static volatile boolean mFaceDetectLoadSucesss;
    private static volatile boolean mLoadSucess;
    private static volatile boolean mLoadMode;

    public static boolean isUseFacerig() {
        return useFacerig;
    }

    public static synchronized void setUseFacerig(boolean bl) {
        useFacerig = bl;
    }

    public static boolean isSetFacerig() {
        return isSetFacerig;
    }

    public static void setIsSetFacerig(boolean bl) {
        isSetFacerig = bl;
    }

    public static boolean isShowFaceRig() {
        return showFaceRig;
    }

    public static synchronized void release() {
        useFacerig = false;
        if (mFaceRig != null) {
            mFaceRig.Release();
            mFaceRig = null;
        }
        mProcCode = -1999;
        mDetectCode = -1999;
        showFaceRig = false;
        detectFace = false;
        facerigData = null;
        facerigFeatureAchieved = false;
        cvModelLoaded = false;
        waiting = false;
        if (started && faceRigHandler != null) {
            started = false;
            faceRigHandler.onStopFaceRigModel();
        }
    }

    public static synchronized void releseFaceRigInfo() {
        if (mUseAnimojiFaceRig) {
            if (mFaceRigV2 != null) {
                mFaceRigV2.Release();
                mFaceRigV2 = null;
            }
            if (mVideoProcessor != null) {
                mVideoProcessor.Release();
                mVideoProcessor = null;
            }
            mFaceRigLoadSucesss = false;
            mFaceDetectLoadSucesss = false;
            mLoadSucess = false;
            mLoadMode = false;
            mUseAnimojiFaceRig = false;
        }
    }

    public static void registerFaceRigHandler(FaceRigHandler faceRigHandler) {
        FacerigHelper.faceRigHandler = faceRigHandler;
    }

    public static void unregisterFaceRigHandler() {
        faceRigHandler = null;
    }

    public static synchronized FaceRigDataInfo process(MMFrameInfo mMFrameInfo, MMParamsInfo mMParamsInfo) {
        FaceRigDataInfo faceRigDataInfo = null;
        if (mUseAnimojiFaceRig) {
            faceRigDataInfo = FacerigHelper.processFacrigFrame(mMFrameInfo, mMParamsInfo);
        } else if (FacerigHelper.isUseFacerig()) {
            byte[] byArray;
            if (!started) {
                started = true;
                if (faceRigHandler != null) {
                    faceRigHandler.onStartFaceRigModel();
                }
            }
            if (mFaceRig == null) {
                mFaceRig = new FaceRig();
            }
            if (!cvModelLoaded && faceRigHandler != null) {
                byArray = faceRigHandler.onLoadFaceRigModel();
                byte[] byArray2 = faceRigHandler.onLoadFaModel();
                byte[] byArray3 = faceRigHandler.onLoadFdModel();
                if (byArray == null || byArray.length <= 0 || byArray3 == null || byArray3.length <= 0 || byArray2 == null || byArray2.length <= 0) {
                    MDLog.e((String)"FacerigHelper", (String)"cv model is null");
                    return null;
                }
                mFaceRig.LoadModel(byArray, byArray3, byArray2);
                cvModelLoaded = true;
            }
            if (!facerigFeatureAchieved && facerigData == null) {
                facerigFeatureAchieved = true;
                if (faceRigHandler != null && (byArray = faceRigHandler.onAssembleFaceRigFeature()) != null && byArray.length > 0) {
                    facerigData = (byte[])byArray.clone();
                }
            }
            int n = -100;
            faceRigDataInfo = new FaceRigDataInfo();
            if (!waiting && !detectFace) {
                long l = System.currentTimeMillis();
                mFaceRig.ProcessFrame(mMFrameInfo.getFrame(), (FaceParams)mMParamsInfo.getParams(), facerigData, faceRigDataInfo.info);
                n = faceRigDataInfo.getRetState();
                MDLog.v((String)"FacerigHelper", (String)"Proc : %d", (Object[])new Object[]{n});
                if (n != 0 && faceRigDataInfo.getFacerigScores() == null) {
                    faceRigDataInfo.info.facerig_scores_ = new float[36];
                }
                if ((n = n != -1 && n != 1 ? 0 : -1) != mProcCode) {
                    waiting = true;
                    mProcCode = n;
                    FacerigHelper.dispatchFaceRigStatusChanged(n == 0);
                }
                MDLog.v((String)"FaceRig", (String)"Proc %d : %d", (Object[])new Object[]{n, System.currentTimeMillis() - l});
            } else if (!waiting) {
                mFaceRig.DetectMeanFace(mMFrameInfo.getFrame(), (FaceParams)mMParamsInfo.getParams(), faceRigDataInfo.info);
                int n2 = faceRigDataInfo.getMeanState();
                MDLog.e((String)"FaceRig", (String)"DetectMeanFace %d", (Object[])new Object[]{n2});
                if (n2 != mDetectCode) {
                    mDetectCode = n2;
                    if (faceRigHandler != null) {
                        faceRigHandler.onFaceDetect(n2);
                    }
                }
                if (n2 == 0) {
                    if (faceRigDataInfo.getFacerigFeature() != null && faceRigHandler != null) {
                        facerigData = faceRigDataInfo.getFacerigFeature();
                        faceRigHandler.onSaveFadeRigFeature(faceRigDataInfo.getFacerigFeature());
                    }
                    waiting = true;
                    mProcCode = 0;
                    FacerigHelper.dispatchFaceRigStatusChanged(true);
                }
            }
        }
        return faceRigDataInfo;
    }

    private static FaceRigDataInfo processFacrigFrame(MMFrameInfo mMFrameInfo, MMParamsInfo mMParamsInfo) {
        Object object;
        Object object2;
        Object object3;
        if (mMFrameInfo.getHeight() == 0 || mMFrameInfo.getWidth() == 0 || mMFrameInfo.getDataPtr() == null || mMFrameInfo.getDataPtr().length == 0) {
            return null;
        }
        if (mMFrameInfo.getFrame().format_ == 17 && (float)mMFrameInfo.getDataPtr().length < (float)(mMFrameInfo.getWidth() * mMFrameInfo.getHeight()) * 1.5f) {
            return null;
        }
        mMParamsInfo.setFaceAlignmentVersion(1);
        mMParamsInfo.setPose_estimation_type(2);
        if (mFaceRigV2 == null) {
            mFaceRigV2 = new FaceRigV2();
        }
        if (mVideoProcessor == null) {
            mVideoProcessor = new VideoProcessor();
        }
        if (!mLoadMode && faceRigHandler != null) {
            object3 = faceRigHandler.onLoadFaceRigModel();
            object2 = faceRigHandler.onLoadFaModel();
            object = faceRigHandler.onLoadFdModel();
            if (object3 == null || ((byte[])object3).length <= 0 || object == null || ((byte[])object).length <= 0 || object2 == null || ((byte[])object2).length <= 0) {
                MDLog.e((String)"FacerigHelper", (String)"cv model is null");
                return null;
            }
            if (!(mFaceRigLoadSucesss || mFaceDetectLoadSucesss || mLoadSucess)) {
                mLoadSucess = true;
                new Thread(new Runnable((byte[])object3, (byte[])object, (byte[])object2){
                    final /* synthetic */ byte[] val$buff;
                    final /* synthetic */ byte[] val$buff1;
                    final /* synthetic */ byte[] val$buff2;
                    {
                        this.val$buff = byArray;
                        this.val$buff1 = byArray2;
                        this.val$buff2 = byArray3;
                    }

                    @Override
                    public void run() {
                        mFaceRigLoadSucesss = mFaceRigV2.LoadModel(this.val$buff);
                        mVideoProcessor.LoadModel(this.val$buff1, this.val$buff2);
                        mLoadSucess = false;
                        mLoadMode = true;
                    }
                }).start();
            }
        }
        if (!mLoadMode) {
            return null;
        }
        mMParamsInfo.setFaceAlignmentVersion(1);
        object3 = new FaceRigDataInfo();
        object2 = new VideoInfo();
        object = new FacerigV2Params();
        object.rotate_degree_ = mMParamsInfo.getRotateDegree();
        object.restore_degree_ = mMParamsInfo.getRestoreDegree();
        mVideoProcessor.ProcessFrame(mMFrameInfo.getFrame(), (VideoParams)mMParamsInfo.getParams(), (VideoInfo)object2);
        ((FaceRigDataInfo)object3).setVideoInfo((VideoInfo)object2);
        if (object2.facesinfo_ != null && object2.facesinfo_.length > 0) {
            object.orig_landmarks_87_ = object2.facesinfo_[0].landmarks_87_;
            mFaceRigV2.ProcessFrame(mMFrameInfo.getFrame(), (FacerigV2Params)object, ((FaceRigDataInfo)object3).infoV2);
        }
        return object3;
    }

    private static void dispatchFaceRigStatusChanged(boolean bl) {
        if (faceRigHandler != null) {
            FaceRigHandler.FaceRigAnim faceRigAnim = new FaceRigHandler.FaceRigAnim(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void show() {
                    Class<FacerigHelper> clazz = FacerigHelper.class;
                    synchronized (FacerigHelper.class) {
                        detectFace = false;
                        showFaceRig = true;
                        waiting = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void hide() {
                    Class<FacerigHelper> clazz = FacerigHelper.class;
                    synchronized (FacerigHelper.class) {
                        detectFace = true;
                        showFaceRig = false;
                        waiting = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void resetFace() {
                    Class<FacerigHelper> clazz = FacerigHelper.class;
                    synchronized (FacerigHelper.class) {
                        detectFace = true;
                        mProcCode = -1999;
                        mDetectCode = -1999;
                        cvModelLoaded = false;
                        waiting = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            };
            faceRigHandler.onFaceRigStatusChanged(bl, faceRigAnim);
        }
    }

    public static void setUseAnimojiFaceRig(boolean bl) {
        mUseAnimojiFaceRig = bl;
    }

    public static boolean getUseAnimojiFaceRig() {
        return mUseAnimojiFaceRig;
    }

    static {
        mProcCode = -1999;
        mDetectCode = -1999;
        showFaceRig = false;
        detectFace = false;
        facerigFeatureAchieved = false;
        cvModelLoaded = false;
        waiting = false;
        mUseAnimojiFaceRig = false;
        mFaceRigLoadSucesss = false;
        mFaceDetectLoadSucesss = false;
        mLoadSucess = false;
        mLoadMode = false;
    }
}

