/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.text.TextUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;

public class DateSerializer
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    public JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive((Number)date.getTime());
    }

    public Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        if (!TextUtils.isEmpty((CharSequence)jsonElement.getAsString())) {
            if (jsonElement.getAsString().equals("NaN")) {
                return null;
            }
            if (jsonElement.getAsString().length() < 7) {
                return new Date(jsonElement.getAsLong() * 1000L);
            }
            return new Date(jsonElement.getAsLong());
        }
        return new Date();
    }
}

