/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.app.Activity;
import android.hardware.Camera;
import android.os.Build;
import com.core.glcore.config.MRCoreParameters;
import com.core.glcore.config.Size;

public class CameraUtil {
    public static int determineDisplayOrientation(Activity activity, int n) {
        int n2 = 0;
        if (Build.VERSION.SDK_INT > 8) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
            int n3 = CameraUtil.getRotationAngle(activity);
            if (cameraInfo.facing == 1) {
                n2 = (cameraInfo.orientation + n3) % 360;
                n2 = (360 - n2) % 360;
            } else {
                n2 = (cameraInfo.orientation - n3 + 360) % 360;
            }
        }
        return n2;
    }

    public static int getRotationAngle(Activity activity) {
        int n = activity.getWindowManager().getDefaultDisplay().getRotation();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
            }
        }
        return n2;
    }

    public static Size getDisplaySize(MRCoreParameters mRCoreParameters, int n) {
        int n2;
        int n3;
        if (n == 90 || n == 270) {
            n3 = mRCoreParameters.previewVideoWidth;
            n2 = mRCoreParameters.previewVideoHeight;
        } else {
            n2 = mRCoreParameters.previewVideoWidth;
            n3 = mRCoreParameters.previewVideoHeight;
        }
        int n4 = n2;
        int n5 = n3;
        int n6 = mRCoreParameters.visualWidth;
        int n7 = mRCoreParameters.visualHeight;
        float f = (float)n4 * 1.0f / (float)n6;
        float f2 = (float)n5 * 1.0f / (float)n7;
        float f3 = f < f2 ? f : f2;
        float f4 = (float)n6 * f3;
        float f5 = (float)n7 * f3;
        return new Size((int)f4, (int)f5);
    }

    public static Size getDisplaySize(Size size, Size size2, int n) {
        int n2;
        int n3;
        if (n == 90 || n == 270) {
            n3 = size.getWidth();
            n2 = size.getHeight();
        } else {
            n2 = size.getWidth();
            n3 = size.getHeight();
        }
        int n4 = n2;
        int n5 = n3;
        int n6 = size2.getWidth();
        int n7 = size2.getHeight();
        float f = (float)n4 * 1.0f / (float)n6;
        float f2 = (float)n5 * 1.0f / (float)n7;
        float f3 = f < f2 ? f : f2;
        float f4 = (float)n6 * f3;
        float f5 = (float)n7 * f3;
        return new Size((int)f4, (int)f5);
    }

    public static Size reScaleSize(Size size, Size size2, int n) {
        Size size3;
        Size size4;
        if (n == 90 || n == 270) {
            size4 = new Size(size.getHeight(), size.getWidth());
            size3 = size2;
        } else {
            size4 = size;
            size3 = size2;
        }
        Size size5 = CameraUtil.getDisplaySize(size4, size3, 0);
        int n2 = size5.getWidth() >> 4 << 4;
        int n3 = size5.getHeight() >> 4 << 4;
        return new Size(n2, n3);
    }

    public static Size rescalAspectRatio(Size size, int n, Size size2) {
        return CameraUtil.rescalAspectRatio(size, n, size2, true);
    }

    public static Size rescalAspectRatio(Size size, int n, Size size2, boolean bl) {
        Size size3;
        Size size4;
        if (n == 90 || n == 270) {
            size4 = new Size(size.getHeight(), size.getWidth());
            size3 = size2;
        } else {
            size4 = size;
            size3 = size2;
        }
        if (bl) {
            Size size5 = CameraUtil.getDisplaySize(size4, size3, 0);
            int n2 = size5.getWidth() >> 4 << 4;
            int n3 = size5.getHeight() >> 4 << 4;
            return new Size(n2, n3);
        }
        return CameraUtil.getDisplaySize(size4, size3, 0);
    }

    public static Size rescalAspectRatioBoth(Size size, int n, Size size2, boolean bl) {
        Size size3;
        Size size4;
        if (n == 90 || n == 270) {
            size4 = new Size(size.getHeight(), size.getWidth());
            size3 = new Size(size2.getHeight(), size2.getWidth());
        } else {
            size4 = size;
            size3 = size2;
        }
        if (bl) {
            Size size5 = CameraUtil.getDisplaySize(size4, size3, 0);
            int n2 = size5.getWidth() >> 4 << 4;
            int n3 = size5.getHeight() >> 4 << 4;
            return new Size(n2, n3);
        }
        return CameraUtil.getDisplaySize(size4, size3, 0);
    }
}

