/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.hardware.Camera;
import android.os.Build;
import com.core.glcore.config.MRCoreParameters;
import com.core.glcore.config.Size;
import com.core.glcore.util.Log4Cam;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class CameraHelper {
    public static int targetFps = 30000;
    private static int[] supportedSrcVideoFrameColorType = new int[]{17, 842094169};

    public static boolean configCamera(Camera camera, MRCoreParameters mRCoreParameters) {
        Camera.Parameters parameters = camera.getParameters();
        parameters.setWhiteBalance("auto");
        List list = parameters.getSupportedFocusModes();
        if (list != null) {
            if ((Build.MODEL.startsWith("GT-I950") || Build.MODEL.endsWith("SCH-I959") || Build.MODEL.endsWith("MEIZU MX3")) && list.contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
            } else if (list.contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else if (list.contains("auto")) {
                parameters.setFocusMode("auto");
            } else if (list.contains("fixed")) {
                parameters.setFocusMode("fixed");
            }
        }
        parameters.setPreviewSize(mRCoreParameters.previewVideoWidth, mRCoreParameters.previewVideoHeight);
        parameters.setPreviewFpsRange(mRCoreParameters.previewMinFps, mRCoreParameters.previewMaxFps);
        parameters.setPreviewFrameRate(mRCoreParameters.videoFPS);
        try {
            camera.setParameters(parameters);
        }
        catch (Exception exception) {
            Log4Cam.e(exception.getMessage());
            camera.release();
            return false;
        }
        return true;
    }

    public static void selectCameraFpsRange(Camera.Parameters parameters, MRCoreParameters mRCoreParameters) {
        int n;
        List list = parameters.getSupportedPreviewFpsRange();
        targetFps = mRCoreParameters.videoFPS * 1000;
        Collections.sort(list, new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                int n;
                int n2 = Math.abs(nArray[0] - targetFps) + Math.abs(nArray[1] - targetFps);
                if (n2 > (n = Math.abs(nArray2[0] - targetFps) + Math.abs(nArray2[1] - targetFps))) {
                    return 1;
                }
                if (n2 < n) {
                    return -1;
                }
                return 0;
            }
        });
        for (n = 0; n < list.size() && ((int[])list.get(n))[0] == ((int[])list.get(n))[1]; ++n) {
        }
        if (n >= list.size()) {
            n = 0;
        }
        mRCoreParameters.previewMinFps = ((int[])list.get(n))[0];
        mRCoreParameters.previewMaxFps = ((int[])list.get(n))[1];
    }

    public static void selectCameraPreviewWH(Camera.Parameters parameters, MRCoreParameters mRCoreParameters, Size size) {
        List list = parameters.getSupportedPreviewSizes();
        Collections.sort(list, new Comparator<Camera.Size>(){

            @Override
            public int compare(Camera.Size size, Camera.Size size2) {
                if (size.width * size.height > size2.width * size2.height) {
                    return 1;
                }
                return -1;
            }
        });
        for (Camera.Size size2 : list) {
            Log4Cam.e("width = " + size2.width + " height = " + size2.height);
        }
        int n = size.getWidth() * size.getHeight();
        int n2 = 0;
        int n3 = 0;
        for (Camera.Size size3 : list) {
            int n4 = size3.width * size3.height - size.getWidth() * size.getHeight();
            if (mRCoreParameters.scaleMode != 0 ? mRCoreParameters.scaleMode == 1 && (float)size3.height * mRCoreParameters.scaleRatio > (float)size3.width : (float)size3.width / mRCoreParameters.scaleRatio > (float)size3.height) continue;
            if (Math.abs(n4) < n) {
                if (size3.width > size.getWidth() && size3.height > size.getHeight()) continue;
                n = Math.abs(n4);
                n2 = size3.width;
                n3 = size3.height;
                continue;
            }
            if (Math.abs(n4) != n || n2 >= size3.width) continue;
            n2 = size3.width;
            n3 = size3.height;
        }
        if (n2 == 0 || n3 == 0) {
            n2 = ((Camera.Size)list.get((int)0)).width;
            n3 = ((Camera.Size)list.get((int)0)).height;
        }
        if (n2 != 0 && n3 != 0) {
            mRCoreParameters.previewVideoWidth = n2;
            mRCoreParameters.previewVideoHeight = n3;
        }
        Log4Cam.e("targetWidth = " + size.getWidth() + " targetHeight = " + size.getHeight() + " preferWidth = " + n2 + " preferHeight = " + n3);
    }

    public static boolean selectCameraColorFormat(Camera.Parameters parameters, MRCoreParameters mRCoreParameters) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        List list = parameters.getSupportedPreviewFormats();
        for (int n : supportedSrcVideoFrameColorType) {
            if (!list.contains(n)) continue;
            linkedList.add(n);
        }
        mRCoreParameters.previewColorFormat = 17;
        if (linkedList.contains(17)) {
            mRCoreParameters.previewColorFormat = 17;
        } else {
            mRCoreParameters.previewColorFormat = 842094169;
            if (linkedList.contains(842094169)) {
                mRCoreParameters.previewColorFormat = 842094169;
            } else {
                Log4Cam.e("!!!!!!!!!!!UnSupport,previewColorFormat");
                return false;
            }
        }
        return true;
    }

    public static int determineDisplayOrientation(int n, int n2) {
        int n3 = 0;
        if (Build.VERSION.SDK_INT > 8) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing == 1) {
                n3 = (cameraInfo.orientation + n) % 360;
                n3 = (360 - n3) % 360;
            } else {
                n3 = (cameraInfo.orientation - n + 360) % 360;
            }
        }
        return n3;
    }

    public static Size seletecMatchSize(List<Size> list, Size size, int n, float f) {
        if (list == null) {
            return null;
        }
        int n2 = size.getWidth() * size.getHeight();
        int n3 = 0;
        int n4 = 0;
        for (Size size2 : list) {
            int n5 = size2.getWidth() * size2.getHeight() - size.getWidth() * size.getHeight();
            if (n != 0 ? n == 1 && (float)size2.getHeight() * f > (float)size2.getWidth() : (float)size2.getWidth() / f > (float)size2.getHeight()) continue;
            if (Math.abs(n5) < n2) {
                if (size2.getWidth() > size.getWidth() && size2.getHeight() > size.getHeight()) continue;
                n2 = Math.abs(n5);
                n3 = size2.getWidth();
                n4 = size2.getHeight();
                continue;
            }
            if (Math.abs(n5) != n2 || n3 >= size2.getWidth()) continue;
            n3 = size2.getWidth();
            n4 = size2.getHeight();
        }
        if (n4 != 0 && n3 != 0) {
            return new Size(n3, n4);
        }
        return null;
    }
}

