/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.os.Build;
import android.text.TextUtils;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.MMParamsInfo;
import com.core.glcore.util.ErrorDotStatistics;
import com.core.glcore.util.FileUtil;
import com.mm.mdlog.MDLog;
import com.mm.mmutil.task.ThreadUtils;
import com.momo.xeengine.bean.CVBodyInfo;
import com.momocv.MMJoint;
import com.momocv.bodylandmark.BodyLandmark;
import com.momocv.bodylandmark.BodyLandmarkParams;
import com.momocv.bodylandmark.BodyLandmarkPostInfo;
import java.util.ArrayList;
import java.util.List;

public class BodyLandHelper {
    private static BodyLandmark bodyLandmark;
    private static String modelPath;
    private static volatile boolean useBodyLand;
    private static volatile boolean isWhiteList;
    private static volatile boolean modelInitiated;
    private static int exitOpenCL;
    private static int qualcommCPU;

    public static boolean isUseBodyLand() {
        return useBodyLand;
    }

    public static String getModelPath() {
        return modelPath;
    }

    public static synchronized void setUseBodyLand(boolean bl) {
        useBodyLand = bl;
    }

    public static synchronized void setModelTypeAndPath(boolean bl, String string) {
        if (isWhiteList == bl && modelPath == string) {
            return;
        }
        if (FileUtil.exist(string)) {
            if (modelInitiated && bodyLandmark != null) {
                bodyLandmark.Release();
                bodyLandmark = null;
            }
            modelPath = string;
            isWhiteList = bl;
        }
    }

    public static synchronized void process(MMFrameInfo mMFrameInfo, MMParamsInfo mMParamsInfo, BodyLandmarkPostInfo bodyLandmarkPostInfo) {
        if (modelPath == null || bodyLandmarkPostInfo == null) {
            MDLog.e((String)"ImageProcess", (String)"The BodyLand modelPath is null or bodyLandmarkPostInfo is null !!!");
            return;
        }
        if (bodyLandmark == null) {
            bodyLandmark = new BodyLandmark();
            ThreadUtils.execute((int)2, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (bodyLandmark != null) {
                        modelInitiated = bodyLandmark.LoadModel(modelPath);
                        if (!modelInitiated) {
                            ErrorDotStatistics.getInstance().addErrInfo("[101014]The BodyLand mode lode failed !!!");
                            MDLog.e((String)"ImageProcess", (String)"The BodyLand mode lode failed !!!");
                        }
                    }
                }
            });
        }
        if (modelInitiated && bodyLandmark != null) {
            bodyLandmark.ProcessFrame(mMFrameInfo.getFrame(), (BodyLandmarkParams)mMParamsInfo.getParams(), bodyLandmarkPostInfo);
        }
    }

    public static synchronized void release() {
        if (bodyLandmark != null) {
            bodyLandmark.Release();
            bodyLandmark = null;
        }
        MDLog.e((String)"ImageProcess", (String)"The BodyLandHelper release !!!");
    }

    public static boolean rightHardware() {
        if (exitOpenCL == 0 || qualcommCPU == 0) {
            return false;
        }
        if (exitOpenCL == -1) {
            int n = exitOpenCL = FileUtil.exist("/system/vendor/lib/libOpenCL.so") ? 1 : 0;
        }
        if (qualcommCPU == -1) {
            String string = FileUtil.readString("/proc/cpuinfo");
            qualcommCPU = TextUtils.isEmpty((CharSequence)string) ? 0 : (string.toLowerCase().contains("qualcomm") || string.toLowerCase().contains("qcom") ? 1 : 0);
            String string2 = Build.HARDWARE;
            if (qualcommCPU == 0 && !TextUtils.isEmpty((CharSequence)string2)) {
                qualcommCPU = string2.toLowerCase().contains("qualcomm") || string2.toLowerCase().contains("qcom") ? 1 : 0;
            }
        }
        return exitOpenCL == 1 && qualcommCPU == 1;
    }

    public static List<CVBodyInfo> transBodyInfos(BodyLandmarkPostInfo bodyLandmarkPostInfo) {
        if (bodyLandmarkPostInfo == null) {
            return null;
        }
        MMJoint[][] mMJointArray = bodyLandmarkPostInfo.multi_person_;
        if (mMJointArray == null) {
            return null;
        }
        int n = mMJointArray.length;
        ArrayList<CVBodyInfo> arrayList = new ArrayList<CVBodyInfo>(n);
        for (MMJoint[] mMJointArray2 : mMJointArray) {
            int n2 = mMJointArray2.length;
            CVBodyInfo cVBodyInfo = new CVBodyInfo();
            cVBodyInfo.joints = new ArrayList(n2);
            for (MMJoint mMJoint : mMJointArray2) {
                MMJoint mMJoint2 = mMJoint;
                if (mMJoint2 == null) continue;
                CVBodyInfo.Joint joint = new CVBodyInfo.Joint();
                joint.x = mMJoint2.x_;
                joint.y = mMJoint2.y_;
                joint.score = mMJoint2.score_;
                cVBodyInfo.joints.add(joint);
            }
            arrayList.add(cVBodyInfo);
        }
        return arrayList;
    }

    static {
        exitOpenCL = -1;
        qualcommCPU = -1;
    }
}

