/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.util;

import android.graphics.Bitmap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BitmapPrivateProtocolUtil {
    private static final int HEAD_SIZE = 16;
    private static final int MAX_IMAGE_WIDTH = 2560;

    public static void saveBitmap(Bitmap bitmap, String string) {
        if (string == null || bitmap == null) {
            throw new NullPointerException("Bitmap or path is null");
        }
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BitmapInfo bitmapInfo = new BitmapInfo();
        bitmapInfo.width = bitmap.getWidth();
        bitmapInfo.height = bitmap.getHeight();
        Bitmap.Config config = bitmap.getConfig();
        bitmapInfo.colorSpace = config == null ? -1 : config.ordinal();
        bitmapInfo.dataSize = bitmap.getWidth() * bitmap.getHeight() * 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
        bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
        fileOutputStream.write(bitmapInfo.getBytes());
        byteBuffer.position(0);
        fileOutputStream.write(byteBuffer.array());
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static Bitmap getBitmap(String string) {
        Bitmap bitmap = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BitmapInfo bitmapInfo = BitmapPrivateProtocolUtil.getBitmapInfo(fileInputStream);
            if (bitmapInfo != null) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmapInfo.dataSize);
                fileInputStream.read(byteBuffer.array(), 0, byteBuffer.array().length);
                Bitmap.Config config = Bitmap.Config.values()[bitmapInfo.colorSpace >= 0 ? bitmapInfo.colorSpace : 0];
                bitmap = Bitmap.createBitmap((int)bitmapInfo.width, (int)bitmapInfo.height, (Bitmap.Config)config);
                byteBuffer.position(0);
                bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    private static BitmapInfo getBitmapInfo(FileInputStream fileInputStream) {
        try {
            byte[] byArray = new byte[16];
            fileInputStream.read(byArray);
            BitmapInfo bitmapInfo = new BitmapInfo();
            bitmapInfo.setData(byArray);
            if (bitmapInfo.dataSize == 0 || bitmapInfo.dataSize != bitmapInfo.width * bitmapInfo.height * 4) {
                return null;
            }
            if (bitmapInfo.width < 0 || bitmapInfo.height < 0) {
                return null;
            }
            return bitmapInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static class BitmapInfo {
        public int width;
        public int height;
        public int colorSpace;
        public int dataSize;

        public void setData(byte[] byArray) {
            this.width = this.convert(byArray, 0);
            this.height = this.convert(byArray, 1);
            this.colorSpace = this.convert(byArray, 2);
            this.dataSize = this.convert(byArray, 3);
        }

        public byte[] getBytes() {
            return ByteBuffer.allocate(16).putInt(this.width).putInt(this.height).putInt(this.colorSpace).putInt(this.dataSize).array();
        }

        private int convert(byte[] byArray, int n) {
            int n2 = n * 4;
            return byArray[3 + n2] & 0xFF | (byArray[2 + n2] & 0xFF) << 8 | (byArray[1 + n2] & 0xFF) << 16 | (byArray[0 + n2] & 0xFF) << 24;
        }
    }
}

