/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.cv;

import android.text.TextUtils;
import com.momocv.MMFrame;
import com.momocv.objectdetect.ObjectDetect;
import com.momocv.objectdetect.ObjectDetectInfo;
import com.momocv.objectdetect.ObjectDetectParams;

public class ObjectDetector {
    private ObjectDetect objectDetect;
    private String modelPath;

    private ObjectDetector() {
    }

    public static ObjectDetector getInstance() {
        return Singleton.sInstance;
    }

    public boolean loadModel(String string) {
        this.initObjectDetect();
        this.modelPath = string;
        return this.objectDetect.LoadModel(string);
    }

    public boolean loadModel(byte[] byArray) {
        this.initObjectDetect();
        return this.objectDetect.LoadModel(byArray);
    }

    public void objectDetect(MMFrame mMFrame, ObjectDetectParams objectDetectParams, ObjectDetectInfo objectDetectInfo) {
        this.objectDetect.ProcessFrame(mMFrame, objectDetectParams, objectDetectInfo);
    }

    private void initObjectDetect() {
        if (this.objectDetect == null) {
            this.objectDetect = new ObjectDetect();
        }
    }

    public void create() {
        this.initObjectDetect();
        if (!TextUtils.isEmpty((CharSequence)this.modelPath)) {
            this.loadModel(this.modelPath);
        }
    }

    public void release() {
        if (this.objectDetect != null) {
            this.objectDetect.Release();
            this.objectDetect = null;
        }
    }

    private static class Singleton {
        private static ObjectDetector sInstance = new ObjectDetector();

        private Singleton() {
        }
    }
}

