/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.cv;

import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.FaceRigDataInfo;
import com.core.glcore.util.BodyLandData;
import com.momocv.SingleFaceInfo;
import com.momocv.beauty.BodyWarpInfo;
import com.momocv.videoprocessor.VideoInfo;
import java.util.ArrayList;
import java.util.List;

public class MMCVInfo {
    public boolean isFrontCamera = false;
    public int cameraDegree = 0;
    public int restoreDegree = 0;
    public int width = 0;
    public int height = 0;
    public byte[] frameData;
    public FaceRigDataInfo singleFaceRigInfo;
    public VideoInfo videoInfo;
    public BodyLandData bodyLandData;
    public BodyWarpInfo bodyWarpInfo;
    private List<FaceAttributeInfo> faceAttributeInfoList = new ArrayList<FaceAttributeInfo>();
    float[][] faceModeViewMatrix;
    float[][] faceProjectionMatrixForOpengl;
    public float[] srcWarpPoints;
    public float[] dstWarpPoints;
    float[][] faceRects;
    float[][] originLandmarks96;
    float[][] originFaceRects;
    byte[][] features;

    public MMCVInfo() {
        this.videoInfo = new VideoInfo();
    }

    public void setVideoInfo(VideoInfo videoInfo) {
        this.videoInfo = videoInfo;
    }

    public FaceRigDataInfo getSingleFaceRigInfo() {
        return this.singleFaceRigInfo;
    }

    public void setSingleFaceRigInfo(FaceRigDataInfo faceRigDataInfo) {
        this.singleFaceRigInfo = faceRigDataInfo;
        if (faceRigDataInfo != null && faceRigDataInfo.videoInfo != null) {
            this.videoInfo = faceRigDataInfo.videoInfo;
            this.adjustMMCVInfo();
        }
    }

    public BodyLandData getBodyLandData() {
        return this.bodyLandData;
    }

    public void setBodyLandData(BodyLandData bodyLandData) {
        this.bodyLandData = bodyLandData;
    }

    public void setFrontCamera(boolean bl) {
        this.isFrontCamera = bl;
    }

    public void setCameraDegree(int n) {
        this.cameraDegree = n;
    }

    public void setRestoreDegree(int n) {
        this.restoreDegree = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BodyWarpInfo getBodyWarpInfo() {
        return this.bodyWarpInfo;
    }

    public void setBodyWarpInfo(BodyWarpInfo bodyWarpInfo) {
        this.bodyWarpInfo = bodyWarpInfo;
    }

    public void setFrameData(byte[] byArray) {
        this.frameData = byArray;
    }

    public float[] getSrcWarpPoints() {
        return this.srcWarpPoints;
    }

    public void setSrcWarpPoints(float[] fArray) {
        this.srcWarpPoints = fArray;
        this.videoInfo.src_warp_points_ = fArray;
    }

    public float[] getDstWarpPoints() {
        return this.dstWarpPoints;
    }

    public void setDstWarpPoints(float[] fArray) {
        this.dstWarpPoints = fArray;
        this.videoInfo.dst_warp_points_ = fArray;
    }

    public int getMaxFaceCnt() {
        if (this.videoInfo.facesinfo_ != null) {
            return this.videoInfo.facesinfo_.length;
        }
        return 0;
    }

    public boolean hasBodyWrapInfo() {
        if (this.bodyWarpInfo == null) {
            return false;
        }
        return this.bodyWarpInfo.src_warp_points_ != null && this.bodyWarpInfo.dst_warp_points_ != null;
    }

    public VideoInfo getVideoInfo() {
        return this.videoInfo;
    }

    public void adjustMMCVInfo() {
        this.adjustMMCVInfo(0);
    }

    public void adjustMMCVInfo(int n) {
        this.faceAttributeInfoList.clear();
        if (this.videoInfo != null && this.videoInfo.facesinfo_ != null) {
            int n2 = this.videoInfo.facesinfo_.length;
            this.faceModeViewMatrix = new float[n2][16];
            this.faceProjectionMatrixForOpengl = new float[n2][16];
            this.faceRects = new float[n2][4];
            this.originLandmarks96 = new float[n2][4];
            this.originFaceRects = new float[n2][4];
            this.srcWarpPoints = this.videoInfo.src_warp_points_;
            this.dstWarpPoints = this.videoInfo.dst_warp_points_;
            for (int i = 0; i < n2; ++i) {
                FaceAttributeInfo faceAttributeInfo = new FaceAttributeInfo();
                SingleFaceInfo singleFaceInfo = this.videoInfo.facesinfo_[i];
                faceAttributeInfo.setInfo(singleFaceInfo);
                if (this.videoInfo.faces_attributes_ != null && this.videoInfo.faces_attributes_.length > 0) {
                    faceAttributeInfo.setAttribute(this.videoInfo.faces_attributes_[i]);
                }
                this.faceAttributeInfoList.add(i, faceAttributeInfo);
                this.faceModeViewMatrix[i] = singleFaceInfo.modelview_matrix_;
                this.faceProjectionMatrixForOpengl[i] = singleFaceInfo.projection_matrix_opengl_;
                this.faceRects[i] = singleFaceInfo.face_rect_;
                this.originLandmarks96[i] = singleFaceInfo.orig_landmarks_96_;
                this.originFaceRects[i] = singleFaceInfo.orig_face_rect_;
                singleFaceInfo.orig_landmarks_104_ = singleFaceInfo.landmarks_104_;
                if (n != 0) {
                    if (this.videoInfo.faces_attributes_[i].warped_landmarks68_ != null) {
                        singleFaceInfo.landmarks_68_ = this.videoInfo.faces_attributes_[i].warped_landmarks68_;
                    }
                    if (this.videoInfo.faces_attributes_[i].warped_landmarks96_ != null) {
                        singleFaceInfo.landmarks_96_ = this.videoInfo.faces_attributes_[i].warped_landmarks96_;
                    }
                    if (this.videoInfo.faces_attributes_[i].warped_landmarks104_ != null) {
                        singleFaceInfo.landmarks_104_ = this.videoInfo.faces_attributes_[i].warped_landmarks104_;
                    }
                }
                if (singleFaceInfo.features_quality_ != 1 || singleFaceInfo.features_ == null || singleFaceInfo.features_.length <= 0) continue;
                if (this.features == null) {
                    this.features = new byte[n2][];
                }
                this.features[i] = singleFaceInfo.features_;
            }
        }
    }

    public FaceAttributeInfo getFaceAttributeInfo(int n) {
        if (n > this.faceAttributeInfoList.size()) {
            n = 0;
        }
        return this.faceAttributeInfoList.size() > 0 ? this.faceAttributeInfoList.get(n) : null;
    }

    public float[][] getFaceModeViewMatrix() {
        return this.faceModeViewMatrix;
    }

    public float[][] getFaceProjectionMatrixForOpengl() {
        return this.faceProjectionMatrixForOpengl;
    }

    public float[][] getFaceRects() {
        return this.faceRects;
    }

    public float[][] getOriginLandmarks96() {
        return this.originLandmarks96;
    }

    public float[][] getOriginFaceRects() {
        return this.originFaceRects;
    }

    public byte[][] getFeatures() {
        return this.features;
    }
}

