/*
 * Decompiled with CFR 0.152.
 */
package com.core.glcore.cv;

import android.text.TextUtils;
import com.core.glcore.cv.CVObjectDetector;
import com.momocv.MMFrame;
import com.momocv.handgesture.HandGesture;
import com.momocv.handgesture.HandGestureInfo;
import com.momocv.handgesture.HandGestureParams;

public class HandGestureDetector
extends CVObjectDetector {
    private HandGesture handGesture;
    private HandGestureParams handGestureParams = new HandGestureParams();
    private String modelPath;
    private int handGestureType = 0;

    public static HandGestureDetector getInstance() {
        return Singleton.sInstance;
    }

    @Override
    public synchronized boolean loadModel(String string) {
        this.modelPath = string;
        this.initHandGestureDetector();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return this.handGesture.LoadModel(string);
        }
        return false;
    }

    @Override
    public synchronized boolean loadModel(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        this.initHandGestureDetector();
        return this.handGesture.LoadModel(byArray);
    }

    @Override
    public synchronized void create() {
        this.initHandGestureDetector();
        if (!TextUtils.isEmpty((CharSequence)this.modelPath)) {
            this.loadModel(this.modelPath);
        }
    }

    @Override
    public synchronized void release() {
        if (this.handGesture != null) {
            this.handGesture.Release();
            this.handGesture = null;
        }
    }

    @Override
    public synchronized Object objectDetect(Object object) {
        MMFrame mMFrame = (MMFrame)object;
        this.handGestureParams.restore_degree_ = this.restoreDegree;
        this.handGestureParams.rotate_degree_ = this.rotateDegree;
        this.handGestureParams.fliped_show_ = this.isFlip;
        this.handGestureParams.handgesture_type_ = this.handGestureType;
        HandGestureInfo handGestureInfo = new HandGestureInfo();
        if (this.handGesture != null) {
            this.handGesture.ProcessFrame(mMFrame, this.handGestureParams, handGestureInfo);
            return handGestureInfo;
        }
        return null;
    }

    public void setHandGestureType(int n) {
        this.handGestureType = n;
    }

    private void initHandGestureDetector() {
        if (this.handGesture == null) {
            this.handGesture = new HandGesture();
        }
    }

    private static class Singleton {
        private static HandGestureDetector sInstance = new HandGestureDetector();

        private Singleton() {
        }
    }
}

